/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM548CopyAnAPIToANewerVersionThroughThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String apiNameTest = "APIM548PublisherTest";
    private final String apiOldVersion = "1.0.0";
    private final String apiNewVersion = "2.0.0";
    private APIPublisherRestClient apiPublisher;
    private String apiProviderName;
    private String apiProductionEndPointUrl;

    @Factory(dataProvider="userModeDataProvider")
    public APIM548CopyAnAPIToANewerVersionThroughThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiProductionEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiProviderName = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Copy An API To A Newer Version Through the Publisher Rest API")
    public void testCopyAnAPIToANewerVersionThroughThePublisherRest() throws Exception {
        String apiContextTest = "apim548PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTag = "tag548-1, tag548-2, tag548-3";
        String defaultVersion = "default_version";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM548PublisherTest", apiContextTest, "1.0.0", this.apiProviderName, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(apiTag);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefaultVersion("default_version");
        apiCreationRequestBean.setDefaultVersionChecked("default_version");
        apiCreationRequestBean.setBizOwner("api548b");
        apiCreationRequestBean.setBizOwnerMail("api548b@ee.com");
        apiCreationRequestBean.setTechOwner("api548t");
        apiCreationRequestBean.setTechOwnerMail("api548t@ww.com");
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject apiResponse = new JSONObject(apiCreationResponse.getData());
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when creating the API");
        Assert.assertFalse((boolean)apiResponse.getBoolean("error"), (String)"APIM548PublisherTestis not created as expected");
        HttpResponse apiResponsePublisher = this.apiPublisher.getAllAPIs();
        JSONObject jsonObject = new JSONObject(apiResponsePublisher.getData());
        Assert.assertFalse((boolean)jsonObject.getBoolean("error"), (String)"APIM548PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)jsonObject.getString("apis").contains("APIM548PublisherTest"), (String)"APIM548PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)jsonObject.getString("apis").contains("1.0.0"), (String)"Version of the APIM548PublisherTestis not a valid version");
        JSONObject jsonObjectCopy = new JSONObject(this.apiPublisher.copyAPI(this.apiProviderName, "APIM548PublisherTest", "1.0.0", "2.0.0", defaultVersion).getData());
        Assert.assertFalse((boolean)jsonObjectCopy.getBoolean("error"), (String)" New copy of the APIM548PublisherTest is not created as expected");
        HttpResponse allApiResponse = this.apiPublisher.getAllAPIs();
        JSONObject allApiObject = new JSONObject(allApiResponse.getData());
        JSONArray jsonArray = allApiObject.getJSONArray("apis");
        ArrayList<String> allApiList = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            String version = jsonArray.getJSONObject(i).getString("version");
            allApiList.add(version);
        }
        Assert.assertTrue((boolean)allApiList.contains("1.0.0"), (String)"Error in API getting:APIM548PublisherTest through publisher rest api");
        Assert.assertTrue((boolean)allApiList.contains("2.0.0"), (String)"Error in API getting:APIM548PublisherTest through publisher rest api");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.apiPublisher.deleteAPI("APIM548PublisherTest", "1.0.0", this.apiProviderName);
        this.apiPublisher.deleteAPI("APIM548PublisherTest", "2.0.0", this.apiProviderName);
        super.cleanUp();
    }
}

