/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM574ChangeTheStatusOfAnAPIToPrototypedThroughThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String apiNameTest = "APIM574PublisherTest";
    private final String apiVersion = "1.0.0";
    private APIPublisherRestClient apiPublisher;
    private String apiProvider;
    private String apiEndPointUrl;

    @Factory(dataProvider="userModeDataProvider")
    public APIM574ChangeTheStatusOfAnAPIToPrototypedThroughThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Create an API throgh the publisher rest API ")
    public void testCreateAnAPIThroughThePublisherRest() throws Exception {
        String apiContext = "apim574PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTags = "tag574-1, tag574-2, tag587-3";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM574PublisherTest", apiContext, "1.0.0", this.apiProvider, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags(apiTags);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefaultVersion("default_version");
        apiCreationRequestBean.setDefaultVersionChecked("default_version");
        apiCreationRequestBean.setBizOwner("api574b");
        apiCreationRequestBean.setBizOwnerMail("api574b@ee.com");
        apiCreationRequestBean.setTechOwner("api574t");
        apiCreationRequestBean.setTechOwnerMail("api574t@ww.com");
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject apiResponse = new JSONObject(apiCreationResponse.getData());
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when creating the API");
        Assert.assertFalse((boolean)apiResponse.getBoolean("error"), (String)"APIM574PublisherTestis not created as expected");
        HttpResponse apiResponsePublisher = this.apiPublisher.getAPI("APIM574PublisherTest", this.apiProvider, "1.0.0");
        JSONObject jsonObject = new JSONObject(apiResponsePublisher.getData());
        JSONObject apiObject = new JSONObject(jsonObject.getString("api"));
        Assert.assertFalse((boolean)jsonObject.getBoolean("error"), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)apiObject.getString("name").equals("APIM574PublisherTest"), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)apiObject.getString("status").equals("CREATED"), (String)"Status of the APIM574PublisherTestis not a valid status");
    }

    @Test(groups={"wso2.am"}, description="Change the status of the API to PROTOTYPED through the publisher rest API ", dependsOnMethods={"testCreateAnAPIThroughThePublisherRest"})
    public void testChangeTheStatusOfTheAPIToPrototyped() throws Exception {
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM574PublisherTest", this.apiProvider, APILifeCycleState.PROTOTYPED);
        updateRequest.setRequireResubscription("true");
        HttpResponse creationResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertTrue((boolean)creationResponse.getData().contains("PROTOTYPED"), (String)"APIM574PublisherTest  status not updated as Prototyped");
        HttpResponse prototypedApiResponse = this.apiPublisher.getAPI("APIM574PublisherTest", this.apiProvider, "1.0.0");
        JSONObject prototypedApiObject = new JSONObject(prototypedApiResponse.getData());
        JSONObject allApiObject = new JSONObject(prototypedApiObject.getString("api"));
        Assert.assertFalse((boolean)prototypedApiObject.getBoolean("error"), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)allApiObject.getString("name").equals("APIM574PublisherTest"), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)allApiObject.getString("status").equals("PROTOTYPED"), (String)"Status of the APIM574PublisherTestis not a valid status");
    }

    @Test(groups={"wso2.am"}, description="Change the status of the API to PUBLISHED through the publisher rest API ", dependsOnMethods={"testChangeTheStatusOfTheAPIToPrototyped"})
    public void testChangeTheStatusOfTheAPIToPublished() throws Exception {
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM574PublisherTest", this.apiProvider, APILifeCycleState.PUBLISHED);
        updateRequest.setRequireResubscription("true");
        HttpResponse creationResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertTrue((boolean)creationResponse.getData().contains("PUBLISHED"), (String)"APIM574PublisherTest  status not updated as Prototyped");
        HttpResponse prototypedApiResponse = this.apiPublisher.getAPI("APIM574PublisherTest", this.apiProvider, "1.0.0");
        JSONObject prototypedApiObject = new JSONObject(prototypedApiResponse.getData());
        JSONObject allApiObject = new JSONObject(prototypedApiObject.getString("api"));
        Assert.assertFalse((boolean)prototypedApiObject.getBoolean("error"), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)allApiObject.getString("name").equals("APIM574PublisherTest"), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)allApiObject.getString("status").equals("PUBLISHED"), (String)"Status of the APIM574PublisherTestis not a valid status");
    }

    @Test(groups={"wso2.am"}, description="Change the status of the API to DEPRECATED through the publisher rest API ", dependsOnMethods={"testChangeTheStatusOfTheAPIToPublished"})
    public void testChangeTheStatusOfTheAPIToDeprecated() throws Exception {
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM574PublisherTest", this.apiProvider, APILifeCycleState.DEPRECATED);
        updateRequest.setRequireResubscription("true");
        HttpResponse creationResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertTrue((boolean)creationResponse.getData().contains("DEPRECATED"), (String)"APIM574PublisherTest  status not updated as Prototyped");
        HttpResponse prototypedApiResponse = this.apiPublisher.getAPI("APIM574PublisherTest", this.apiProvider, "1.0.0");
        JSONObject prototypedApiObject = new JSONObject(prototypedApiResponse.getData());
        JSONObject allApiObject = new JSONObject(prototypedApiObject.getString("api"));
        Assert.assertFalse((boolean)prototypedApiObject.getBoolean("error"), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)allApiObject.getString("name").equals("APIM574PublisherTest"), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)allApiObject.getString("status").equals("DEPRECATED"), (String)"Status of the APIM574PublisherTestis not a valid status");
    }

    @Test(groups={"wso2.am"}, description="Change the status of the API to RETIRED through the publisher rest API ", dependsOnMethods={"testChangeTheStatusOfTheAPIToDeprecated"})
    public void testChangeTheStatusOfTheAPIToRetired() throws Exception {
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM574PublisherTest", this.apiProvider, APILifeCycleState.RETIRED);
        updateRequest.setRequireResubscription("true");
        HttpResponse creationResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertTrue((boolean)creationResponse.getData().contains("RETIRED"), (String)"APIM574PublisherTest  status not updated as Prototyped");
        HttpResponse prototypedApiResponse = this.apiPublisher.getAPI("APIM574PublisherTest", this.apiProvider, "1.0.0");
        JSONObject prototypedApiObject = new JSONObject(prototypedApiResponse.getData());
        JSONObject allApiObject = new JSONObject(prototypedApiObject.getString("api"));
        Assert.assertFalse((boolean)prototypedApiObject.getBoolean("error"), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)allApiObject.getString("name").equals("APIM574PublisherTest"), (String)"APIM574PublisherTest is not visible in publisher");
        Assert.assertTrue((boolean)allApiObject.getString("status").equals("RETIRED"), (String)"Status of the APIM574PublisherTestis not a valid status");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUp() throws Exception {
        this.apiPublisher.deleteAPI("APIM574PublisherTest", "1.0.0", this.apiProvider);
        super.cleanUp();
    }
}

