/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.generic.TestConfigurationProvider;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class APIM614AddDocumentationToAnAPIWithDocTypeSampleAndSDKThroughPublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM614PublisherTest";
    private final String apiVersion = "1.0.0";
    private APIPublisherRestClient apiPublisher;
    private String apiProvider;
    private String apiEndPointUrl;
    private HttpClient httpClient;
    private HttpPost httpPostLogin;

    @Factory(dataProvider="userModeDataProvider")
    public APIM614AddDocumentationToAnAPIWithDocTypeSampleAndSDKThroughPublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String loginUrl = this.publisherUrls.getWebAppURLHttp() + "publisher/site/blocks/user/login/ajax/login.jag";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.httpClient = HttpClients.createDefault();
        this.httpPostLogin = new HttpPost(loginUrl);
        ArrayList<BasicNameValuePair> loginValue = new ArrayList<BasicNameValuePair>();
        loginValue.add(new BasicNameValuePair("action", "login"));
        loginValue.add(new BasicNameValuePair("username", "admin"));
        loginValue.add(new BasicNameValuePair("password", "admin"));
        this.httpPostLogin.setEntity((HttpEntity)new UrlEncodedFormEntity(loginValue));
        HttpResponse loginResponse = this.httpClient.execute((HttpUriRequest)this.httpPostLogin);
        HttpEntity loginEntity = loginResponse.getEntity();
        JSONObject jsonObjectLogin = new JSONObject(EntityUtils.toString((HttpEntity)loginEntity));
        Assert.assertFalse((boolean)jsonObjectLogin.getBoolean("error"), (String)"Error when login to the Publisher Rest API using new client");
    }

    @Test(groups={"wso2.am"}, description="Create an API to update the documents with source type file  through the publisher rest API ")
    public void testApiCreation() throws Exception {
        String apiContext = "apim614PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTags = "tag614-1, tag622-2, tag624-3";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM614PublisherTest", apiContext, "1.0.0", this.apiProvider, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags(apiTags);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefaultVersion("default_version");
        apiCreationRequestBean.setDefaultVersionChecked("default_version");
        apiCreationRequestBean.setBizOwner("api620b");
        apiCreationRequestBean.setBizOwnerMail("api620b@ee.com");
        apiCreationRequestBean.setTechOwner("api620t");
        apiCreationRequestBean.setTechOwnerMail("api620t@ww.com");
        JSONObject jsonObject = new JSONObject(this.apiPublisher.addAPI(apiCreationRequestBean).getData());
        Assert.assertFalse((boolean)jsonObject.getBoolean("error"), (String)"APIM614PublisherTest is not created ");
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type HowTo And Source File through the publisher rest API ", dependsOnMethods={"testApiCreation"})
    public void testAddDocumentToAnAPIHowToFile() throws Exception {
        String fileNameAPIM614 = "APIM614.txt";
        String docName = "APIM614PublisherTestHowTo-File-summary";
        String docType = "How To";
        String sourceType = "file";
        String summary = "Testing";
        String mimeType = "text/plain";
        String docUrl = "http://";
        String filePathAPIM614 = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + fileNameAPIM614;
        String addDocUrl = this.publisherUrls.getWebAppURLHttp() + "publisher/site/blocks/documentation/ajax/docs.jag";
        HttpPost httppost = new HttpPost(addDocUrl);
        File file = new File(filePathAPIM614);
        FileBody fileBody = new FileBody(file, "text/plain");
        MultipartEntity multipartEntity = new MultipartEntity();
        multipartEntity.addPart("docLocation", (ContentBody)fileBody);
        multipartEntity.addPart("mode", (ContentBody)new StringBody(""));
        multipartEntity.addPart("docName", (ContentBody)new StringBody(docName));
        multipartEntity.addPart("docUrl", (ContentBody)new StringBody(docUrl));
        multipartEntity.addPart("sourceType", (ContentBody)new StringBody(sourceType));
        multipartEntity.addPart("summary", (ContentBody)new StringBody(summary));
        multipartEntity.addPart("docType", (ContentBody)new StringBody(docType));
        multipartEntity.addPart("version", (ContentBody)new StringBody("1.0.0"));
        multipartEntity.addPart("apiName", (ContentBody)new StringBody("APIM614PublisherTest"));
        multipartEntity.addPart("action", (ContentBody)new StringBody("addDocumentation"));
        multipartEntity.addPart("provider", (ContentBody)new StringBody(this.apiProvider));
        multipartEntity.addPart("mimeType", (ContentBody)new StringBody(mimeType));
        multipartEntity.addPart("optionsRadios", (ContentBody)new StringBody(docType));
        multipartEntity.addPart("optionsRadios1", (ContentBody)new StringBody(sourceType));
        multipartEntity.addPart("optionsRadios1", (ContentBody)new StringBody(sourceType));
        httppost.setEntity((HttpEntity)multipartEntity);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httppost);
        HttpEntity entity = response.getEntity();
        JSONObject jsonObject1 = new JSONObject(EntityUtils.toString((HttpEntity)entity));
        Assert.assertFalse((boolean)jsonObject1.getBoolean("error"), (String)"Error when adding files to the API ");
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type Sample SDK And Source File through the publisher rest API ", dependsOnMethods={"testAddDocumentToAnAPIHowToFile"})
    public void testAddDocumentToAnAPISDKToFile() throws Exception {
        String fileNameAPIM622 = "APIM622.txt";
        String docName = "APIM622PublisherTestHowTo-File-summary";
        String docType = "samples";
        String sourceType = "file";
        String summary = "Testing";
        String mimeType = "text/plain";
        String docUrl = "http://";
        String filePathAPIM622 = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + fileNameAPIM622;
        String addDocUrl = this.publisherUrls.getWebAppURLHttp() + "publisher/site/blocks/documentation/ajax/docs.jag";
        HttpPost httppost = new HttpPost(addDocUrl);
        File file = new File(filePathAPIM622);
        FileBody fileBody = new FileBody(file, "text/plain");
        MultipartEntity multipartEntity = new MultipartEntity();
        multipartEntity.addPart("docLocation", (ContentBody)fileBody);
        multipartEntity.addPart("mode", (ContentBody)new StringBody(""));
        multipartEntity.addPart("docName", (ContentBody)new StringBody(docName));
        multipartEntity.addPart("docUrl", (ContentBody)new StringBody(docUrl));
        multipartEntity.addPart("sourceType", (ContentBody)new StringBody(sourceType));
        multipartEntity.addPart("summary", (ContentBody)new StringBody(summary));
        multipartEntity.addPart("docType", (ContentBody)new StringBody(docType));
        multipartEntity.addPart("version", (ContentBody)new StringBody("1.0.0"));
        multipartEntity.addPart("apiName", (ContentBody)new StringBody("APIM614PublisherTest"));
        multipartEntity.addPart("action", (ContentBody)new StringBody("addDocumentation"));
        multipartEntity.addPart("provider", (ContentBody)new StringBody(this.apiProvider));
        multipartEntity.addPart("mimeType", (ContentBody)new StringBody(mimeType));
        multipartEntity.addPart("optionsRadios", (ContentBody)new StringBody(docType));
        multipartEntity.addPart("optionsRadios1", (ContentBody)new StringBody(sourceType));
        multipartEntity.addPart("optionsRadios1", (ContentBody)new StringBody(sourceType));
        httppost.setEntity((HttpEntity)multipartEntity);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httppost);
        HttpEntity entity = response.getEntity();
        JSONObject jsonObject1 = new JSONObject(EntityUtils.toString((HttpEntity)entity));
        Assert.assertFalse((boolean)jsonObject1.getBoolean("error"), (String)"Error when adding files to the API ");
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type  public forum And Source File through the publisher rest API ", dependsOnMethods={"testAddDocumentToAnAPISDKToFile"})
    public void testAddDocumentToAnAPIPublicToFile() throws Exception {
        String fileNameAPIM624 = "APIM624.txt";
        String docName = "APIM624PublisherTestHowTo-File-summary";
        String docType = "public forum";
        String sourceType = "file";
        String summary = "Testing";
        String mimeType = "text/plain";
        String docUrl = "http://";
        String filePathAPIM624 = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + fileNameAPIM624;
        String addDocUrl = this.publisherUrls.getWebAppURLHttp() + "publisher/site/blocks/documentation/ajax/docs.jag";
        HttpPost httppost = new HttpPost(addDocUrl);
        File file = new File(filePathAPIM624);
        FileBody fileBody = new FileBody(file, "text/plain");
        MultipartEntity multipartEntity = new MultipartEntity();
        multipartEntity.addPart("docLocation", (ContentBody)fileBody);
        multipartEntity.addPart("mode", (ContentBody)new StringBody(""));
        multipartEntity.addPart("docName", (ContentBody)new StringBody(docName));
        multipartEntity.addPart("docUrl", (ContentBody)new StringBody(docUrl));
        multipartEntity.addPart("sourceType", (ContentBody)new StringBody(sourceType));
        multipartEntity.addPart("summary", (ContentBody)new StringBody(summary));
        multipartEntity.addPart("docType", (ContentBody)new StringBody(docType));
        multipartEntity.addPart("version", (ContentBody)new StringBody("1.0.0"));
        multipartEntity.addPart("apiName", (ContentBody)new StringBody("APIM614PublisherTest"));
        multipartEntity.addPart("action", (ContentBody)new StringBody("addDocumentation"));
        multipartEntity.addPart("provider", (ContentBody)new StringBody(this.apiProvider));
        multipartEntity.addPart("mimeType", (ContentBody)new StringBody(mimeType));
        multipartEntity.addPart("optionsRadios", (ContentBody)new StringBody(docType));
        multipartEntity.addPart("optionsRadios1", (ContentBody)new StringBody(sourceType));
        multipartEntity.addPart("optionsRadios1", (ContentBody)new StringBody(sourceType));
        httppost.setEntity((HttpEntity)multipartEntity);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httppost);
        HttpEntity entity = response.getEntity();
        JSONObject jsonObject1 = new JSONObject(EntityUtils.toString((HttpEntity)entity));
        Assert.assertFalse((boolean)jsonObject1.getBoolean("error"), (String)"Error when adding files to the API ");
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type  support forum And Source File through the publisher rest API ", dependsOnMethods={"testAddDocumentToAnAPIPublicToFile"})
    public void testAddDocumentToAnAPISupportToFile() throws Exception {
        String fileNameAPIM626 = "APIM626.txt";
        String docName = "APIM626PublisherTestHowTo-File-summary";
        String docType = "support forum";
        String sourceType = "file";
        String summary = "Testing";
        String mimeType = "text/plain";
        String docUrl = "http://";
        String filePathAPIM626 = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + fileNameAPIM626;
        String addDocUrl = this.publisherUrls.getWebAppURLHttp() + "publisher/site/blocks/documentation/ajax/docs.jag";
        HttpPost httppost = new HttpPost(addDocUrl);
        File file = new File(filePathAPIM626);
        FileBody fileBody = new FileBody(file, "text/plain");
        MultipartEntity multipartEntity = new MultipartEntity();
        multipartEntity.addPart("docLocation", (ContentBody)fileBody);
        multipartEntity.addPart("mode", (ContentBody)new StringBody(""));
        multipartEntity.addPart("docName", (ContentBody)new StringBody(docName));
        multipartEntity.addPart("docUrl", (ContentBody)new StringBody(docUrl));
        multipartEntity.addPart("sourceType", (ContentBody)new StringBody(sourceType));
        multipartEntity.addPart("summary", (ContentBody)new StringBody(summary));
        multipartEntity.addPart("docType", (ContentBody)new StringBody(docType));
        multipartEntity.addPart("version", (ContentBody)new StringBody("1.0.0"));
        multipartEntity.addPart("apiName", (ContentBody)new StringBody("APIM614PublisherTest"));
        multipartEntity.addPart("action", (ContentBody)new StringBody("addDocumentation"));
        multipartEntity.addPart("provider", (ContentBody)new StringBody(this.apiProvider));
        multipartEntity.addPart("mimeType", (ContentBody)new StringBody(mimeType));
        multipartEntity.addPart("optionsRadios", (ContentBody)new StringBody(docType));
        multipartEntity.addPart("optionsRadios1", (ContentBody)new StringBody(sourceType));
        multipartEntity.addPart("optionsRadios1", (ContentBody)new StringBody(sourceType));
        httppost.setEntity((HttpEntity)multipartEntity);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httppost);
        HttpEntity entity = response.getEntity();
        JSONObject jsonObject1 = new JSONObject(EntityUtils.toString((HttpEntity)entity));
        Assert.assertFalse((boolean)jsonObject1.getBoolean("error"), (String)"Error when adding files to the API ");
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type Other And Source File through the publisher rest API ", dependsOnMethods={"testAddDocumentToAnAPISupportToFile"})
    public void testAddDocumentToAnAPIOtherFile() throws Exception {
        String fileNameAPIM629 = "APIM629.txt";
        String docName = "APIM629PublisherTestHowTo-File-summary";
        String docType = "Other";
        String sourceType = "file";
        String newType = "Type APIM629";
        String summary = "Testing";
        String mimeType = "text/plain";
        String docUrl = "http://";
        String filePathAPIM629 = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + fileNameAPIM629;
        String addDocUrl = this.publisherUrls.getWebAppURLHttp() + "publisher/site/blocks/documentation/ajax/docs.jag";
        HttpPost httppost = new HttpPost(addDocUrl);
        File file = new File(filePathAPIM629);
        FileBody fileBody = new FileBody(file, "text/plain");
        MultipartEntity multipartEntity = new MultipartEntity();
        multipartEntity.addPart("docLocation", (ContentBody)fileBody);
        multipartEntity.addPart("mode", (ContentBody)new StringBody(""));
        multipartEntity.addPart("docName", (ContentBody)new StringBody(docName));
        multipartEntity.addPart("docUrl", (ContentBody)new StringBody(docUrl));
        multipartEntity.addPart("sourceType", (ContentBody)new StringBody(sourceType));
        multipartEntity.addPart("summary", (ContentBody)new StringBody(summary));
        multipartEntity.addPart("docType", (ContentBody)new StringBody(docType));
        multipartEntity.addPart("version", (ContentBody)new StringBody("1.0.0"));
        multipartEntity.addPart("apiName", (ContentBody)new StringBody("APIM614PublisherTest"));
        multipartEntity.addPart("action", (ContentBody)new StringBody("addDocumentation"));
        multipartEntity.addPart("provider", (ContentBody)new StringBody(this.apiProvider));
        multipartEntity.addPart("mimeType", (ContentBody)new StringBody(mimeType));
        multipartEntity.addPart("newType", (ContentBody)new StringBody(newType));
        multipartEntity.addPart("optionsRadios", (ContentBody)new StringBody(docType));
        multipartEntity.addPart("optionsRadios1", (ContentBody)new StringBody(sourceType));
        multipartEntity.addPart("optionsRadios1", (ContentBody)new StringBody(sourceType));
        httppost.setEntity((HttpEntity)multipartEntity);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httppost);
        HttpEntity entity = response.getEntity();
        JSONObject jsonObject1 = new JSONObject(EntityUtils.toString((HttpEntity)entity));
        Assert.assertFalse((boolean)jsonObject1.getBoolean("error"), (String)"Error when adding files to the API ");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.apiPublisher.deleteAPI("APIM614PublisherTest", "1.0.0", this.apiProvider);
        super.cleanUp();
    }
}

