/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIMANAGER5834APICreationWithInvalidInputsTestCase
extends APIMIntegrationBaseTest {
    private final String apiNameTest = "APIM18PublisherTest";
    private APIPublisherRestClient apiPublisher;

    @Factory(dataProvider="userModeDataProvider")
    public APIMANAGER5834APICreationWithInvalidInputsTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
    }

    @Test(groups={"wso2.am"}, description="Test API creation with invalid context")
    public void testAPICreationWithInvalidContext() throws Exception {
        String backendEndPoint = this.getBackendEndServiceEndPointHttp("jaxrs_basic/services/customers/customerservice");
        APIRequest apiRequest = new APIRequest("APIM18PublisherTest", "/", new URL(backendEndPoint));
        HttpResponse serviceResponse = this.apiPublisher.addAPI(apiRequest);
        JSONObject apiResponse = new JSONObject(serviceResponse.getData());
        Assert.assertTrue((boolean)apiResponse.getBoolean("error"), (String)"API creation should get an error when creating an API with / context.");
        Assert.assertEquals((Object)apiResponse.get("message"), (Object)" Context cannot end with '/' character", (String)"API creation should get an error when creating an API with / context.");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        super.cleanUp();
    }
}

