/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.resources;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIResourceModificationTestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStoreRestClient;
    private String APIName = "APIResourceTestAPI";
    private String APIVersion = "1.0.0";
    private String providerName = "";

    @Factory(dataProvider="userModeDataProvider")
    public APIResourceModificationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreRestClient = new APIStoreRestClient(storeURLHttp);
        this.providerName = this.user.getUserName();
    }

    @Test(groups={"wso2.am"}, description="add scope to resource test case")
    public void testSetScopeToResourceTestCase() throws Exception {
        String APIContext = "testResAPI";
        String tags = "youtube, video, media";
        String url = "http://gdata.youtube.com/feeds/api/standardfeeds";
        String description = "This is test API create by API manager integration test";
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        APIRequest apiRequest = new APIRequest(this.APIName, APIContext, new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(this.APIVersion);
        apiRequest.setVisibility("restricted");
        apiRequest.setRoles("admin");
        apiRequest.setProvider(this.providerName);
        this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(this.APIName, this.providerName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        String modifiedResource = "{\n    \"swagger\": \"2.0\",\n    \"paths\": {\n        \"/*\": {\n            \"get\": {\n                \"responses\": {\n                    \"200\": {\n                        \"description\": \"\"\n                    }\n                },\n                \"x-auth-type\": \"None\",\n                \"x-throttling-tier\": \"Unlimited\"\n            },\n            \"post\": {\n                \"responses\": {\n                    \"200\": {\n                        \"description\": \"\"\n                    }\n                },\n                \"parameters\": [\n                    {\n                        \"name\": \"Payload\",\n                        \"description\": \"Request Body\",\n                        \"required\": false,\n                        \"in\": \"body\",\n                        \"schema\": {\n                            \"type\": \"object\",\n                            \"properties\": {\n                                \"payload\": {\n                                    \"type\": \"string\"\n                                }\n                            }\n                        }\n                    }\n                ],\n                \"x-auth-type\": \"None\",\n                \"x-throttling-tier\": \"Unlimited\"\n            },\n            \"put\": {\n                \"responses\": {\n                    \"200\": {\n                        \"description\": \"\"\n                    }\n                },\n                \"parameters\": [\n                    {\n                        \"name\": \"Payload\",\n                        \"description\": \"Request Body\",\n                        \"required\": false,\n                        \"in\": \"body\",\n                        \"schema\": {\n                            \"type\": \"object\",\n                            \"properties\": {\n                                \"payload\": {\n                                    \"type\": \"string\"\n                                }\n                            }\n                        }\n                    }\n                ],\n                \"x-auth-type\": \"None\",\n                \"x-throttling-tier\": \"Unlimited\"\n            },\n            \"delete\": {\n                \"responses\": {\n                    \"200\": {\n                        \"description\": \"\"\n                    }\n                },\n                \"x-auth-type\": \"None\",\n                \"x-throttling-tier\": \"Unlimited\"\n            },\n            \"patch\": {\n                \"responses\": {\n                    \"200\": {\n                        \"description\": \"\"\n                    }\n                },\n                \"parameters\": [\n                    {\n                        \"name\": \"Payload\",\n                        \"description\": \"Request Body\",\n                        \"required\": false,\n                        \"in\": \"body\",\n                        \"schema\": {\n                            \"type\": \"object\",\n                            \"properties\": {\n                                \"payload\": {\n                                    \"type\": \"string\"\n                                }\n                            }\n                        }\n                    }\n                ],\n                \"x-auth-type\": \"None\",\n                \"x-throttling-tier\": \"Unlimited\"\n            }\n        }\n    },\n    \"info\": {\n        \"title\": \"APIResourceTestAPI\",\n        \"version\": \"1.0.0\"\n    }\n}";
        HttpResponse response = this.apiPublisher.updateResourceOfAPI(this.providerName, this.APIName, this.APIVersion, modifiedResource);
        this.apiStoreRestClient.waitForSwaggerDocument(this.providerName, this.APIName, this.APIVersion, "Unlimited", this.executionMode);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Modifying resources failed for API");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

