/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.rest;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class DocAPIParameterTamperingTest
extends APIMIntegrationBaseTest {
    private Map<String, String> requestHeaders = new HashMap<String, String>();

    @Factory(dataProvider="userModeDataProvider")
    public DocAPIParameterTamperingTest(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
    }

    @Test(groups={"wso2.am"}, description="Test whether the response expose the stack trace")
    public void testParameterTampaeredResponseOfDocAPI() throws Exception {
        String requestURL = this.publisherURLHttp + "publisher/site/blocks/documentation/ajax/docs.jag?action=" + "getInlineContent&=&apiName=%3Balert%281%29%27%22%3C%3E&version=1.0.0&docName=asd";
        HttpResponse response = this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        String cookie = (String)response.getHeaders().get("Set-Cookie");
        this.requestHeaders.put("Cookie", cookie);
        HttpResponse serviceResponse = HttpRequestUtil.doGet((String)requestURL, this.requestHeaders);
        JSONObject jsonObject = new JSONObject(serviceResponse.getData());
        System.out.println(serviceResponse.getData());
        Assert.assertFalse((boolean)serviceResponse.getData().contains("Exception"), (String)"Stack trace is exposed in the error");
        Assert.assertEquals((Object)jsonObject.get("error"), (Object)true, (String)"Error message is not properly returned");
    }
}

