/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.rest;

import java.io.File;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axis2.AxisFault;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.LogViewerClient;
import org.wso2.carbon.logging.view.stub.types.carbon.LogEvent;

public class UriTemplateReservedCharacterEncodingTest
extends APIMIntegrationBaseTest {
    private LogViewerClient logViewerClient;
    String gatewaySessionCookie;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, AxisFault, XPathExpressionException {
        String synapseConfFile = "uri-template-encoding.xml";
        super.init();
        this.gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + synapseConfFile, this.gatewayContextMgt, this.gatewaySessionCookie);
        this.logViewerClient = new LogViewerClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl(), this.createSession(this.gatewayContextMgt));
    }

    @Test(groups={"wso2.am"}, description="Sending http request with a query param consist of reserved character : ")
    public void testURITemplateExpandWithPercentEncoding() throws Exception {
        LogEvent[] logs;
        boolean isPercentEncoded = false;
        this.logViewerClient.clearLogs();
        HttpResponse response = HttpRequestUtil.sendGetRequest((String)this.getAPIInvocationURLHttp("services/client/urlEncoded?queryParam=APIM:WSO2"), null);
        for (LogEvent logEvent : logs = this.logViewerClient.getAllSystemLogs()) {
            String message = logEvent.getMessage();
            if (!message.contains("APIM%3AWSO2")) continue;
            isPercentEncoded = true;
            break;
        }
        Assert.assertTrue((boolean)isPercentEncoded, (String)"Reserved character should be percent encoded while uri-template expansion");
    }

    @Test(groups={"wso2.am"}, description="Sending http request with a query param consist of reserved character : with percent encoding escaped at uri-template expansion")
    public void testURITemplateExpandWithEscapedPercentEncoding() throws Exception {
        LogEvent[] logs;
        boolean isPercentEncoded = false;
        this.logViewerClient.clearLogs();
        HttpResponse response = HttpRequestUtil.sendGetRequest((String)this.getAPIInvocationURLHttp("services/client/escapeUrlEncoded?queryParam=APIM:WSO2"), null);
        for (LogEvent logEvent : logs = this.logViewerClient.getAllSystemLogs()) {
            String message = logEvent.getMessage();
            if (!message.contains("APIM%3AWSO2")) continue;
            isPercentEncoded = true;
            break;
        }
        Assert.assertFalse((boolean)isPercentEncoded, (String)"Reserved character should not be percent encoded while uri-template expansion as escape enabled");
    }

    @Test(groups={"wso2.am"}, description="Sending http request with a path param consist of reserved character : ")
    public void testURITemplateExpandWithPercentEncodingPathParamCase() throws Exception {
        LogEvent[] logs;
        boolean isPercentEncoded = false;
        this.logViewerClient.clearLogs();
        HttpResponse response = HttpRequestUtil.sendGetRequest((String)this.getAPIInvocationURLHttp("services/client/urlEncoded/APIM:WSO2"), null);
        for (LogEvent logEvent : logs = this.logViewerClient.getAllSystemLogs()) {
            String message = logEvent.getMessage();
            if (!message.contains("To: /services/test_2/APIM%3AWSO2")) continue;
            isPercentEncoded = true;
            break;
        }
        Assert.assertTrue((boolean)isPercentEncoded, (String)"Reserved character should be percent encoded while uri-template expansion");
    }

    @Test(groups={"wso2.am"}, description="Sending http request with a path param consist of reserved character : with percent encoding escaped at uri-template expansion")
    public void testURITemplateExpandWithEscapedPercentEncodingPathParam() throws Exception {
        LogEvent[] logs;
        boolean isPercentEncoded = false;
        this.logViewerClient.clearLogs();
        HttpResponse response = HttpRequestUtil.sendGetRequest((String)this.getAPIInvocationURLHttp("services/client/escapeUrlEncoded/APIM:WSO2"), null);
        for (LogEvent logEvent : logs = this.logViewerClient.getAllSystemLogs()) {
            String message = logEvent.getMessage();
            if (!message.contains("To: /services/test_2/APIM%3AWSO2")) continue;
            isPercentEncoded = true;
            break;
        }
        Assert.assertFalse((boolean)isPercentEncoded, (String)"Reserved character should not be percent encoded while uri-template expansion as escape enabled");
    }

    @Test(groups={"wso2.am"}, description="Sending http request with a query param consist of reserved space character ")
    public void testURITemplateParameterDecodingSpaceCharacterCase() throws Exception {
        LogEvent[] logs;
        boolean isPercentEncoded = false;
        boolean isMessageContextPropertyPercentDecoded = false;
        this.logViewerClient.clearLogs();
        HttpResponse response = HttpRequestUtil.sendGetRequest((String)this.getAPIInvocationURLHttp("services/client/urlEncoded?queryParam=APIM%20WSO2"), null);
        String decodedMessageContextProperty = "decodedQueryParamValue = APIM WSO2";
        for (LogEvent logEvent : logs = this.logViewerClient.getAllSystemLogs()) {
            String message = logEvent.getMessage();
            if (message.contains(decodedMessageContextProperty)) {
                isMessageContextPropertyPercentDecoded = true;
                continue;
            }
            if (!message.contains("APIM%20WSO2")) continue;
            isPercentEncoded = true;
        }
        Assert.assertTrue((boolean)isMessageContextPropertyPercentDecoded, (String)"Uri-Template parameters should be percent decoded at message context property");
        Assert.assertTrue((boolean)isPercentEncoded, (String)"Reserved character should be percent encoded while uri-template expansion");
    }

    @Test(groups={"wso2.am"}, description="Sending http request with a query param consist of reserved space character ")
    public void testURITemplateParameterDecodingTrailingPercentageCase() throws Exception {
        LogEvent[] logs;
        boolean isPercentEncoded = false;
        boolean isMessageContextPropertyPercentDecoded = false;
        this.logViewerClient.clearLogs();
        HttpResponse response = HttpRequestUtil.sendGetRequest((String)this.getAPIInvocationURLHttp("services/client/urlEncoded?queryParam=aaa%21%40%21%25"), null);
        String decodedMessageContextProperty = "decodedQueryParamValue = aaa!@!%";
        for (LogEvent logEvent : logs = this.logViewerClient.getAllSystemLogs()) {
            String message = logEvent.getMessage();
            if (message.contains(decodedMessageContextProperty)) {
                isMessageContextPropertyPercentDecoded = true;
                continue;
            }
            if (!message.contains("aaa%21%40%21%25")) continue;
            isPercentEncoded = true;
        }
        Assert.assertTrue((boolean)isMessageContextPropertyPercentDecoded, (String)"Uri-Template parameters should be percent decoded at message context property");
        Assert.assertTrue((boolean)isPercentEncoded, (String)"Reserved character should be percent encoded while uri-template expansion");
    }

    @Test(groups={"wso2.am"}, description="Sending http request with a query param consist of reserved + character ")
    public void testURITemplateParameterDecodingPlusCharacterCase() throws Exception {
        LogEvent[] logs;
        boolean isPercentEncoded = false;
        boolean isMessageContextPropertyPercentDecoded = false;
        this.logViewerClient.clearLogs();
        HttpResponse response = HttpRequestUtil.sendGetRequest((String)this.getAPIInvocationURLHttp("services/client/urlEncoded?queryParam=APIM+WSO2"), null);
        String decodedMessageContextProperty = "decodedQueryParamValue = APIM+WSO2";
        for (LogEvent logEvent : logs = this.logViewerClient.getAllSystemLogs()) {
            String message = logEvent.getMessage();
            if (message.contains(decodedMessageContextProperty)) {
                isMessageContextPropertyPercentDecoded = true;
                continue;
            }
            if (!message.contains("APIM%2BWSO2")) continue;
            isPercentEncoded = true;
        }
        Assert.assertTrue((boolean)isMessageContextPropertyPercentDecoded, (String)"Uri-Template parameters should be percent decoded at message context property");
        Assert.assertTrue((boolean)isPercentEncoded, (String)"Reserved character should be percent encoded while uri-template expansion");
    }

    @Test(groups={"wso2.am"}, description="Sending http request with a query param consist of reserved + character ")
    public void testURITemplateParameterDecodingWithPercentEncodingEscapedAtExpansion() throws Exception {
        LogEvent[] logs;
        boolean isPercentEncoded = false;
        boolean isMessageContextPropertyPercentDecoded = false;
        this.logViewerClient.clearLogs();
        HttpResponse response = HttpRequestUtil.sendGetRequest((String)this.getAPIInvocationURLHttp("services/client/escapeUrlEncoded?queryParam=APIM+WSO2"), null);
        String decodedMessageContextProperty = "decodedQueryParamValue = APIM+WSO2";
        for (LogEvent logEvent : logs = this.logViewerClient.getAllSystemLogs()) {
            String message = logEvent.getMessage();
            if (message.contains(decodedMessageContextProperty)) {
                isMessageContextPropertyPercentDecoded = true;
                continue;
            }
            if (!message.contains("APIM%2BWSO2")) continue;
            isPercentEncoded = true;
        }
        Assert.assertTrue((boolean)isMessageContextPropertyPercentDecoded, (String)"Uri-Template parameters should be percent decoded at message context property");
        Assert.assertFalse((boolean)isPercentEncoded, (String)"Reserved character should not be percent encoded while uri-template expansion");
    }

    @Test(groups={"wso2.am"}, description="Sending http request with a path param consist of whole URL including protocol , host , port etc. ")
    public void testURITemplateSpecialCaseVariableWithFullURL() throws Exception {
        LogEvent[] logs;
        boolean isPercentEncoded = false;
        this.logViewerClient.clearLogs();
        HttpResponse response = HttpRequestUtil.sendGetRequest((String)this.getAPIInvocationURLHttp("services/client/special_case/" + this.getAPIInvocationURLHttp("services/test_2") + "/special_case"), null);
        for (LogEvent logEvent : logs = this.logViewerClient.getAllSystemLogs()) {
            String message = logEvent.getMessage();
            if (!message.contains("To: /services/test_2/special_case")) continue;
            isPercentEncoded = true;
            break;
        }
        Assert.assertTrue((boolean)isPercentEncoded, (String)"The Special case of of Full URL expansion should be identified and should not percent encode full URL");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

