/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.server.mgt;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.integration.common.admin.client.LogViewerClient;
import org.wso2.carbon.logging.view.stub.LogViewerLogViewerException;
import org.wso2.carbon.logging.view.stub.types.carbon.LogEvent;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIMgtServerStartupTestCase {
    private LogViewerClient logViewerClient;
    private static final Log log = LogFactory.getLog(APIMgtServerStartupTestCase.class);
    private static final String SERVER_START_LINE = "Starting WSO2 Carbon";
    private static final String MANAGEMENT_CONSOLE_URL = "Mgt Console URL";

    @BeforeSuite(alwaysRun=true)
    public void setEnvironment() throws Exception {
        AutomationContext autoContext = new AutomationContext();
        this.logViewerClient = new LogViewerClient(autoContext.getContextUrls().getBackEndUrl(), autoContext.getSuperTenant().getTenantAdmin().getUserName(), autoContext.getSuperTenant().getTenantAdmin().getPassword());
    }

    @Test(groups={"wso2.all"}, description="verify server startup errors")
    public void testVerifyLogs() throws RemoteException, LogViewerLogViewerException {
        boolean status = false;
        int startLine = 0;
        int stopLine = 0;
        String errorMessage = "";
        LogEvent[] logEvents = this.logViewerClient.getAllRemoteSystemLogs();
        if (logEvents.length > 0) {
            for (int i = 0; i < logEvents.length; ++i) {
                if (logEvents[i] != null) {
                    if (logEvents[i].getMessage().contains(SERVER_START_LINE)) {
                        stopLine = i;
                        log.info((Object)("Server started message found - " + logEvents[i].getMessage()));
                    }
                    if (logEvents[i].getMessage().contains(MANAGEMENT_CONSOLE_URL)) {
                        startLine = i;
                        log.info((Object)("Server stopped message found - " + logEvents[i].getMessage()));
                    }
                }
                if (startLine != 0 && stopLine != 0) break;
            }
            while (startLine <= stopLine) {
                if (logEvents[startLine].getPriority().contains("ERROR")) {
                    errorMessage = logEvents[startLine].getMessage() + "\n" + logEvents[startLine].getStacktrace();
                    log.error((Object)("Startup contain errors - " + errorMessage));
                    status = true;
                    break;
                }
                ++startLine;
            }
        }
        Assert.assertFalse((boolean)status, (String)("Server started with errors. [" + errorMessage + "]"));
    }
}

