/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.throttling;

import java.io.File;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.wso2.am.admin.clients.webapp.WebAppAdminClient;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.generic.TestConfigurationProvider;
import org.wso2.am.integration.test.utils.webapp.WebAppDeploymentUtil;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

public class AdvancedThrottlingConfig
extends APIMIntegrationBaseTest {
    private ServerConfigurationManager serverConfigurationManager;
    private AutomationContext superTenantKeyManagerContext;

    @BeforeTest(alwaysRun=true)
    public void disableAdvancedThrottling() throws Exception {
        this.superTenantKeyManagerContext = new AutomationContext("APIM", "keyManager", TestUserMode.SUPER_TENANT_ADMIN);
        this.serverConfigurationManager = new ServerConfigurationManager(this.superTenantKeyManagerContext);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "apiManagerXmlWithoutAdvancedThrottling" + File.separator + "api-manager.xml"));
        this.serverConfigurationManager.copyToComponentLib(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "APIM5898" + File.separator + "subs-workflow-1.0.0.jar"));
        this.serverConfigurationManager.restartGracefully();
        this.deployWebApp();
    }

    @AfterTest(alwaysRun=true)
    public void enableAdvancedThrottling() throws Exception {
        this.serverConfigurationManager.removeFromComponentLib("subs-workflow-1.0.0.jar");
        this.serverConfigurationManager.restoreToLastConfiguration(false);
    }

    private void deployWebApp() throws Exception {
        super.init();
        String fileFormat = ".war";
        String webApp = "jaxrs_basic";
        String path = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator;
        String sourcePath = path + webApp + fileFormat;
        String sessionId = this.createSession(this.gatewayContextWrk);
        boolean isWebAppDeployed = WebAppDeploymentUtil.isWebApplicationDeployed((String)this.gatewayContextWrk.getContextUrls().getBackEndUrl(), (String)sessionId, (String)webApp);
        if (!isWebAppDeployed) {
            WebAppAdminClient webAppAdminClient = new WebAppAdminClient(this.gatewayContextWrk.getContextUrls().getBackEndUrl(), sessionId);
            webAppAdminClient.uploadWarFile(sourcePath);
            isWebAppDeployed = WebAppDeploymentUtil.isWebApplicationDeployed((String)this.gatewayContextWrk.getContextUrls().getBackEndUrl(), (String)sessionId, (String)webApp);
            Assert.assertTrue((boolean)isWebAppDeployed, (String)("Web APP is not deployed: " + webApp));
        }
    }
}

