/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.websocket;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.clients.AdminDashboardRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.websocket.client.WebSocketClientImpl;
import org.wso2.am.integration.tests.websocket.server.WebSocketServerImpl;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

public class WebSocketAPITestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(WebSocketAPITestCase.class);
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();
    private final String apiName = "WebSocketAPI";
    private final String applicationName = "WebSocketApplication";
    private final String testMessage = "Web Socket Test Message";
    private String apiEndPoint;
    private APIPublisherRestClient apiPublisher;
    private String provider;
    private String consumerKey;
    private String consumerSecret;
    private APIRequest apiRequest;
    private int webSocketServerPort;
    private String webSocketServerHost;
    private ServerConfigurationManager serverConfigurationManager;
    private String wsEventPublisherSource = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "configFiles" + File.separator + "webSocketTest" + File.separator;
    private String wsEventPublisherTarget = FrameworkPathUtil.getCarbonHome() + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "eventpublishers" + File.separator;
    private String wsRequestEventPublisherSource = "WS_Req_Logger.xml";
    private String wsThrottleOutEventPublisherSource = "WS_Throttle_Out_Logger.xml";

    @Factory(dataProvider="userModeDataProvider")
    public WebSocketAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.wsEventPublisherSource + this.wsRequestEventPublisherSource), new File(this.wsEventPublisherTarget + this.wsRequestEventPublisherSource), false);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.wsEventPublisherSource + this.wsThrottleOutEventPublisherSource), new File(this.wsEventPublisherTarget + this.wsThrottleOutEventPublisherSource), false);
        this.webSocketServerHost = InetAddress.getLocalHost().getHostName();
        int lowerPortLimit = 9950;
        int upperPortLimit = 9999;
        this.webSocketServerPort = this.getAvailablePort(lowerPortLimit, upperPortLimit);
        if (this.webSocketServerPort == -1) {
            throw new APIManagerIntegrationTestException("No available port in the range " + lowerPortLimit + "-" + upperPortLimit + " was found");
        }
        this.log.info((Object)("Selected port " + this.webSocketServerPort + " to start backend server"));
        this.startWebSocketServer(this.webSocketServerPort);
    }

    @Test(description="Publish WebSocket API")
    public void publishWebSocketAPI() throws Exception {
        this.apiPublisher = new APIPublisherRestClient(this.getPublisherURLHttp());
        this.apiStore = new APIStoreRestClient(this.getStoreURLHttp());
        this.provider = this.user.getUserName();
        String apiContext = "echo";
        String apiVersion = "1.0.0";
        URI endpointUri = new URI("ws://" + this.webSocketServerHost + ":" + this.webSocketServerPort);
        this.apiRequest = new APIRequest("WebSocketAPI", apiContext, endpointUri, endpointUri);
        this.apiRequest.setVersion(apiVersion);
        this.apiRequest.setTiersCollection("Unlimited");
        this.apiRequest.setProvider(this.provider);
        this.apiRequest.setType("WS");
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        HttpResponse addAPIResponse = this.apiPublisher.addAPI(this.apiRequest);
        this.verifyResponse(addAPIResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("WebSocketAPI", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "WebSocketAPI", apiVersion, "\"isApiExists\":true");
        APIIdentifier apiIdentifierWebSocket = new APIIdentifier(this.provider, "WebSocketAPI", apiVersion);
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiEndPoint = TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_USER.equals((Object)this.userMode) ? this.getWebSocketAPIInvocationURL(apiContext, apiVersion) : this.getWebSocketTenantAPIInvocationURL(apiContext, apiVersion, this.user.getUserDomain());
        this.log.info((Object)("API Endpoint URL" + this.apiEndPoint));
        List publisherAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisher.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)apiIdentifierWebSocket, (List)publisherAPIList), (String)"Published API is visible in API Publisher.");
        List storeAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getAllPaginatedPublishedAPIs(this.storeContext.getContextTenant().getDomain(), 0, 100));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)apiIdentifierWebSocket, (List)storeAPIList), (String)"Published API is visible in API Store.");
    }

    @Test(description="Create Application and subscribe", dependsOnMethods={"publishWebSocketAPI"})
    public void testWebSocketAPIApplicationSubscription() throws Exception {
        this.apiStore.addApplication("WebSocketApplication", "Unlimited", "", "");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("WebSocketAPI", this.provider);
        subscriptionRequest.setApplicationName("WebSocketApplication");
        subscriptionRequest.setTier("Unlimited");
        HttpResponse subscribeApiResponse = this.apiStore.subscribe(subscriptionRequest);
        Assert.assertEquals((int)subscribeApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"WebSocketAPIis not Subscribed");
        Assert.assertTrue((boolean)subscribeApiResponse.getData().contains("\"error\" : false"), (String)"WebSocketAPIis not Subscribed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(description="Invoke API using token", dependsOnMethods={"testWebSocketAPIApplicationSubscription"})
    public void testWebSocketAPIInvocation() throws Exception {
        APPKeyRequestGenerator generateAppKeyRequestSandBox = new APPKeyRequestGenerator("WebSocketApplication");
        generateAppKeyRequestSandBox.setKeyType("PRODUCTION");
        String responseSandBoxToken = this.apiStore.generateApplicationKey(generateAppKeyRequestSandBox).getData();
        JSONObject jsonObject = new JSONObject(responseSandBoxToken);
        String accessToken = jsonObject.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        this.consumerKey = jsonObject.getJSONObject("data").getJSONObject("key").getString("consumerKey");
        this.consumerSecret = jsonObject.getJSONObject("data").getJSONObject("key").getString("consumerSecret");
        Assert.assertNotNull((Object)("Access Token not found " + responseSandBoxToken), (String)accessToken);
        WebSocketClient client = new WebSocketClient();
        try {
            this.invokeAPI(client, accessToken);
        }
        catch (Exception e) {
            this.log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
    }

    @Test(description="Test Throttling for WebSocket API", dependsOnMethods={"testWebSocketAPIInvocation"})
    public void testWebSocketAPIThrottling() throws Exception {
        AdminDashboardRestClient adminDashboardRestClient = new AdminDashboardRestClient(this.getPublisherURLHttps());
        adminDashboardRestClient.login(this.user.getUserName(), this.user.getPassword());
        FileInputStream inputStream = new FileInputStream(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "webSocketTest" + File.separator + "policy.json");
        HttpResponse addPolicyResponse = adminDashboardRestClient.addThrottlingPolicy(IOUtils.toString((InputStream)inputStream));
        this.verifyResponse(addPolicyResponse);
        this.apiRequest.setApiTier("WebSocketTestThrottlingPolicy");
        HttpResponse updateAPIResponse = this.apiPublisher.updateAPI(this.apiRequest);
        this.verifyResponse(updateAPIResponse);
        URL tokenEndpointURL = new URL(this.getGatewayURLNhttp() + "token");
        String subsAccessTokenPayload = APIMTestCaseUtils.getPayloadForPasswordGrant((String)this.storeContext.getContextTenant().getContextUser().getUserName(), (String)this.storeContext.getContextTenant().getContextUser().getPassword());
        JSONObject subsAccessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, subsAccessTokenPayload, tokenEndpointURL).getData());
        String subsRefreshToken = subsAccessTokenGenerationResponse.getString("refresh_token");
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)subsRefreshToken), (String)"Refresh token of access token generated by subscriber is empty");
        String requestBody = APIMTestCaseUtils.getPayloadForPasswordGrant((String)this.user.getUserName(), (String)this.user.getPassword());
        JSONObject accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, requestBody, tokenEndpointURL).getData());
        String refreshToken = accessTokenGenerationResponse.getString("refresh_token");
        String getAccessTokenFromRefreshTokenRequestBody = "grant_type=refresh_token&refresh_token=" + refreshToken;
        accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, getAccessTokenFromRefreshTokenRequestBody, tokenEndpointURL).getData());
        String userAccessToken = accessTokenGenerationResponse.getString("access_token");
        Assert.assertNotNull((Object)("Access Token not found " + accessTokenGenerationResponse), (String)userAccessToken);
        this.testThrottling(userAccessToken);
    }

    @Test(description="Invoke API using invalid token", dependsOnMethods={"testWebSocketAPIThrottling"})
    public void testWebSocketAPIInvalidTokenInvocation() throws Exception {
        WebSocketClient client = new WebSocketClient();
        try {
            this.invokeAPI(client, "00000000-0000-0000-0000-000000000000");
        }
        catch (APIManagerIntegrationTestException e) {
            this.log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.assertTrue((boolean)true, (String)"Client cannot connect to server");
        }
        catch (Exception e) {
            this.log.error((Object)"Exception in connecting to server", (Throwable)e);
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
    }

    private void waitForReply(WebSocketClientImpl clientSocket) {
        long currentTime = System.currentTimeMillis();
        long WAIT_TIME = 30000L;
        long waitTime = currentTime + WAIT_TIME;
        while (org.wso2.carbon.utils.xml.StringUtils.isEmpty((String)clientSocket.getResponseMessage()) && waitTime > System.currentTimeMillis()) {
            try {
                this.log.info((Object)"Waiting for reply from server:");
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.log.info((Object)("Client received :" + clientSocket.getResponseMessage()));
    }

    private void startWebSocketServer(final int serverPort) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                WebSocketHandler wsHandler = new WebSocketHandler(){

                    public void configure(WebSocketServletFactory factory) {
                        factory.register(WebSocketServerImpl.class);
                    }
                };
                Server server = new Server(serverPort);
                server.setHandler((Handler)wsHandler);
                try {
                    server.start();
                    WebSocketAPITestCase.this.log.info((Object)("WebSocket backend server started at port: " + serverPort));
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception e) {
                    WebSocketAPITestCase.this.log.error((Object)("Error while starting backend server at port: " + serverPort), (Throwable)e);
                    Assert.fail((String)"Cannot start WebSocket server");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testThrottling(String accessToken) throws Exception {
        int limit = 10;
        WebSocketClient client = new WebSocketClient();
        WebSocketClientImpl socket = new WebSocketClientImpl();
        client.start();
        URI echoUri = new URI(this.apiEndPoint);
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setHeader("Authorization", "Bearer " + accessToken);
        client.connect((Object)socket, echoUri, request);
        socket.getLatch().await(3L, TimeUnit.SECONDS);
        try {
            for (int count = 1; count <= limit; ++count) {
                socket.sendMessage("Web Socket Test Message");
                this.waitForReply(socket);
                this.log.info((Object)("Count :" + count + " Message :" + socket.getResponseMessage()));
                if (count >= limit) {
                    Assert.assertEquals((String)socket.getResponseMessage(), (String)"Websocket frame throttled out", (String)"Received response is not matching");
                }
                socket.setResponseMessage(null);
            }
        }
        catch (Exception ex) {
            this.log.error((Object)("Error occurred while calling API : " + ex));
            Assert.fail((String)"Client cannot connect to server");
        }
        finally {
            client.stop();
        }
    }

    private void invokeAPI(WebSocketClient client, String accessToken) throws Exception {
        WebSocketClientImpl socket = new WebSocketClientImpl();
        client.start();
        URI echoUri = new URI(this.apiEndPoint);
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setHeader("Authorization", "Bearer " + accessToken);
        client.connect((Object)socket, echoUri, request);
        if (!socket.getLatch().await(30L, TimeUnit.SECONDS)) {
            throw new APIManagerIntegrationTestException("Unable to create client connection");
        }
        socket.sendMessage("Web Socket Test Message");
        this.waitForReply(socket);
        Assert.assertEquals((boolean)org.wso2.carbon.utils.xml.StringUtils.isEmpty((String)socket.getResponseMessage()), (boolean)false, (String)"Client did not receive response from server");
        Assert.assertEquals((String)socket.getResponseMessage(), (String)"Web Socket Test Message".toUpperCase(), (String)"Received response in not matching");
        socket.setResponseMessage(null);
    }

    private int getAvailablePort(int lowerPortLimit, int upperPortLimit) {
        while (lowerPortLimit < upperPortLimit) {
            if (this.isPortFree(lowerPortLimit)) {
                return lowerPortLimit;
            }
            ++lowerPortLimit;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPortFree(int port) {
        Socket s = null;
        try {
            s = new Socket(this.webSocketServerHost, port);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to close connection ", e);
                }
            }
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.serverConfigurationManager.restoreToLastConfiguration(false);
        this.executorService.shutdownNow();
        super.cleanUp();
    }
}

