/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.File;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIMANAGER5337SubscriptionRetainTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(APIMANAGER5337SubscriptionRetainTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
        this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "error_response_check_dummy_api.xml", this.gatewayContextMgt, gatewaySessionCookie);
    }

    @Test(groups={"wso2.am"}, description="testing error responses")
    public void testAPIErrorResponse() throws Exception {
        HttpResponse response = this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.verifyResponse(response);
        String apiName = "SubscriptionCheckAPI";
        String apiVersion = "1.0.0";
        String apiContext = "subscriptionCheck";
        String endpointUrl = this.getAPIInvocationURLHttp("response");
        try {
            APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(endpointUrl));
            apiRequest.setVersion(apiVersion);
            apiRequest.setTiersCollection("Unlimited");
            apiRequest.setTier("Unlimited");
            response = this.apiPublisher.addAPI(apiRequest);
            this.verifyResponse(response);
            APILifeCycleStateRequest updateRequest1 = new APILifeCycleStateRequest(apiName, this.user.getUserName(), APILifeCycleState.PUBLISHED);
            response = this.apiPublisher.changeAPILifeCycleStatus(updateRequest1);
            this.verifyResponse(response);
            response = this.apiStore.login(this.user.getUserName(), this.user.getPassword());
            this.verifyResponse(response);
            response = this.apiStore.addApplication("subscriptionCheckApp1", "Unlimited", "", "");
            this.verifyResponse(response);
            SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiName, apiVersion, this.user.getUserName(), "subscriptionCheckApp1", "Unlimited");
            response = this.apiStore.subscribe(subscriptionRequest);
            this.verifyResponse(response);
            APILifeCycleStateRequest updateRequest2 = new APILifeCycleStateRequest(apiName, this.user.getUserName(), APILifeCycleState.CREATED);
            response = this.apiPublisher.changeAPILifeCycleStatus(updateRequest2);
            this.verifyResponse(response);
            Thread.sleep(1000L);
            response = this.apiStore.getAllSubscriptionsOfApplication("subscriptionCheckApp1");
            this.verifyResponse(response);
            String subscriptions = response.getData();
            JSONObject subscriptionJson = new JSONObject(subscriptions);
            Assert.assertEquals((boolean)subscriptionJson.toString().contains("SubscriptionCheckAPI"), (boolean)true, (String)"Subscription of the SubscriptionCheckAPI has been removed.");
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)("APIManagerIntegrationTestException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

