/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.List;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIVisibilityByDomainTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "APIVisibilityByDomainTest";
    private final String API_CONTEXT = "APIVisibilityByDomain";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String CARBON_SUPER_TENANT2_KEY = "userKey2";
    private final String TENANT_DOMAIN_KEY = "wso2.com";
    private final String TENANT_DOMAIN_ADMIN_KEY = "admin";
    private final String USER_KEY_USER2 = "userKey1";
    private final String OTHER_DOMAIN_TENANT_USER_KEY = "user1";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifier;
    private APIStoreRestClient apiStoreClientCarbonSuperUser2;
    private APIPublisherRestClient apiPublisherClientCarbonSuperUser2;
    private APIStoreRestClient apiStoreClientAnotherUserOtherDomain;
    private APIPublisherRestClient apiPublisherClientAnotherUserOtherDomain;
    private APIStoreRestClient apiStoreClientAdminOtherDomain;
    private APIPublisherRestClient apiPublisherClientAdminOtherDomain;
    private String providerName;
    private APIPublisherRestClient apiPublisherClientCarbonSuperUser1;
    private APIStoreRestClient apiStoreClientCarbonSuperUser1;
    private APIPublisherRestClient apiPublisherClientCarbonSuperAdmin;
    private APIStoreRestClient apiStoreClientCarbonSuperAdmin;
    private String storeURLHttp;
    private String otherDomain;
    private String apiCreatorStoreDomain;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientCarbonSuperAdmin = new APIPublisherRestClient(this.getPublisherURLHttp());
        this.apiStoreClientCarbonSuperAdmin = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisherClientCarbonSuperAdmin.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientCarbonSuperAdmin.login(this.user.getUserName(), this.user.getPassword());
        this.apiPublisherClientCarbonSuperUser1 = new APIPublisherRestClient(this.getPublisherURLHttp());
        this.apiStoreClientCarbonSuperUser1 = new APIStoreRestClient(this.storeURLHttp);
        this.apiCreatorStoreDomain = this.storeContext.getContextTenant().getDomain();
        this.providerName = this.publisherContext.getContextTenant().getTenantUser("userKey1").getUserName();
        this.apiPublisherClientCarbonSuperUser1.login(this.publisherContext.getContextTenant().getTenantUser("userKey1").getUserName(), this.publisherContext.getContextTenant().getTenantUser("userKey1").getPassword());
        this.apiStoreClientCarbonSuperUser1.login(this.publisherContext.getContextTenant().getTenantUser("userKey1").getUserName(), this.publisherContext.getContextTenant().getTenantUser("userKey1").getPassword());
        this.apiStoreClientCarbonSuperUser2 = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisherClientCarbonSuperUser2 = new APIPublisherRestClient(this.getPublisherURLHttp());
        this.apiStoreClientCarbonSuperUser2.login(this.storeContext.getContextTenant().getTenantUser("userKey2").getUserName(), this.storeContext.getContextTenant().getTenantUser("userKey2").getPassword());
        this.apiPublisherClientCarbonSuperUser2.login(this.publisherContext.getContextTenant().getTenantUser("userKey2").getUserName(), this.publisherContext.getContextTenant().getTenantUser("userKey2").getPassword());
        this.init("wso2.com", "admin");
        this.otherDomain = this.storeContext.getContextTenant().getDomain();
        this.apiStoreClientAnotherUserOtherDomain = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisherClientAnotherUserOtherDomain = new APIPublisherRestClient(this.getPublisherURLHttp());
        this.apiStoreClientAnotherUserOtherDomain.login(this.storeContext.getContextTenant().getTenantUser("user1").getUserName(), this.storeContext.getContextTenant().getTenantUser("user1").getPassword());
        this.apiPublisherClientAnotherUserOtherDomain.login(this.publisherContext.getContextTenant().getTenantUser("user1").getUserName(), this.publisherContext.getContextTenant().getTenantUser("user1").getPassword());
        this.apiStoreClientAdminOtherDomain = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisherClientAdminOtherDomain = new APIPublisherRestClient(this.getPublisherURLHttp());
        this.apiStoreClientAdminOtherDomain.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiPublisherClientAdminOtherDomain.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for API creator ")
    public void testVisibilityForCreatorInPublisher() throws Exception {
        this.apiIdentifier = new APIIdentifier(this.providerName, "APIVisibilityByDomainTest", "1.0.0");
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIVisibilityByDomainTest", "APIVisibilityByDomain", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        apiCreationRequestBean.setVisibility("private");
        this.apiPublisherClientCarbonSuperUser1.addAPI(apiCreationRequestBean);
        APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, "APIVisibilityByDomainTest", "1.0.0");
        this.publishAPI(apiIdentifier, this.apiPublisherClientCarbonSuperUser1, false);
        this.waitForAPIDeployment();
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientCarbonSuperUser1.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is not visible to creator in APi Publisher. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for API creator", dependsOnMethods={"testVisibilityForCreatorInPublisher"})
    public void testVisibilityForCreatorInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientCarbonSuperUser1.getAPI());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is not visible to creator in API Store. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for admin in same domain ", dependsOnMethods={"testVisibilityForCreatorInStore"})
    public void testVisibilityForAdminInSameDomainInPublisher() throws APIManagerIntegrationTestException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientCarbonSuperAdmin.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is not visible to admin in same domain in API Publisher. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for admin in same domain ", dependsOnMethods={"testVisibilityForAdminInSameDomainInPublisher"})
    public void testVisibilityForAdminInSameDomainInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientCarbonSuperAdmin.getAPI());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is not visible to admin in same domain in API Store. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for another user in same domain", dependsOnMethods={"testVisibilityForAdminInSameDomainInStore"})
    public void testVisibilityForAnotherUserInSameDomainInPublisher() throws APIManagerIntegrationTestException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientCarbonSuperUser2.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is not visible to another user in same domain in API Publisher. When Visibility is private." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in same domain", dependsOnMethods={"testVisibilityForAnotherUserInSameDomainInPublisher"})
    public void testVisibilityForAnotherUserInSameDomainInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientCarbonSuperUser2.getAPI());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is not visible to another user in same domain in API Store. When Visibility is private." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for another user in other domain", dependsOnMethods={"testVisibilityForAnotherUserInSameDomainInStore"})
    public void testVisibilityForAnotherUserInOtherDomainInPublisher() throws APIManagerIntegrationTestException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientAnotherUserOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is  visible to another user in other domain in API Publisher. When Visibility is private." + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for another user in other domain", dependsOnMethods={"testVisibilityForAnotherUserInOtherDomainInPublisher"})
    public void testVisibilityForAnotherUserInOtherDomainInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientAnotherUserOtherDomain.getAPI());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is  visible to another user in other domain in API Store. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Publisher for admin in other domain", dependsOnMethods={"testVisibilityForAnotherUserInOtherDomainInStore"})
    public void testVisibilityForAdminInOtherDomainInPublisher() throws APIManagerIntegrationTestException {
        List apiPublisherAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisherClientAdminOtherDomain.getAllAPIs());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiPublisherAPIIdentifierList), (String)("API is  visible to admin in other domain in API Publisher. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in Store for admin in other domain", dependsOnMethods={"testVisibilityForAdminInOtherDomainInPublisher"})
    public void testVisibilityForAdminInOtherDomainInStore() throws APIManagerIntegrationTestException {
        List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStoreClientAdminOtherDomain.getAPI());
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifier, (List)apiStoreAPIIdentifierList), (String)("API is  visible to admin in other domain in API Store. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility for API in Same domainStore for anonymous user", dependsOnMethods={"testVisibilityForAdminInOtherDomainInStore"})
    public void testVisibilityForAnonymousUserInSameDomainInStore() throws Exception {
        HttpResponse httpResponse = HttpRequestUtil.sendGetRequest((String)(this.storeURLHttp + "store/site/blocks/api/recently-added/ajax/list.jag"), (String)("action=getRecentlyAddedAPIs&tenant=" + this.apiCreatorStoreDomain));
        Assert.assertFalse((boolean)new JSONObject(httpResponse.getData()).getBoolean("error"), (String)"Error while getting api list");
        Assert.assertFalse((boolean)httpResponse.getData().contains("APIVisibilityByDomainTest"), (String)("API  visible to anonymous user in same domain API Store. When Visibility is private.  " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility for API in other domainStore for anonymous user", dependsOnMethods={"testVisibilityForAnonymousUserInSameDomainInStore"})
    public void testVisibilityForAnonymousUserInOtherDomainInStore() throws Exception {
        HttpResponse httpResponse = HttpRequestUtil.sendGetRequest((String)(this.storeURLHttp + "store/site/blocks/api/recently-added/ajax/list.jag"), (String)("action=getRecentlyAddedAPIs&tenant=" + this.otherDomain));
        Assert.assertFalse((boolean)new JSONObject(httpResponse.getData()).getBoolean("error"), (String)"Error while getting api list");
        Assert.assertFalse((boolean)httpResponse.getData().contains("APIVisibilityByDomainTest"), (String)("API is visible to anonymous user in other domain API Store. When Visibility is private. " + this.getAPIIdentifierString(this.apiIdentifier)));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws APIManagerIntegrationTestException {
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientCarbonSuperAdmin);
    }
}

