/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class APIVisibilityWithDirectURLTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(APIManagerLifecycleBaseTest.class);
    private final String apiName = "APIVisibilityWithDirectURLTestCaseAPIName";
    private final String APIContext = "APIVisibilityWithDirectURLTestCaseAPIContext";
    private final String apiNameTenant = "APIVisibilityWithDirectURLTestCaseAPIName";
    private final String APIContextTenant = "APIVisibilityWithDirectURLTestCaseAPIContext";
    private final String tags = "test, EndpointType";
    private final String description = "This is test API create by API manager integration test";
    private final String APIVersion = "1.0.0";
    private final String CARBON_SUPER_SUBSCRIBER_USERNAME = "directUrlUser";
    private final char[] CARBON_SUPER_SUBSCRIBER_PASSWORD = "password@123".toCharArray();
    private final String CARBON_SUPER_SUBSCRIBER_1_USERNAME = "directUrlUser1";
    private final char[] CARBON_SUPER_SUBSCRIBER_1_PASSWORD = "password@123".toCharArray();
    private final String INTERNAL_ROLE_SUBSCRIBER = "directUrlRole";
    private final String INTERNAL_ROLE_SUBSCRIBER_1 = "directUrlRole1";
    private final String SUPER_ADMIN_USERNAME = "admin";
    private final String SUPER_ADMIN_DOMAIN = "carbon.super";
    private final String TENANT_SUBSCRIBER_USERNAME = "directUrlUser";
    private final char[] TENANT_SUBSCRIBER_PASSWORD = "password@123".toCharArray();
    private final String TENANT_SUBSCRIBER_1_USERNAME = "directUrlUser1";
    private final char[] TENANT_SUBSCRIBER_1_PASSWORD = "password@123".toCharArray();
    private final String TENANT_DOMAIN_KEY = "wso2.com";
    private final String TENANT_DOMAIN_ADMIN_KEY = "admin";
    private final String[] permissions = new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"};
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private APIRequest apiRequest;
    private APIRequest apiRequestTenant;
    private APIPublisherRestClient apiPublisherClientAdminOtherDomain;
    private UserManagementClient userManagementClient2;
    private APIStoreRestClient apiStoreClientAnotherUserOtherDomain;
    private UserManagementClient userManagementClient1;
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String publisherURLHttp;
    private String storeURLHttp;
    private String endpointUrl;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api/add";
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.createSession(this.keyManagerContext));
        this.userManagementClient1.addRole("directUrlRole", null, this.permissions);
        this.userManagementClient1.addRole("directUrlRole1", null, this.permissions);
        this.userManagementClient1.addUser("directUrlUser", String.valueOf(this.CARBON_SUPER_SUBSCRIBER_PASSWORD), new String[]{"directUrlRole"}, null);
        this.userManagementClient1.addUser("directUrlUser1", String.valueOf(this.CARBON_SUPER_SUBSCRIBER_1_PASSWORD), new String[]{"directUrlRole1"}, null);
    }

    @Test(groups={"wso2.am"}, description="Test availability of the api without login")
    public void testDirectLinkAnonymous() throws Exception {
        String providerName = this.user.getUserName();
        this.apiRequest = new APIRequest("APIVisibilityWithDirectURLTestCaseAPIName", "APIVisibilityWithDirectURLTestCaseAPIContext", new URL(this.endpointUrl));
        this.apiRequest.setTags("test, EndpointType");
        this.apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiRequest.setVersion("1.0.0");
        this.apiRequest.setProvider(providerName);
        this.apiRequest.setVisibility("restricted");
        this.apiRequest.setRoles("directUrlRole");
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiRequest);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIVisibilityWithDirectURLTestCaseAPIName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        HttpResponse a = HttpRequestUtil.doGet((String)(this.getStoreURLHttps() + "/store/apis/info?name=" + "APIVisibilityWithDirectURLTestCaseAPIName" + "&version=" + "1.0.0" + "&provider=" + "admin" + "&tenant=" + "carbon.super"), this.requestHeaders);
        Assert.assertTrue((boolean)a.getData().contains("user is not authorized to view the API"), (String)"API APIVisibilityWithDirectURLTestCaseAPINameis available to the restricted user");
    }

    @Test(groups={"wso2.am"}, description="Test availability of the api with login", dependsOnMethods={"testDirectLinkAnonymous"})
    public void testDirectLink() throws Exception {
        HttpResponse response = this.apiStore.login("directUrlUser", String.valueOf(this.CARBON_SUPER_SUBSCRIBER_PASSWORD));
        String session = (String)response.getHeaders().get("Set-Cookie");
        this.requestHeaders.put("Cookie", session);
        HttpResponse a = HttpRequestUtil.doGet((String)(this.getStoreURLHttps() + "/store/apis/info?name=" + "APIVisibilityWithDirectURLTestCaseAPIName" + "&version=" + "1.0.0" + "&provider=" + "admin" + "&tenant=" + "carbon.super"), this.requestHeaders);
        Assert.assertFalse((boolean)a.getData().contains("user is not authorized to view the API"), (String)"API APIVisibilityWithDirectURLTestCaseAPINameis not available to the authorised user");
    }

    @Test(groups={"wso2.am"}, description="Test availability of the api from user without restricted role", dependsOnMethods={"testDirectLink"})
    public void testDirectLinkWithoutRestrictedRoleUser() throws Exception {
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        HttpResponse response = this.apiStore.login("directUrlUser1", String.valueOf(this.CARBON_SUPER_SUBSCRIBER_1_PASSWORD));
        String session = (String)response.getHeaders().get("Set-Cookie");
        this.requestHeaders.clear();
        this.requestHeaders.put("Cookie", session);
        HttpResponse a = HttpRequestUtil.doGet((String)(this.getStoreURLHttps() + "/store/apis/info?name=" + "APIVisibilityWithDirectURLTestCaseAPIName" + "&version=" + "1.0.0" + "&provider=" + "admin" + "&tenant=" + "carbon.super"), this.requestHeaders);
        Assert.assertTrue((boolean)a.getData().contains("user is not authorized to view the API"), (String)"API APIVisibilityWithDirectURLTestCaseAPINameis available to the unauthorised user");
    }

    @Test(groups={"wso2.am"}, description="Sample API creation and publishing in Tenant", dependsOnMethods={"testDirectLinkWithoutRestrictedRoleUser"})
    public void testAPICreationInTenant() throws Exception {
        this.init("wso2.com", "admin");
        this.apiPublisherClientAdminOtherDomain = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiPublisherClientAdminOtherDomain.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.userManagementClient2 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.createSession(this.keyManagerContext));
        this.userManagementClient2.addRole("directUrlRole", null, this.permissions);
        this.userManagementClient2.addRole("directUrlRole1", null, this.permissions);
        this.userManagementClient2.addUser("directUrlUser", String.valueOf(this.TENANT_SUBSCRIBER_PASSWORD), new String[]{"directUrlRole"}, null);
        this.userManagementClient2.addUser("directUrlUser1", String.valueOf(this.TENANT_SUBSCRIBER_1_PASSWORD), new String[]{"directUrlRole1"}, null);
        this.apiStoreClientAnotherUserOtherDomain = new APIStoreRestClient(this.storeURLHttp);
        String publisher = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiRequestTenant = new APIRequest("APIVisibilityWithDirectURLTestCaseAPIName", "APIVisibilityWithDirectURLTestCaseAPIContext", new URL(this.endpointUrl));
        this.apiRequestTenant.setTags("test, EndpointType");
        this.apiRequestTenant.setDescription("This is test API create by API manager integration test");
        this.apiRequestTenant.setVersion("1.0.0");
        this.apiRequestTenant.setProvider(publisher);
        this.apiRequestTenant.setVisibility("restricted");
        this.apiRequestTenant.setRoles("directUrlRole");
        HttpResponse serviceResponse = this.apiPublisherClientAdminOtherDomain.addAPI(this.apiRequestTenant);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIVisibilityWithDirectURLTestCaseAPIName", publisher, APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisherClientAdminOtherDomain.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
    }

    @Test(groups={"wso2.am"}, description="Test availability of the api without login in tenant", dependsOnMethods={"testAPICreationInTenant"})
    public void testDirectLinkInTenantAnonymous() throws Exception {
        this.requestHeaders.clear();
        String publisher = this.storeContext.getContextTenant().getContextUser().getUserName();
        HttpResponse a = HttpRequestUtil.doGet((String)(this.getStoreURLHttps() + "/store/apis/info?name=" + "APIVisibilityWithDirectURLTestCaseAPIName" + "&version=" + "1.0.0" + "&provider=" + publisher + "&tenant=" + "wso2.com"), this.requestHeaders);
        Assert.assertTrue((boolean)a.getData().contains("user is not authorized to view the API"), (String)"API APIVisibilityWithDirectURLTestCaseAPINameis available to the restricted user in Tenant");
    }

    @Test(groups={"wso2.am"}, description="Test availability of the api with login in tenant", dependsOnMethods={"testDirectLinkInTenantAnonymous"})
    public void testDirectLinkInTenant() throws Exception {
        HttpResponse response = this.apiStoreClientAnotherUserOtherDomain.login("directUrlUser@wso2.com", String.valueOf(this.TENANT_SUBSCRIBER_PASSWORD));
        String publisher = this.storeContext.getContextTenant().getContextUser().getUserName();
        String session = (String)response.getHeaders().get("Set-Cookie");
        this.requestHeaders.put("Cookie", session);
        HttpResponse a = HttpRequestUtil.doGet((String)(this.getStoreURLHttps() + "/store/apis/info?name=" + "APIVisibilityWithDirectURLTestCaseAPIName" + "&version=" + "1.0.0" + "&provider=" + publisher + "&tenant=" + "wso2.com"), this.requestHeaders);
        Assert.assertFalse((boolean)a.getData().contains("user is not authorized to view the API"), (String)"API APIVisibilityWithDirectURLTestCaseAPINameis not available to the authorised user in Tenant");
    }

    @Test(groups={"wso2.am"}, description="Test availability of the api from user without restricted role in tenant", dependsOnMethods={"testDirectLinkInTenant"})
    public void testDirectLinkInTenantWithoutRestrictedRoleUser() throws Exception {
        this.apiStoreClientAnotherUserOtherDomain = new APIStoreRestClient(this.storeURLHttp);
        HttpResponse response = this.apiStoreClientAnotherUserOtherDomain.login("directUrlUser1@wso2.com", String.valueOf(this.TENANT_SUBSCRIBER_1_PASSWORD));
        String publisher = this.storeContext.getContextTenant().getContextUser().getUserName();
        String session = (String)response.getHeaders().get("Set-Cookie");
        this.requestHeaders.clear();
        this.requestHeaders.put("Cookie", session);
        HttpResponse a = HttpRequestUtil.doGet((String)(this.getStoreURLHttps() + "/store/apis/info?name=" + "APIVisibilityWithDirectURLTestCaseAPIName" + "&version=" + "1.0.0" + "&provider=" + publisher + "&tenant=" + "wso2.com"), this.requestHeaders);
        Assert.assertTrue((boolean)a.getData().contains("user is not authorized to view the API"), (String)"API APIVisibilityWithDirectURLTestCaseAPINameis available to the unauthorised user in Tenant");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiPublisher.deleteAPI("APIVisibilityWithDirectURLTestCaseAPIName", "1.0.0", "admin");
        String publisher = this.storeContext.getContextTenant().getContextUser().getUserName();
        this.apiPublisherClientAdminOtherDomain.deleteAPI("APIVisibilityWithDirectURLTestCaseAPIName", "1.0.0", publisher);
        this.userManagementClient1.deleteRole("directUrlRole");
        this.userManagementClient1.deleteRole("directUrlRole1");
        this.userManagementClient1.deleteUser("directUrlUser");
        this.userManagementClient1.deleteUser("directUrlUser1");
        this.userManagementClient2.deleteRole("directUrlRole");
        this.userManagementClient2.deleteRole("directUrlRole1");
        this.userManagementClient2.deleteUser("directUrlUser");
        this.userManagementClient2.deleteUser("directUrlUser1");
        super.cleanUp();
    }
}

