/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AccessibilityOfBlockAPITestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "BlockAPITest";
    private final String API_CONTEXT = "BlockAPI";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_END_POINT_METHOD = "/customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "AccessibilityOfBlockAPITestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifier;
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private Map<String, String> requestHeaders;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("BlockAPITest", "BlockAPI", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiIdentifier = new APIIdentifier(this.providerName, "BlockAPITest", "1.0.0");
        this.apiStoreClientUser1.addApplication("AccessibilityOfBlockAPITestCase", "Unlimited", "", "");
    }

    @Test(groups={"wso2.am"}, description="Test invocation of the APi before block")
    public void testInvokeAPIBeforeChangeAPILifecycleToBlock() throws Exception {
        this.createPublishAndSubscribeToAPI(this.apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, "AccessibilityOfBlockAPITestCase");
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, "AccessibilityOfBlockAPITestCase").getAccessToken();
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "BlockAPITest", "1.0.0", "\"isApiExists\":true");
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("BlockAPI", "1.0.0") + "/customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api before block");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke  API  before block Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Change API lifecycle to block", dependsOnMethods={"testInvokeAPIBeforeChangeAPILifecycleToBlock"})
    public void testChangeAPILifecycleToBlock() throws Exception {
        APILifeCycleStateRequest blockUpdateRequest = new APILifeCycleStateRequest("BlockAPITest", this.providerName, APILifeCycleState.BLOCKED);
        blockUpdateRequest.setVersion("1.0.0");
        HttpResponse blockAPIActionResponse = this.apiPublisherClientUser1.changeAPILifeCycleStatus(blockUpdateRequest);
        Assert.assertEquals((int)blockAPIActionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)this.verifyAPIStatusChange(blockAPIActionResponse, APILifeCycleState.PUBLISHED, APILifeCycleState.BLOCKED), (String)("API status Change is invalid when block an API :" + this.getAPIIdentifierString(this.apiIdentifier) + " Response Code:" + blockAPIActionResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Invocation og the APi after block", dependsOnMethods={"testChangeAPILifecycleToBlock"})
    public void testInvokeAPIAfterChangeAPILifecycleToBlock() throws Exception {
        this.waitForAPIDeployment();
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("BlockAPI", "1.0.0") + "/customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_SERVICE_UNAVAILABLE, (String)"Response code mismatched when invoke api after block");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<am:code>700700</am:code><am:message>API blocked</am:message>"), (String)("Response data mismatched when invoke  API  after block Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiStoreClientUser1.removeApplication("AccessibilityOfBlockAPITestCase");
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
        super.cleanUp();
    }
}

