/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AccessibilityOfOldAPIAndCopyAPIWithReSubscriptionTestCase
extends APIManagerLifecycleBaseTest {
    private static final String API_NAME = "CopyAPIWithReSubscriptionTest";
    private static final String API_CONTEXT = "CopyAPIWithReSubscription";
    private static final String API_TAGS = "testTag1, testTag2, testTag3";
    private static final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private static final String API_END_POINT_METHOD = "/customers/123";
    private static final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private static final String API_VERSION_1_0_0 = "1.0.0";
    private static final String API_VERSION_2_0_0 = "2.0.0";
    private static final String APPLICATION_NAME = "AccessibilityOfOldAPIAndCopyAPIWithReSubscriptionTestCase";
    private static final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifierAPI1Version1;
    private APIIdentifier apiIdentifierAPI1Version2;
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private Map<String, String> requestHeaders;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, MalformedURLException {
        super.init();
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + API_END_POINT_POSTFIX_URL;
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean(API_NAME, API_CONTEXT, API_VERSION_1_0_0, this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags(API_TAGS);
        this.apiCreationRequestBean.setDescription(API_DESCRIPTION);
        this.apiIdentifierAPI1Version1 = new APIIdentifier(this.providerName, API_NAME, API_VERSION_1_0_0);
        this.apiIdentifierAPI1Version2 = new APIIdentifier(this.providerName, API_NAME, API_VERSION_2_0_0);
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStoreClientUser1.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiStoreClientUser1.addApplication(APPLICATION_NAME, "Unlimited", "", "");
    }

    @Test(groups={"wso2.am"}, description="Test subscribe of old api version.")
    public void testSubscriptionOfOldAPI() throws APIManagerIntegrationTestException {
        this.createAndPublishAPI(this.apiIdentifierAPI1Version1, this.apiCreationRequestBean, this.apiPublisherClientUser1, false);
        this.waitForAPIDeploymentSync(this.providerName, API_NAME, API_VERSION_1_0_0, "\"isApiExists\":true");
        HttpResponse oldVersionSubscribeResponse = this.subscribeToAPI(this.apiIdentifierAPI1Version1, APPLICATION_NAME, this.apiStoreClientUser1);
        Assert.assertEquals((int)oldVersionSubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful " + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1)));
        Assert.assertEquals((String)this.getValueFromJSON(oldVersionSubscribeResponse, "error"), (String)"false", (String)("Error in subscribe of old API version" + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1) + "Response Data:" + oldVersionSubscribeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test publishing of copied API with re-subscription required", dependsOnMethods={"testSubscriptionOfOldAPI"})
    public void testPublishCopiedAPIWithReSubscriptionRequired() throws APIManagerIntegrationTestException {
        this.copyAPI(this.apiIdentifierAPI1Version1, API_VERSION_2_0_0, this.apiPublisherClientUser1);
        APILifeCycleStateRequest publishUpdateRequest = new APILifeCycleStateRequest(API_NAME, this.providerName, APILifeCycleState.PUBLISHED);
        publishUpdateRequest.setVersion(API_VERSION_2_0_0);
        HttpResponse publishAPIResponse = this.apiPublisherClientUser1.changeAPILifeCycleStatusToPublish(this.apiIdentifierAPI1Version2, true);
        Assert.assertEquals((int)publishAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("API publish Response code is invalid " + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2)));
        Assert.assertTrue((boolean)this.verifyAPIStatusChange(publishAPIResponse, APILifeCycleState.CREATED, APILifeCycleState.PUBLISHED), (String)("API status Change is invalid in" + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2) + "Response Data:" + publishAPIResponse.getData()));
        this.waitForAPIDeploymentSync(this.providerName, API_NAME, API_VERSION_2_0_0, "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Test invocation of old API version  before the new version is subscribed.", dependsOnMethods={"testPublishCopiedAPIWithReSubscriptionRequired"})
    public void testInvokeOldAPIBeforeSubscribeTheNewVersion() throws Exception {
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, APPLICATION_NAME).getAccessToken();
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(API_CONTEXT, API_VERSION_1_0_0) + API_END_POINT_METHOD), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke old api before subscribe the new version");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains(API_RESPONSE_DATA), (String)("Response data mismatched when invoke old API version before subscribe the new version. Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test invocation of new API version  before the new version is subscribed.This invocation should be failed", dependsOnMethods={"testInvokeOldAPIBeforeSubscribeTheNewVersion"})
    public void testInvokeNewAPIBeforeSubscribeTheNewVersion() throws Exception {
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(API_CONTEXT, API_VERSION_2_0_0) + API_END_POINT_METHOD), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_FORBIDDEN, (String)"Response code mismatched when invoke new api before subscribe the new version");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<ams:code>900908</ams:code><ams:message>Resource forbidden </ams:message>"), (String)("Response data mismatched when invoke new API version before subscribe the new version. Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test subscribe the new API Version", dependsOnMethods={"testInvokeNewAPIBeforeSubscribeTheNewVersion"})
    public void testSubscribeTheNewVersion() throws Exception {
        HttpResponse httpResponseSubscribeNewVersion = this.subscribeToAPI(this.apiIdentifierAPI1Version2, APPLICATION_NAME, this.apiStoreClientUser1);
        Assert.assertEquals((int)httpResponseSubscribeNewVersion.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of New API version  when re-subscription required not successful. Invalid Response Code " + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2)));
        Assert.assertEquals((String)this.getValueFromJSON(httpResponseSubscribeNewVersion, "error"), (String)"false", (String)("Error in subscribe of New API version when re-subscription required not successful" + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2) + "Response Data:" + httpResponseSubscribeNewVersion.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test invocation of new API version  after the new version is subscribed.", dependsOnMethods={"testSubscribeTheNewVersion"})
    public void testInvokeNewAPIAfterSubscribeTheNewVersion() throws Exception {
        Thread.sleep(30000L);
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(API_CONTEXT, API_VERSION_2_0_0) + API_END_POINT_METHOD), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke new api after subscribe the new version");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains(API_RESPONSE_DATA), (String)("Response data mismatched when invoke new API version after subscribe the new version. Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiStoreClientUser1.removeApplication(APPLICATION_NAME);
        this.deleteAPI(this.apiIdentifierAPI1Version1, this.apiPublisherClientUser1);
        this.deleteAPI(this.apiIdentifierAPI1Version2, this.apiPublisherClientUser1);
        super.cleanUp();
    }
}

