/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ChangeAPITagsTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String TEST_TAG = "Tag3";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private Map<String, String> apiTagsMapBeforeChange;
    private Map<String, String> apiTagsMapAfterChange;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiTagsMapBeforeChange = new HashMap<String, String>();
        this.apiTagsMapBeforeChange.put("APITagTest1", "Tag1, Tag2, Tag3");
        this.apiTagsMapBeforeChange.put("APITagTest2", "Tag2, Tag3, Tag4");
        this.apiTagsMapBeforeChange.put("APITagTest3", "Tag1, Tag3, Tag5");
        this.apiTagsMapBeforeChange.put("APITagTest4", "Tag1, Tag2");
        this.apiTagsMapAfterChange = new HashMap<String, String>();
        this.apiTagsMapAfterChange.put("APITagTest1", "Tag1, Tag2");
        this.apiTagsMapAfterChange.put("APITagTest2", "Tag2, Tag4");
        this.apiTagsMapAfterChange.put("APITagTest3", "Tag1, Tag5");
        this.apiTagsMapAfterChange.put("APITagTest4", "Tag1, Tag2");
    }

    @Test(groups={"wso2.am"}, description="Test the filter by Tags before changing the Tags")
    public void testFilterByTagsBeforeTagChange() throws APIManagerIntegrationTestException, IOException, InterruptedException, XPathExpressionException {
        for (Map.Entry<String, String> apiTagEntry : this.apiTagsMapBeforeChange.entrySet()) {
            String apiName = apiTagEntry.getKey();
            String apiTags = apiTagEntry.getValue();
            String apiContext = apiName.toLowerCase();
            APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, apiName, "1.0.0");
            APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiName, apiContext, "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
            apiCreationRequestBean.setTags(apiTags);
            apiCreationRequestBean.setDescription("This is test API create by API manager integration test with tags " + apiTags);
            this.createAndPublishAPIWithoutRequireReSubscription(apiIdentifier, apiCreationRequestBean, this.apiPublisherClientUser1);
            this.waitForAPIDeploymentSync(apiIdentifier.getProviderName(), apiIdentifier.getApiName(), apiIdentifier.getVersion(), "\"isApiExists\":true");
            this.apiStoreClientUser1.waitForSwaggerDocument(apiIdentifier.getProviderName(), apiIdentifier.getApiName(), apiIdentifier.getVersion(), apiTags, this.executionMode);
        }
        HttpResponse apiPageFilteredWithTagsResponse = this.apiStoreClientUser1.getAPIPageFilteredWithTags("Tag3");
        Assert.assertEquals((int)apiPageFilteredWithTagsResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code wan not Ok:200 for retrieving the API page filtered with tags");
        String apiPageFilteredWithTagsResponseString = apiPageFilteredWithTagsResponse.getData();
        for (Map.Entry<String, String> apiTagEntry : this.apiTagsMapBeforeChange.entrySet()) {
            String apiLinkToTestInPage = "/store/apis/info?name=" + apiTagEntry.getKey() + "&version=" + "1.0.0" + "&provider=" + this.providerName + "&tenant=carbon.super&tag=" + "Tag3" + "";
            if (apiTagEntry.getValue().contains("Tag3")) {
                Assert.assertTrue((boolean)apiPageFilteredWithTagsResponseString.contains(apiLinkToTestInPage), (String)("API is not listed  with correct tag, API:" + apiTagEntry.getKey() + " Tag:" + "Tag3"));
                continue;
            }
            Assert.assertFalse((boolean)apiPageFilteredWithTagsResponseString.contains(apiLinkToTestInPage), (String)("API is  listed with incorrect tag, API:" + apiTagEntry.getKey() + " Tag:" + "Tag3"));
        }
    }

    @Test(groups={"wso2.am"}, description="Test the filter by Tags After changing the Tags", dependsOnMethods={"testFilterByTagsBeforeTagChange"})
    public void testUpdateTagsAndFilterByTags() throws APIManagerIntegrationTestException, MalformedURLException {
        for (Map.Entry<String, String> apiTagEntry : this.apiTagsMapAfterChange.entrySet()) {
            String apiName = apiTagEntry.getKey();
            String apiTags = apiTagEntry.getValue();
            String apiContext = apiName.toLowerCase();
            APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(apiName, apiContext, "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
            apiCreationRequestBean.setTags(apiTags);
            apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
            HttpResponse updateAPIHTTPResponse = this.apiPublisherClientUser1.updateAPI(apiCreationRequestBean);
            this.waitForAPIDeployment();
            Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Update API Response Code is invalid. API Name:" + apiName));
            Assert.assertEquals((String)this.getValueFromJSON(updateAPIHTTPResponse, "error"), (String)"false", (String)("Error in API Update in API Name:" + apiName + "Response Data:" + updateAPIHTTPResponse.getData()));
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        HttpResponse apiPageFilteredWithTagsResponse = this.apiStoreClientUser1.getAPIPageFilteredWithTags("Tag3");
        Assert.assertEquals((int)apiPageFilteredWithTagsResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code wan not Ok:200 for retrieving the API page filtered with tags");
        String apiPageFilteredWithTagsResponseString = apiPageFilteredWithTagsResponse.getData();
        for (Map.Entry<String, String> apiTagEntry : this.apiTagsMapAfterChange.entrySet()) {
            String apiLinkToTestInPage = "/store/apis/info?name=" + apiTagEntry.getKey() + "&version=" + "1.0.0" + "&provider=" + this.providerName + "&tenant=carbon.super&tag=" + "Tag3" + "";
            if (apiTagEntry.getValue().contains("Tag3")) {
                Assert.assertTrue((boolean)apiPageFilteredWithTagsResponseString.contains(apiLinkToTestInPage), (String)(" API is not listed  with correct tag, API:" + apiTagEntry.getKey() + " Tag:" + "Tag3"));
                continue;
            }
            Assert.assertFalse((boolean)apiPageFilteredWithTagsResponseString.contains(apiLinkToTestInPage), (String)("API is  listed with incorrect tag, API:" + apiTagEntry.getKey() + " Tag:" + "Tag3"));
        }
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        for (Map.Entry<String, String> apiTagEntry : this.apiTagsMapBeforeChange.entrySet()) {
            String apiName = apiTagEntry.getKey();
            APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, apiName, "1.0.0");
            this.deleteAPI(apiIdentifier, this.apiPublisherClientUser1);
        }
        super.cleanUp();
    }
}

