/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.xml.bind.DatatypeConverter;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ChangeEndPointSecurityOfAPITestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(ChangeEndPointSecurityOfAPITestCase.class);
    private final String API_NAME = "ChangeEndPointSecurityOfAPITest";
    private final String API_CONTEXT = "ChangeEndPointSecurityOfAPI";
    private final String API_TAGS = "security, username, password";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "ChangeEndPointSecurityOfAPI";
    private HashMap<String, String> requestHeadersGet;
    private APIPublisherRestClient apiPublisherClientUser1;
    private APIStoreRestClient apiStoreClientUser1;
    private String providerName;
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifier;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, XPathExpressionException, RemoteException {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        String publisherURLHttp = this.getPublisherURLHttp();
        String storeURLHttp = this.getStoreURLHttp();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiStoreClientUser1 = new APIStoreRestClient(storeURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiStoreClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.requestHeadersGet = new HashMap();
        this.requestHeadersGet.put("accept", "text/plain");
        this.requestHeadersGet.put("Content-Type", "text/plain");
        this.apiIdentifier = new APIIdentifier(this.providerName, "ChangeEndPointSecurityOfAPITest", "1.0.0");
        this.apiStoreClientUser1.addApplication("ChangeEndPointSecurityOfAPI", "Unlimited", "", "");
    }

    @Test(groups={"wso2.am"}, description="Test the API with endpoint security enabled with simple password that only has characters and numbers")
    public void testInvokeGETResourceWithSecuredEndPointPasswordOnlyNumbersAndLetters() throws Exception {
        String endpointUsername = "admin1";
        char[] endpointPassword = new char[]{'a', 'd', 'm', 'i', 'n', '1', '2', '3'};
        byte[] userNamePasswordByteArray = (endpointUsername + ":" + String.valueOf(endpointPassword)).getBytes();
        String encodedUserNamePassword = DatatypeConverter.printBase64Binary((byte[])userNamePasswordByteArray);
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("ChangeEndPointSecurityOfAPITest", "ChangeEndPointSecurityOfAPI", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags("security, username, password");
        apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        apiCreationRequestBean.setEndpointType("secured");
        apiCreationRequestBean.setEpUsername(endpointUsername);
        apiCreationRequestBean.setEpPassword(String.valueOf(endpointPassword));
        apiCreationRequestBean.setTier("Unlimited");
        apiCreationRequestBean.setTiersCollection("Unlimited");
        APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, "ChangeEndPointSecurityOfAPITest", "1.0.0");
        apiIdentifier.setTier("Unlimited");
        this.createPublishAndSubscribeToAPI(apiIdentifier, apiCreationRequestBean, this.apiPublisherClientUser1, this.apiStoreClientUser1, "ChangeEndPointSecurityOfAPI");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityOfAPITest", "1.0.0", "\"isApiExists\":true");
        String accessToken = this.generateApplicationKeys(this.apiStoreClientUser1, "ChangeEndPointSecurityOfAPI").getAccessToken();
        this.requestHeadersGet.put("Authorization", "Bearer " + accessToken);
        HttpResponse httpResponseGet = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeEndPointSecurityOfAPI", "1.0.0") + "/sec"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Invocation fails for GET request for endpoint type secured. username:" + endpointUsername + " password:" + String.valueOf(endpointPassword)));
        Assert.assertTrue((boolean)httpResponseGet.getData().contains(encodedUserNamePassword), (String)("Response Data not match for GET request for endpoint type secured. Expected value :" + encodedUserNamePassword + " not contains in " + "response data:" + httpResponseGet.getData() + "username:" + endpointUsername + " password:" + String.valueOf(endpointPassword)));
    }

    @Test(groups={"wso2.am"}, description="Test the API with endpoint security enabled with complex password", dependsOnMethods={"testInvokeGETResourceWithSecuredEndPointPasswordOnlyNumbersAndLetters"})
    public void testInvokeGETResourceWithSecuredEndPointComplexPassword() throws Exception {
        char[] symbolicCharacter = new char[]{'!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '-', '+', '=', '{', '[', '}', ']', '|', '\\', ':', ';', '\"', '\'', '<', ',', '>', '.', '?', '/'};
        block0: for (int i = 0; i < symbolicCharacter.length; ++i) {
            String endpointUsername = "user";
            char[] endpointPassword = new char[]{'a', 'b', 'c', 'd', symbolicCharacter[i], 'e', 'f', 'g', 'h', 'i', 'j', 'k'};
            byte[] userNamePasswordByteArray = (endpointUsername + ":" + String.valueOf(endpointPassword)).getBytes();
            String encodedUserNamePassword = DatatypeConverter.printBase64Binary((byte[])userNamePasswordByteArray);
            APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("ChangeEndPointSecurityOfAPITest", "ChangeEndPointSecurityOfAPI", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
            apiCreationRequestBean.setTags("security, username, password");
            apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
            apiCreationRequestBean.setVisibility("public");
            apiCreationRequestBean.setEndpointType("secured");
            apiCreationRequestBean.setEpUsername(endpointUsername);
            apiCreationRequestBean.setEpPassword(URLEncoder.encode(String.valueOf(endpointPassword), "UTF-8"));
            HttpResponse updateAPIHTTPResponse = this.apiPublisherClientUser1.updateAPI(apiCreationRequestBean);
            Assert.assertEquals((int)updateAPIHTTPResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Update APi with new Resource information fail");
            Assert.assertEquals((String)updateAPIHTTPResponse.getData(), (String)"{\"error\" : false}", (String)"Update APi with new Resource information fail");
            this.waitForAPIDeployment();
            int retries = 3;
            for (int j = 0; j <= retries; ++j) {
                HttpResponse httpResponseGet = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("ChangeEndPointSecurityOfAPI", "1.0.0") + "/sec"), this.requestHeadersGet);
                Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Invocation fails for GET request for endpoint type secured. username:" + endpointUsername + " password:" + String.valueOf(endpointPassword)));
                if (httpResponseGet.getData().contains(encodedUserNamePassword)) {
                    Assert.assertTrue((boolean)true);
                    continue block0;
                }
                if (j == retries) {
                    log.error((Object)"Max retry count reached!!!");
                    Assert.fail((String)("Response Data not match for GET request for endpoint type secured. Expected value : " + encodedUserNamePassword + " not contains in " + "response data: " + httpResponseGet.getData() + " username:" + endpointUsername + " password:" + String.valueOf(endpointPassword)));
                    continue;
                }
                log.warn((Object)("[Warning] Response Data not match for GET request for endpoint type secured. Expected value : " + encodedUserNamePassword + " not contains in " + "response data: " + httpResponseGet.getData() + " username:" + endpointUsername + " password:" + String.valueOf(endpointPassword) + " Retrying..."));
                this.waitForAPIDeployment();
            }
        }
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiStoreClientUser1.removeApplication("ChangeEndPointSecurityOfAPI");
        this.deleteAPI(this.apiIdentifier, this.apiPublisherClientUser1);
        super.cleanUp();
    }
}

