/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class NewVersionUpdateTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(NewVersionUpdateTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String publisherURLHttp;
    private String storeURLHttp;
    private APIRequest apiRequest;
    private String apiName = "NewVersionUpdateTestCaseAPIName";
    private String APIContext = "NewVersionUpdateTestCaseContext";
    private String tags = "test";
    private String endpointUrl;
    private String endpointUrlNew;
    private String description = "This is test API create by API manager integration test";
    private String APIVersion = "1.0.0";
    private String APIVersionNew = "2.0.0";

    @Factory(dataProvider="userModeDataProvider")
    public NewVersionUpdateTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api/add";
        this.endpointUrlNew = this.backEndServerUrl.getWebAppURLHttp() + "https://localhost:9443/am/sample/calculator/v1/api/multiply";
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Create new version and publish")
    public void testAPINewVersionCreation() throws Exception {
        String providerName = this.user.getUserName();
        this.apiRequest = new APIRequest(this.apiName, this.APIContext, new URL(this.endpointUrl));
        this.apiRequest.setTags(this.tags);
        this.apiRequest.setDescription(this.description);
        this.apiRequest.setVersion(this.APIVersion);
        this.apiRequest.setProvider(providerName);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiRequest);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(this.apiName, this.user.getUserName(), APILifeCycleState.PROTOTYPED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        serviceResponse = this.apiPublisher.copyAPI(this.apiRequest.getProvider(), this.apiRequest.getName(), this.apiRequest.getVersion(), this.APIVersionNew, null);
        this.verifyResponse(serviceResponse);
        serviceResponse = this.apiPublisher.getAPI(this.apiRequest.getName(), this.apiRequest.getProvider(), this.APIVersionNew);
        this.verifyResponse(serviceResponse);
        JSONObject response = new JSONObject(serviceResponse.getData());
        String version = response.getJSONObject("api").get("version").toString();
        Assert.assertEquals((String)version, (String)this.APIVersionNew);
        updateRequest = new APILifeCycleStateRequest(this.apiName, this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        Assert.assertTrue((boolean)serviceResponse.getData().contains(APILifeCycleState.PUBLISHED.getState()));
    }

    @Test(groups={"wso2.am"}, description="Update new version api with endpoint", dependsOnMethods={"testAPINewVersionCreation"})
    public void testNewVersionAPIUpdate() throws Exception {
        APIRequest apiUpdateRequest = new APIRequest(this.apiRequest.getName(), this.apiRequest.getContext(), new URL(this.endpointUrlNew));
        apiUpdateRequest.setProvider(this.apiRequest.getProvider());
        apiUpdateRequest.setVersion(this.APIVersionNew);
        HttpResponse serviceResponse = this.apiPublisher.updateAPI(apiUpdateRequest);
        this.verifyResponse(serviceResponse);
        this.waitForAPIDeployment();
        serviceResponse = this.apiPublisher.getAPI(this.apiRequest.getName(), this.apiRequest.getProvider(), this.APIVersionNew);
        this.verifyResponse(serviceResponse);
        JSONObject response = new JSONObject(serviceResponse.getData());
        String endpointConfig = response.getJSONObject("api").get("endpointConfig").toString();
        Assert.assertTrue((boolean)endpointConfig.contains(this.endpointUrlNew));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiPublisher.deleteAPI(this.apiName, this.APIVersion, this.user.getUserName());
        this.apiPublisher.deleteAPI(this.apiName, this.APIVersionNew, this.user.getUserName());
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

