/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class RegistryLifeCycleInclusionTest
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "RegistryLifeCycleInclusionAPI";
    private final String API_CONTEXT = "RegistryLifeCycleInclusionAPI";
    private static final String API_VERSION_1_0_0 = "1.0.0";
    private static final String API_VERSION_2_0_0 = "2.0.0";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private APIPublisherRestClient apiPublisherClientUser1;
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifier;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("RegistryLifeCycleInclusionAPI", "RegistryLifeCycleInclusionAPI", API_VERSION_1_0_0, this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        String publisherURLHttp = this.getPublisherURLHttps();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        this.apiIdentifier = new APIIdentifier(this.providerName, "RegistryLifeCycleInclusionAPI", API_VERSION_1_0_0);
    }

    @Test(groups={"wso2.am"}, description="Test LC tab of an published api")
    public void testAPIInfoLifecycleTabForPublishedAPI() throws Exception {
        this.createAndPublishAPI(this.apiIdentifier, this.apiCreationRequestBean, this.apiPublisherClientUser1, false);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "RegistryLifeCycleInclusionAPI", API_VERSION_1_0_0, "\"isApiExists\":true");
        HttpResponse resp = this.apiPublisherClientUser1.getAPIInformationPage("RegistryLifeCycleInclusionAPI", this.providerName, API_VERSION_1_0_0);
        Assert.assertEquals((boolean)resp.getData().contains("Deploy as a Prototype"), (boolean)true, (String)"'Deploy as a Prototype' not visible");
        Assert.assertEquals((boolean)resp.getData().contains("Demote to Created"), (boolean)true, (String)"'Demote to Created' not visible");
        Assert.assertEquals((boolean)resp.getData().contains("Block"), (boolean)true, (String)"'Block' not visible");
        Assert.assertEquals((boolean)resp.getData().contains("Deprecate"), (boolean)true, (String)"'Deprecate' not visible");
        Assert.assertEquals((boolean)resp.getData().contains("changed the API status from  'CREATED' to 'PUBLISHED'"), (boolean)true, (String)"Incorrect state change displayed");
    }

    @Test(groups={"wso2.am"}, description="Test checklist item visibility for new version of an api", dependsOnMethods={"testAPIInfoLifecycleTabForPublishedAPI"})
    public void testChecklistItemsVisibility() throws Exception {
        this.copyAPI(this.apiIdentifier, API_VERSION_2_0_0, this.apiPublisherClientUser1);
        HttpResponse resp = this.apiPublisherClientUser1.getAPIInformationPage("RegistryLifeCycleInclusionAPI", this.providerName, API_VERSION_2_0_0);
        Assert.assertEquals((boolean)resp.getData().contains("Deploy as a Prototype"), (boolean)true, (String)"'Deploy as a Prototype' not visible");
        Assert.assertEquals((boolean)resp.getData().contains("Publish"), (boolean)true, (String)"'Publish' not visible");
        Assert.assertEquals((boolean)resp.getData().contains("Requires re-subscription"), (boolean)true, (String)"'Requires re-subscription' checklist item not visible");
        Assert.assertEquals((boolean)resp.getData().contains("Deprecate old versions"), (boolean)true, (String)"'Deprecate old versions' checklist item not visible");
    }

    @Test(groups={"wso2.am"}, description="Test LC state change visibility in the LC tab in publisher", dependsOnMethods={"testChecklistItemsVisibility"})
    public void testLCStateChengeVisibility() throws Exception {
        HttpResponse resp = this.apiPublisherClientUser1.getAPIInformationPage("RegistryLifeCycleInclusionAPI", this.providerName, API_VERSION_2_0_0);
        Assert.assertEquals((boolean)resp.getData().contains("CREATED"), (boolean)true, (String)"API is not in CREATED state");
        Assert.assertEquals((boolean)resp.getData().contains("Deploy as a Prototype"), (boolean)true, (String)"'Deploy as a Prototype' not visible");
        Assert.assertEquals((boolean)resp.getData().contains("Publish"), (boolean)true, (String)"'Publish' not visible");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("RegistryLifeCycleInclusionAPI", this.providerName, APILifeCycleState.PUBLISHED);
        updateRequest.setVersion(API_VERSION_2_0_0);
        this.apiPublisherClientUser1.changeAPILifeCycleStatus(updateRequest);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "RegistryLifeCycleInclusionAPI", API_VERSION_2_0_0, "\"isApiExists\":true");
        resp = this.apiPublisherClientUser1.getAPIInformationPage("RegistryLifeCycleInclusionAPI", this.providerName, API_VERSION_2_0_0);
        Assert.assertEquals((boolean)resp.getData().contains("PUBLISHED"), (boolean)true, (String)"API is not in PUBLISHED state");
        Assert.assertEquals((boolean)resp.getData().contains("changed the API status from  'CREATED' to 'PUBLISHED'"), (boolean)true, (String)"Incorrect state change displayed");
        Assert.assertEquals((boolean)resp.getData().contains("Deploy as a Prototype"), (boolean)true, (String)"'Deploy as a Prototype' not visible");
        Assert.assertEquals((boolean)resp.getData().contains("Demote to Created"), (boolean)true, (String)"'Demote to Created' not visible");
        Assert.assertEquals((boolean)resp.getData().contains("Block"), (boolean)true, (String)"'Block' not visible");
        Assert.assertEquals((boolean)resp.getData().contains("Deprecate"), (boolean)true, (String)"'Deprecate' not visible");
        updateRequest = new APILifeCycleStateRequest("RegistryLifeCycleInclusionAPI", this.providerName, APILifeCycleState.BLOCKED);
        updateRequest.setVersion(API_VERSION_2_0_0);
        this.apiPublisherClientUser1.changeAPILifeCycleStatus(updateRequest);
        this.waitForAPIDeployment();
        resp = this.apiPublisherClientUser1.getAPIInformationPage("RegistryLifeCycleInclusionAPI", this.providerName, API_VERSION_2_0_0);
        Assert.assertEquals((boolean)resp.getData().contains("BLOCKED"), (boolean)true, (String)"API is not in BLOCKED state");
        Assert.assertEquals((boolean)resp.getData().contains("changed the API status from  'PUBLISHED' to 'BLOCKED'"), (boolean)true, (String)"Incorrect state change displayed");
        Assert.assertEquals((boolean)resp.getData().contains("Re-Publish"), (boolean)true, (String)"'Re-Publish' not visible");
        Assert.assertEquals((boolean)resp.getData().contains("Deprecate"), (boolean)true, (String)"'Deprecate' not visible");
        updateRequest = new APILifeCycleStateRequest("RegistryLifeCycleInclusionAPI", this.providerName, APILifeCycleState.DEPRECATED);
        updateRequest.setVersion(API_VERSION_2_0_0);
        this.apiPublisherClientUser1.changeAPILifeCycleStatus(updateRequest);
        this.waitForAPIDeployment();
        resp = this.apiPublisherClientUser1.getAPIInformationPage("RegistryLifeCycleInclusionAPI", this.providerName, API_VERSION_2_0_0);
        Assert.assertEquals((boolean)resp.getData().contains("DEPRECATED"), (boolean)true, (String)"API is not in DEPRECATED state");
        Assert.assertEquals((boolean)resp.getData().contains("changed the API status from  'BLOCKED' to 'DEPRECATED'"), (boolean)true, (String)"Incorrect state change displayed");
        Assert.assertEquals((boolean)resp.getData().contains("Retire"), (boolean)true, (String)"'Retire' not visible");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

