/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.sdk;

import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;

public class SDKGenerationTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(SDKGenerationTestCase.class);
    private final String firstTenantDomain = "tenant1.com";
    private final String firstTenantAdminUserName = "firstAdmin";
    private final String firstTenantAdminPassword = "password1";
    private final String secondTenantDomain = "tenant2.com";
    private final String secondTenantAdminUserName = "secondAdmin";
    private final String secondTenantAdminPassword = "password2";
    private final String apiName = "TestAPI";
    private final String apiVersion = "1.0.0";
    private final String apiProvider = "firstAdmin@tenant1.com";
    private APIPublisherRestClient apiPublisher;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.tenantManagementServiceClient.addTenant("tenant1.com", "password1", "firstAdmin", "demo");
        this.tenantManagementServiceClient.addTenant("tenant2.com", "password2", "secondAdmin", "demo");
    }

    @Test(groups={"wso2.am"}, description="SDK Generation test case")
    public void testSDKGeneration() throws Exception {
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiPublisher.login("firstAdmin@tenant1.com", "password1");
        String apiContext = "testContext";
        String url = "https://localhost:9443/test";
        APIRequest apiRequest = new APIRequest("TestAPI", apiContext, new URL(url));
        String tags = "sdkGen";
        apiRequest.setTags(tags);
        String description = "This is test API create by API manager integration test.";
        apiRequest.setDescription(description);
        apiRequest.setVersion("1.0.0");
        apiRequest.setSandbox(url);
        apiRequest.setResourceMethod("GET");
        apiRequest.setProvider("firstAdmin@tenant1.com");
        apiRequest.setVisibility("public");
        this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("TestAPI", "firstAdmin@tenant1.com", APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.apiPublisher.logout();
        String sdkLanguage = "java";
        boolean isSDKGenerationSuccessfulInSameTenant = this.generateSDK("firstAdmin@tenant1.com", "password1", "TestAPI", "1.0.0", "firstAdmin@tenant1.com", sdkLanguage);
        boolean isSDKGenerationSuccessfulAcrossTenants = this.generateSDK("secondAdmin@tenant2.com", "password2", "TestAPI", "1.0.0", "firstAdmin@tenant1.com", sdkLanguage);
        Assert.assertTrue((isSDKGenerationSuccessfulInSameTenant && isSDKGenerationSuccessfulAcrossTenants ? 1 : 0) != 0);
    }

    @Test(groups={"wso2.am"}, description="SDK Generation test case for private apis")
    public void testSDKGenerationForPrivateAPIs() throws Exception {
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        this.apiPublisher.login("firstAdmin@tenant1.com", "password1");
        String apiName = "PrivateAPI";
        String apiContext = "privateContext";
        String url = "https://localhost:9443/test";
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(url));
        String tags = "sdkGen";
        apiRequest.setTags(tags);
        String description = "This is test API create by API manager integration test.";
        apiRequest.setDescription(description);
        apiRequest.setVersion("1.0.0");
        apiRequest.setSandbox(url);
        apiRequest.setResourceMethod("GET");
        apiRequest.setProvider("firstAdmin@tenant1.com");
        apiRequest.setVisibility("private");
        this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, "firstAdmin@tenant1.com", APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.apiPublisher.logout();
        String sdkLanguage = "java";
        boolean isSDKGenerationSuccessfulInSameTenant = this.generateSDK("firstAdmin@tenant1.com", "password1", apiName, "1.0.0", "firstAdmin@tenant1.com", sdkLanguage);
        boolean isSDKGenerationSuccessfulForPrivateAPIs = this.generateSDK("secondAdmin@tenant2.com", "password2", apiName, "1.0.0", "firstAdmin@tenant1.com", sdkLanguage);
        Assert.assertTrue((boolean)isSDKGenerationSuccessfulInSameTenant);
    }

    private boolean generateSDK(String tenantAwareUserName, String password, String apiName, String apiVersion, String apiProvider, String language) throws Exception {
        APIStoreRestClient apiStore = new APIStoreRestClient(this.storeURLHttp);
        apiStore.login(tenantAwareUserName, password);
        HttpResponse sdkGenerationResponse = apiStore.generateSDKUpdated(language, apiName, apiVersion, apiProvider);
        Header header = sdkGenerationResponse.getFirstHeader("Content-disposition");
        if (header == null) {
            this.log.error((Object)("SDK generation failed for API : " + apiName + " " + apiVersion + " User : " + tenantAwareUserName));
            return false;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        sdkGenerationResponse.getEntity().writeTo((OutputStream)byteArrayOutputStream);
        String tempDirectoryLocation = "tmp";
        String zipFileName = RandomStringUtils.randomAlphabetic((int)5) + ".zip";
        File sdkArchive = new File(tempDirectoryLocation + File.separator + zipFileName);
        FileUtils.writeByteArrayToFile((File)sdkArchive, (byte[])byteArrayOutputStream.toByteArray());
        apiStore.logout();
        if ((double)FileUtils.sizeOf((File)sdkArchive) > 0.0) {
            this.log.info((Object)("SDK generated successfully for API : " + apiName + " " + apiVersion + " User : " + tenantAwareUserName));
            return true;
        }
        this.log.error((Object)("SDK generation failed for API : " + apiName + " " + apiVersion + " User : " + tenantAwareUserName));
        return false;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiPublisher.deleteAPI("TestAPI", "1.0.0", "firstAdmin@tenant1.com");
        this.tenantManagementServiceClient.deleteTenant("tenant1.com");
        this.tenantManagementServiceClient.deleteTenant("tenant2.com");
        super.cleanUp();
    }
}

