/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.application;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTier;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class ApplicationCallbackURLTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(ApplicationCallbackURLTestCase.class);
    private APIStoreRestClient apiStore;
    private String storeURLHttp;
    private String description = "description";
    private String appName = "ApplicationCallbackURLApp";

    @Factory(dataProvider="userModeDataProvider")
    public ApplicationCallbackURLTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.storeURLHttp = this.getStoreURLHttp();
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Sample Application creation")
    public void testApplicationCreation() throws Exception {
        String callbackURL = "http://localhost:9443/store/";
        HttpResponse serviceResponse = this.apiStore.addApplication(this.appName, APIThrottlingTier.UNLIMITED.getState(), callbackURL, this.description);
        this.verifyResponse(serviceResponse);
        JSONObject res = new JSONObject(this.apiStore.getApplications().getData());
        Assert.assertFalse((boolean)res.getBoolean("error"));
        JSONArray arr = res.getJSONArray("applications");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject app = arr.getJSONObject(i);
            if (!this.appName.equals(app.getString("name"))) continue;
            Assert.assertEquals((String)callbackURL, (String)app.getString("callbackUrl"), (String)"Application callback URL is not Updated as Expected");
            return;
        }
        Assert.fail((String)"Created application not found");
    }

    @Test(groups={"wso2.am"}, description="Update application with callback URL", dependsOnMethods={"testApplicationCreation"}, enabled=false)
    public void testApplicationUpdate() throws Exception {
        String callbackURL = "malformedUrl";
        HttpResponse serviceResponse = this.apiStore.updateApplication(this.appName, this.appName, callbackURL, this.description, APIThrottlingTier.UNLIMITED.getState());
        this.verifyResponse(serviceResponse);
        JSONObject res = new JSONObject(this.apiStore.getApplications().getData());
        Assert.assertFalse((boolean)res.getBoolean("error"));
        JSONArray arr = res.getJSONArray("applications");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject app = arr.getJSONObject(i);
            if (!this.appName.equals(app.getString("name"))) continue;
            Assert.assertNotEquals((Object)callbackURL, (Object)app.getString("callbackUrl"), (String)"Application callback URL is updated with malformed URL");
            Assert.assertNotEquals((Object)"Not Specified", (Object)app.getString("callbackUrl"), (String)"Application callback URL is updated with malformed URL");
            return;
        }
        Assert.fail((String)"Updated application not found");
    }

    @Test(groups={"wso2.am"}, description="Sample Application creation", dependsOnMethods={"testApplicationCreation"})
    public void testApplicationUpdateIpAsCallBackURL() throws Exception {
        String callbackURL = "https://10.100.7.74:9443/store/";
        HttpResponse serviceResponse = this.apiStore.updateApplication(this.appName, this.appName, callbackURL, this.description, APIThrottlingTier.UNLIMITED.getState());
        this.verifyResponse(serviceResponse);
        JSONObject res = new JSONObject(this.apiStore.getApplications().getData());
        Assert.assertFalse((boolean)res.getBoolean("error"));
        JSONArray arr = res.getJSONArray("applications");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject app = arr.getJSONObject(i);
            if (!this.appName.equals(app.getString("name"))) continue;
            Assert.assertEquals((String)callbackURL, (String)app.getString("callbackUrl"), (String)"Application callback URL is not Updated as Expected");
            return;
        }
        Assert.fail((String)"Updated application not found");
    }

    @Test(groups={"wso2.am"}, description="Update application with callback URL", dependsOnMethods={"testApplicationUpdateIpAsCallBackURL"}, enabled=false)
    public void testApplicationUpdateValidIpAsCallBackURL() throws Exception {
        String callbackURL = "10.100.7.74:9443/store/";
        HttpResponse serviceResponse = this.apiStore.updateApplication(this.appName, this.appName, callbackURL, this.description, APIThrottlingTier.UNLIMITED.getState());
        this.verifyResponse(serviceResponse);
        JSONObject res = new JSONObject(this.apiStore.getApplications().getData());
        Assert.assertFalse((boolean)res.getBoolean("error"));
        JSONArray arr = res.getJSONArray("applications");
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject app = arr.getJSONObject(i);
            if (!this.appName.equals(app.getString("name"))) continue;
            Assert.assertNotEquals((Object)callbackURL, (Object)app.getString("callbackUrl"), (String)"Application callback URL is updated with malformed URL");
            Assert.assertNotEquals((Object)"Not Specified", (Object)app.getString("callbackUrl"), (String)"Application callback URL is updated with malformed URL");
            return;
        }
        Assert.fail((String)"Updated application not found");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication(this.appName);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

