/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.application;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APIThrottlingTier;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class GrantTypeTokenGenerateTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(GrantTypeTokenGenerateTestCase.class);
    private final String API_NAME = "GrantTypeTokenGenerateAPIName";
    private final String API_CONTEXT = "GrantTypeTokenGenerateContext";
    private final String DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION = "1.0.0";
    private final String APP_NAME = "GrantTypeTokenGenerateApp";
    private final String CALLBACK_URL_UPDATE_APP_NAME = "GrantTypeTokenGenerateCallbackApp";
    private final String CALLBACK_URL = "https://localhost:9443/store/";
    private final String TAGS = "grantType,implicitly,code";
    private final String APPLICATION_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private final String LOCATION_HEADER = "Location";
    private final String AUTHORIZATION_CODE_GRANT_TYPE = "authorization_code";
    private final String TIER_COLLECTION = "Unlimited";
    private String publisherURLHttps;
    private String storeURLHttp;
    private APICreationRequestBean apiCreationRequestBean;
    private List<APIResourceBean> resList;
    private String endpointUrl;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String consumerKey;
    private String consumerSecret;
    private String authorizeURL;
    private String tokenURL;
    private String identityLoginURL;
    private List<NameValuePair> urlParameters = new ArrayList<NameValuePair>();
    private Map<String, String> headers = new HashMap<String, String>();

    @Factory(dataProvider="userModeDataProvider")
    public GrantTypeTokenGenerateTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttps = this.publisherUrls.getWebAppURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttps);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        this.authorizeURL = this.gatewayUrlsWrk.getWebAppURLNhttps() + "/authorize";
        this.tokenURL = this.gatewayUrlsWrk.getWebAppURLNhttps() + "/token";
        this.identityLoginURL = this.getKeyManagerURLHttps() + "/oauth2/authorize";
    }

    @Test(groups={"wso2.am"}, description="Sample API creation")
    public void testAPICreation() throws Exception {
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("GrantTypeTokenGenerateAPIName", "GrantTypeTokenGenerateContext", "1.0.0", providerName, new URL(this.endpointUrl));
        this.apiCreationRequestBean.setTags("grantType,implicitly,code");
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTiersCollection("Unlimited");
        this.resList = new ArrayList<APIResourceBean>();
        APIResourceBean res1 = new APIResourceBean("GET", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType(), "20KPerMin", "/add");
        this.resList.add(res1);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("GrantTypeTokenGenerateAPIName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
    }

    @Test(groups={"wso2.am"}, description="Test Application Creation", dependsOnMethods={"testAPICreation"})
    public void testApplicationCreation() throws Exception {
        HttpResponse serviceResponse = this.apiStore.addApplication("GrantTypeTokenGenerateApp", APIThrottlingTier.UNLIMITED.getState(), "https://localhost:9443/store/", "this-is-test");
        this.verifyResponse(serviceResponse);
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("GrantTypeTokenGenerateAPIName", this.user.getUserName());
        subscriptionRequest.setApplicationName("GrantTypeTokenGenerateApp");
        subscriptionRequest.setTier("Unlimited");
        serviceResponse = this.apiStore.subscribe(subscriptionRequest);
        this.verifyResponse(serviceResponse);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("GrantTypeTokenGenerateApp");
        generateAppKeyRequest.setCallbackUrl("https://localhost:9443/store/");
        serviceResponse = this.apiStore.generateApplicationKey(generateAppKeyRequest);
        this.verifyResponse(serviceResponse);
        JSONObject response = new JSONObject(serviceResponse.getData());
        this.consumerKey = response.getJSONObject("data").getJSONObject("key").get("consumerKey").toString();
        this.consumerSecret = response.getJSONObject("data").getJSONObject("key").get("consumerSecret").toString();
        Assert.assertNotNull((Object)this.consumerKey, (String)"Consumer Key not found");
        Assert.assertNotNull((Object)this.consumerSecret, (String)"Consumer Secret not found ");
    }

    @Test(groups={"wso2.am"}, description="Test authorization_code token generation", dependsOnMethods={"testApplicationCreation"})
    public void testAuthCode() throws Exception {
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        String url = this.authorizeURL + "?response_type=code&" + "client_id=" + this.consumerKey + "&scope=PRODUCTION&redirect_uri=" + "https://localhost:9443/store/";
        HttpResponse res = HTTPSClientUtils.doGet((String)url, this.headers);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        String locationHeader = (String)res.getHeaders().get("Location");
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String sessionDataKey = this.getURLParameter(locationHeader, "sessionDataKey");
        Assert.assertNotNull((Object)sessionDataKey, (String)"Couldn't found sessionDataKey from the Location Header");
        this.headers.clear();
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("username", this.user.getUserName()));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("password", this.user.getPassword()));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("tocommonauth", "true"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("sessionDataKey", sessionDataKey));
        res = HTTPSClientUtils.doPost((String)this.identityLoginURL, this.headers, this.urlParameters);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        locationHeader = (String)res.getHeaders().get("Location");
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String sessionDataKeyConsent = this.getURLParameter(locationHeader, "sessionDataKeyConsent");
        Assert.assertNotNull((Object)sessionDataKey, (String)"Couldn't found sessionDataKeyConsent from the Location Header");
        this.headers.clear();
        this.urlParameters.clear();
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("consent", "approve"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("hasApprovedAlways", "false"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("sessionDataKeyConsent", sessionDataKeyConsent));
        res = HTTPSClientUtils.doPost((String)this.identityLoginURL, this.headers, this.urlParameters);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        locationHeader = (String)res.getHeaders().get("Location");
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String tempCode = this.getURLParameter(locationHeader, "code");
        Assert.assertNotNull((Object)tempCode, (String)"Couldn't found auth code from the Location Header");
        this.headers.clear();
        this.urlParameters.clear();
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("grant_type", "authorization_code"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("code", tempCode));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("redirect_uri", "https://localhost:9443/store/"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("client_secret", this.consumerSecret));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("client_id", this.consumerKey));
        res = HTTPSClientUtils.doPost((String)this.tokenURL, this.headers, this.urlParameters);
        Assert.assertEquals((int)res.getResponseCode(), (int)200, (String)"Response code is not as expected");
        JSONObject response = new JSONObject(res.getData());
        String accessToken = response.getString("access_token");
        Assert.assertNotNull((Object)accessToken, (String)"Couldn't found accessToken");
        this.requestHeaders.clear();
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("GrantTypeTokenGenerateContext", "1.0.0");
        res = HTTPSClientUtils.doGet((String)(invokeURL + "/add?x=1&y=1"), this.requestHeaders);
        Assert.assertEquals((int)res.getResponseCode(), (int)200, (String)"Response code is not as expected");
    }

    @Test(groups={"wso2.am"}, description="Test implicit token generation", dependsOnMethods={"testAuthCode"})
    public void testImplicit() throws Exception {
        this.headers.clear();
        this.urlParameters.clear();
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        String url = this.authorizeURL + "?response_type=token&" + "client_id=" + this.consumerKey + "&scope=PRODUCTION&redirect_uri=" + "https://localhost:9443/store/";
        HttpResponse res = HTTPSClientUtils.doGet((String)url, this.headers);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        String locationHeader = (String)res.getHeaders().get("Location");
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String sessionDataKey = this.getURLParameter(locationHeader, "sessionDataKey");
        Assert.assertNotNull((Object)sessionDataKey, (String)"Couldn't found sessionDataKey from the Location Header");
        this.headers.clear();
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("username", this.user.getUserName()));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("password", this.user.getPassword()));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("tocommonauth", "true"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("sessionDataKey", sessionDataKey));
        res = HTTPSClientUtils.doPost((String)this.identityLoginURL, this.headers, this.urlParameters);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        locationHeader = (String)res.getHeaders().get("Location");
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String sessionDataKeyConsent = this.getURLParameter(locationHeader, "sessionDataKeyConsent");
        Assert.assertNotNull((Object)sessionDataKey, (String)"Couldn't found sessionDataKeyConsent from the Location Header");
        this.headers.clear();
        this.urlParameters.clear();
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("consent", "approve"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("hasApprovedAlways", "false"));
        this.urlParameters.add((NameValuePair)new BasicNameValuePair("sessionDataKeyConsent", sessionDataKeyConsent));
        res = HTTPSClientUtils.doPost((String)this.identityLoginURL, this.headers, this.urlParameters);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        locationHeader = (String)res.getHeaders().get("Location");
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        String accessToken = this.getURLParameter(locationHeader, "access_token");
        Assert.assertNotNull((Object)accessToken, (String)"Couldn't found auth code from the Location Header");
        this.requestHeaders.clear();
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("GrantTypeTokenGenerateContext", "1.0.0");
        res = HTTPSClientUtils.doGet((String)(invokeURL + "/add?x=1&y=1"), this.requestHeaders);
        Assert.assertEquals((int)res.getResponseCode(), (int)200, (String)"Response code is not as expected");
    }

    @Test(groups={"wso2.am"}, description="Test Application Creation without callback URL", dependsOnMethods={"testImplicit"})
    public void testApplicationCreationWithoutCallBackURL() throws Exception {
        HttpResponse serviceResponse = this.apiStore.addApplication("GrantTypeTokenGenerateCallbackApp", APIThrottlingTier.UNLIMITED.getState(), "", "this-is-test");
        this.verifyResponse(serviceResponse);
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("GrantTypeTokenGenerateAPIName", this.user.getUserName());
        subscriptionRequest.setApplicationName("GrantTypeTokenGenerateCallbackApp");
        subscriptionRequest.setTier("Unlimited");
        serviceResponse = this.apiStore.subscribe(subscriptionRequest);
        this.verifyResponse(serviceResponse);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("GrantTypeTokenGenerateCallbackApp");
        serviceResponse = this.apiStore.generateApplicationKey(generateAppKeyRequest);
        this.verifyResponse(serviceResponse);
        JSONObject response = new JSONObject(serviceResponse.getData());
        this.consumerKey = response.getJSONObject("data").getJSONObject("key").get("consumerKey").toString();
        this.consumerSecret = response.getJSONObject("data").getJSONObject("key").get("consumerSecret").toString();
        Assert.assertNotNull((Object)this.consumerKey, (String)"Consumer Key not found");
        Assert.assertNotNull((Object)this.consumerSecret, (String)"Consumer Secret not found ");
    }

    @Test(groups={"wso2.am"}, description="Test authorization_code token generation", dependsOnMethods={"testApplicationCreationWithoutCallBackURL"})
    public void testAuthRequestWithoutCallbackURL() throws Exception {
        this.headers.clear();
        this.headers.put("Content-Type", "application/x-www-form-urlencoded");
        String url = this.authorizeURL + "?response_type=code&" + "client_id=" + this.consumerKey + "&scope=PRODUCTION&redirect_uri=";
        HttpResponse res = HTTPSClientUtils.doGet((String)url, this.headers);
        Assert.assertEquals((int)res.getResponseCode(), (int)302, (String)"Response code is not as expected");
        String locationHeader = (String)res.getHeaders().get("Location");
        Assert.assertNotNull((Object)locationHeader, (String)"Couldn't found Location Header");
        Assert.assertTrue((boolean)locationHeader.contains("oauthErrorCode"), (String)"Redirection page should be a error page");
    }

    @Test(groups={"wso2.am"}, description="Test authorization_code token generation", dependsOnMethods={"testAuthRequestWithoutCallbackURL"})
    public void testApplicationUpdateAndTestKeyGeneration() throws Exception {
        String keyType = "PRODUCTION";
        String authorizedDomains = "ALL";
        String retryAfterFailure = String.valueOf(false);
        String jsonParams = "{\"grant_types\":\"urn:ietf:params:oauth:grant-type:saml2-bearer iwa:ntlm implicit refresh_token client_credentials authorization_code password\"}";
        HttpResponse response = this.apiStore.updateClientApplication("GrantTypeTokenGenerateCallbackApp", keyType, authorizedDomains, retryAfterFailure, jsonParams, "https://localhost:9443/store/");
        this.verifyResponse(response);
        this.testAuthCode();
        this.testImplicit();
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication("GrantTypeTokenGenerateApp");
        this.apiStore.removeApplication("GrantTypeTokenGenerateCallbackApp");
        this.apiPublisher.deleteAPI("GrantTypeTokenGenerateAPIName", "1.0.0", this.user.getUserName());
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    private String getURLParameter(String url, String attribute) {
        try {
            Pattern p = Pattern.compile(attribute + "=([^&]+)");
            Matcher m = p.matcher(url);
            if (m.find()) {
                return m.group(1);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return null;
    }
}

