/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.header;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import org.apache.axiom.om.OMElement;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.monitor.utils.WireMonitorServer;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.integration.common.admin.client.AuthenticatorClient;

public class ContentLengthHeaderTestCase
extends APIMIntegrationBaseTest {
    public WireMonitorServer wireServer;
    private String gatewaySessionCookie;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        this.tenantManagementServiceClient.addTenant("abc.com", "abc123", "abc", "demo");
        String file = "artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "property" + File.separator + "FORCE_HTTP_CONTENT_LENGTH.xml";
        OMElement synapseConfig = APIMTestCaseUtils.loadResource((String)file);
        AuthenticatorClient login = new AuthenticatorClient(this.gatewayContextWrk.getContextUrls().getBackEndUrl());
        String session = login.login("abc@abc.com", "abc123", "localhost");
        APIMTestCaseUtils.updateSynapseConfiguration((OMElement)synapseConfig, (String)this.gatewayContextWrk.getContextUrls().getBackEndUrl(), (String)session);
        this.waitForAPIDeployment();
        this.wireServer = new WireMonitorServer(8991);
    }

    @SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
    @Test(groups={"wso2.am"}, description="Test for reading the Content-Length header in the request")
    public void testFORCE_HTTP_CONTENT_LENGTHPropertyTest() throws Exception {
        this.wireServer.start();
        FileInputStream fis = new FileInputStream(this.getAMResourceLocation() + File.separator + "synapseconfigs" + File.separator + "property" + File.separator + "placeOrder.xml");
        InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF8");
        BufferedReader inputReader = new BufferedReader(isr);
        URL postEndpoint = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/abc.com/stock/1.0.0");
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("foo.out")));
        HttpRequestUtil.sendPostRequest((Reader)inputReader, (URL)postEndpoint, (Writer)out);
        String response = this.wireServer.getCapturedMessage();
        Assert.assertTrue((boolean)response.contains("Content-Length"), (String)"Content-Length not found in out going message");
    }

    @AfterClass(alwaysRun=true)
    public void stop() throws Exception {
        this.cleanUp();
    }
}

