/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.json;

import java.net.URL;
import java.util.HashMap;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.common.FileManager;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class ESBJAVA3380TestCase
extends APIMIntegrationBaseTest {
    private ServerConfigurationManager serverConfigurationManager;
    private String gatewaySessionCookie;
    private static final Log log = LogFactory.getLog(ESBJAVA3380TestCase.class);

    @Factory(dataProvider="userModeDataProvider")
    public ESBJAVA3380TestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider(name="userModeDataProvider")
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        this.serverConfigurationManager = new ServerConfigurationManager(new AutomationContext("APIM", "gateway-wrk", TestUserMode.SUPER_TENANT_ADMIN));
        super.init(this.userMode);
        this.gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        String apiMngrSynapseConfigPath = "/artifacts/AM/synapseconfigs/property/json_to_xml.xml";
        if (this.userMode == TestUserMode.SUPER_TENANT_USER || this.userMode == TestUserMode.SUPER_TENANT_ADMIN) {
            this.loadSynapseConfigurationFromClasspath(apiMngrSynapseConfigPath, this.gatewayContextMgt, this.gatewaySessionCookie);
        } else {
            String apiConfiguration = FileManager.readFile((String)(TestConfigurationProvider.getResourceLocation() + apiMngrSynapseConfigPath));
            apiConfiguration = apiConfiguration.replace("context=\"/Weather\"", "context=\"/t/wso2.com/Weather\"");
            this.updateSynapseConfiguration(AXIOMUtil.stringToOM((String)apiConfiguration), this.gatewayContextMgt, this.gatewaySessionCookie);
        }
    }

    @Test(groups={"noRestart"}, description="Json to XML Test other")
    public void jsonToXmlTestCase() throws Exception {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.clear();
        requestHeaders.put("Content-Type", "application/json");
        String payload = "{ \"http://purl.org/dc/elements/1.1/creator\" : \"url\"}";
        HttpResponse response = null;
        try {
            response = HttpRequestUtil.doPost((URL)new URL(this.getAPIInvocationURLHttp("Weather/1.0.0")), (String)payload, requestHeaders);
            assert (response != null);
            Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Response code mismatched while Json to XML test case");
        }
        catch (Exception e) {
            if (e.getLocalizedMessage().contains("Connection error")) {
                Thread.sleep(20000L);
                this.serverConfigurationManager.restartGracefully();
                super.init();
                Thread.sleep(20000L);
                try {
                    response = HttpRequestUtil.doPost((URL)new URL(this.getAPIInvocationURLHttp("Weather/1.0.0")), (String)payload, requestHeaders);
                    assert (response != null);
                    Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Response code mismatched while Json to XML test case");
                }
                catch (Exception e2) {
                    Assert.assertFalse((boolean)e.getLocalizedMessage().contains("Connection error"), (String)("Problem in converting json to xml. " + e.getLocalizedMessage()));
                }
            }
            log.error((Object)("connection error. " + e.getLocalizedMessage()));
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

