/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIM4312NPEAfterRequestTimeoutTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIM4312NPEAfterRequestTimeoutTestCase.class);
    private String gatewaySessionCookie;

    @Factory(dataProvider="userModeDataProvider")
    public APIM4312NPEAfterRequestTimeoutTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider(name="userModeDataProvider")
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        String apiMngrSynapseConfigPath = this.userMode == TestUserMode.SUPER_TENANT_ADMIN ? "/artifacts/AM/synapseconfigs/rest/dummy_api_APIMANAGER-4312.xml" : "/artifacts/AM/synapseconfigs/rest/dummy_api_APIMANAGER-4312_tenant.xml";
        this.loadSynapseConfigurationFromClasspath(apiMngrSynapseConfigPath, this.gatewayContextMgt, this.gatewaySessionCookie);
    }

    @Test(groups={"noRestart"}, description="Test for NPE after timeout", expectedExceptions={NoHttpResponseException.class})
    public void nullPointerAfterTimeoutTest() throws Exception {
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            String apiInvocationURL = this.getAPIInvocationURLHttp("pizzashack/1.0.0");
            HttpGet get = new HttpGet(apiInvocationURL + "/menu");
            httpclient.execute((HttpUriRequest)get);
        }
        catch (NullPointerException e) {
            Assert.assertTrue((boolean)false, (String)"Null pointer exception shouldn't have occurred after request time out");
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

