/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIM5474SingleCharacterQueryParameter
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIM5474SingleCharacterQueryParameter.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
        this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "dummy_api_APIM5474.xml", this.gatewayContextMgt, gatewaySessionCookie);
    }

    @Test(groups={"wso2.am"}, description="testing error responses")
    public void testAPIWithSingleCharacterQueryParam() throws Exception {
        HttpResponse response = this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.verifyResponse(response);
        String apiName = "SingleCharacterParamCheckAPI";
        String apiVersion = "1.0.0";
        String apiContext = "paramCheck";
        String endpointUrl = this.getAPIInvocationURLHttp("response");
        try {
            APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(endpointUrl));
            apiRequest.setVersion(apiVersion);
            apiRequest.setTiersCollection("Unlimited");
            apiRequest.setTier("Unlimited");
            apiRequest.setUriTemplate("/{a}");
            response = this.apiPublisher.addAPI(apiRequest);
            this.verifyResponse(response);
            APILifeCycleStateRequest updateRequest1 = new APILifeCycleStateRequest(apiName, this.user.getUserName(), APILifeCycleState.PUBLISHED);
            response = this.apiPublisher.changeAPILifeCycleStatus(updateRequest1);
            this.verifyResponse(response);
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)("APIManagerIntegrationTestException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

