/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM678ApplicationCreationTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIM678ApplicationCreationTestCase.class);
    private APIStoreRestClient apiStore;
    private String applicationName = "NewApplication1";
    private static final String description = "NewApplicationCreation";
    private static final String appTier = "Unlimited";
    private List<String> applicationsList = new ArrayList<String>();
    List<String> allAppsList = new ArrayList<String>();

    @Factory(dataProvider="userModeDataProvider")
    public APIM678ApplicationCreationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @DataProvider(name="createApplicationWithValidData")
    public static Object[][] createAppWithValidDataProvider() throws Exception {
        return new Object[][]{{"NewApplication1", appTier, description}, {"NewApplication2", appTier, ""}, {"NewApplication3", appTier, description}, {"NewApplication4", appTier, ""}};
    }

    @DataProvider(name="createApplicationWithInValidData")
    public static Object[][] createAppWithInValidDataProvider() throws Exception {
        return new Object[][]{{"", appTier, ""}, {"NewApplication5", "", description}, {"", "", description}};
    }

    @DataProvider(name="createApplicationWithCustomAttributes")
    public static Object[][] createApplicationWithCustomAttributes() throws Exception {
        return new Object[][]{{"NewApplication6", appTier, description, "{\"Ext_ref_id\":\"sample_ext_ref_id\",\"Billing_tier\":\"sample_tier\"}"}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        log.info((Object)("Test Starting user mode:" + this.userMode));
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        HttpResponse loginResponse = this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        Assert.assertEquals((int)loginResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code is Mismatced in Login Response");
        JSONObject loginJsonObject = new JSONObject(loginResponse.getData());
        Assert.assertFalse((boolean)loginJsonObject.getBoolean("error"), (String)"Response data error in Login Request");
        log.info((Object)("Login User: " + this.storeContext.getContextTenant().getContextUser().getUserName()));
        this.applicationsList.add("DefaultApplication");
        this.removeAllApps();
    }

    @Test(groups={"webapp"}, dataProvider="createApplicationWithValidData", description="Create an Application")
    public void testApplicationCreation(String applicationName, String tier, String description) throws Exception {
        HttpResponse addApplicationResponse = this.apiStore.addApplication(applicationName, appTier, "", description);
        Assert.assertEquals((int)addApplicationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)("Response Code is mismatched in add application: " + applicationName));
        JSONObject addApplicationJsonObject = new JSONObject(addApplicationResponse.getData());
        Assert.assertFalse((boolean)addApplicationJsonObject.getBoolean("error"), (String)("Error in Application Creation: " + applicationName));
        Assert.assertEquals((Object)addApplicationJsonObject.get("status"), (Object)"APPROVED", (String)("Error in Application Creation: " + applicationName));
        this.applicationsList.add(applicationName);
    }

    @Test(groups={"webapp"}, dataProvider="createApplicationWithInValidData", description="Create application for invalid data")
    public void testApplicationCreationForInvalidData(String applicationName, String tier, String description) throws Exception {
        HttpResponse addApplicationResponse = this.apiStore.addApplication(applicationName, appTier, "", description);
        JSONObject addApplicationJsonObject = new JSONObject(addApplicationResponse.getData());
        HttpResponse getAllApplicationsResponse = this.apiStore.getAllApplications();
        JSONObject allApplicationsJsonObject = new JSONObject(getAllApplicationsResponse.getData());
    }

    @Test(groups={"webapp"}, description="Create already created application", dependsOnMethods={"testApplicationCreation"})
    public void testAlreadyCreatedApplication() throws Exception {
        HttpResponse alreadyCreatedApplicationResponse = this.apiStore.addApplication(this.applicationName, appTier, "", description);
        Assert.assertEquals((int)alreadyCreatedApplicationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code in application creation");
        JSONObject alreadyCreatedAppJsonObject = new JSONObject(alreadyCreatedApplicationResponse.getData());
        Assert.assertTrue((boolean)alreadyCreatedAppJsonObject.getBoolean("error"), (String)("Error in already created application : " + this.applicationName));
        Assert.assertTrue((boolean)alreadyCreatedAppJsonObject.getString("message").contains(" A duplicate application already exists by the name - " + this.applicationName), (String)("Error in Response Message : " + this.applicationName));
    }

    @Test(groups={"webapp"}, description="Get all created applications", dependsOnMethods={"testApplicationCreation"})
    public void getAllCreatedApplications() throws Exception {
        HttpResponse getAllApplicationsResponse = this.apiStore.getAllApplications();
        JSONObject getAllApplicationsJsonObject = new JSONObject(getAllApplicationsResponse.getData());
        Assert.assertFalse((boolean)getAllApplicationsJsonObject.getBoolean("error"), (String)"Error in Get All Applications Response");
        JSONArray getApplicationsJsonArray = getAllApplicationsJsonObject.getJSONArray("applications");
        Assert.assertTrue((getApplicationsJsonArray.length() >= this.applicationsList.size() ? 1 : 0) != 0, (String)"Error in Application Count");
        for (int allAppsIndex = 0; allAppsIndex < getApplicationsJsonArray.length(); ++allAppsIndex) {
            String appName = getApplicationsJsonArray.getJSONObject(allAppsIndex).getString("name");
            this.allAppsList.add(appName);
        }
        log.info((Object)("Get All Applications Response List: " + this.allAppsList));
        log.info((Object)("All Apps from Created App List: " + this.applicationsList));
        for (int applicationCount = 0; applicationCount < this.allAppsList.size(); ++applicationCount) {
            String applicationName = this.applicationsList.get(applicationCount);
            Assert.assertTrue((boolean)this.allAppsList.contains(applicationName), (String)("Error in getting Applications: " + applicationName));
        }
    }

    @Test(groups={"webapp"}, description="Update an application", dependsOnMethods={"testApplicationCreation"})
    public void testUpdateApplication() throws Exception {
        HttpResponse getAllAppResponse = this.apiStore.getAllApplications();
        Assert.assertEquals((int)getAllAppResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code mismatched in Get All Applications");
        JSONObject getAllAppJsonObject = new JSONObject(getAllAppResponse.getData());
        Assert.assertFalse((boolean)getAllAppJsonObject.getBoolean("error"), (String)"Error in get All Applications Response");
        JSONArray getAllApplicationsJsonArray = getAllAppJsonObject.getJSONArray("applications");
        JSONObject updateJsonObject = null;
        block0: for (int j = 0; j < this.applicationsList.size(); ++j) {
            for (int i = 0; i < getAllApplicationsJsonArray.length(); ++i) {
                if (!this.applicationsList.get(j).equals(getAllApplicationsJsonArray.getJSONObject(i).getString("name"))) continue;
                updateJsonObject = getAllApplicationsJsonArray.getJSONObject(j);
                continue block0;
            }
        }
        String oldAppName = updateJsonObject.getString("name");
        String appDescription = updateJsonObject.getString("description");
        String appTier = updateJsonObject.getString("tier");
        String newApppName = "UpdateApplication";
        HttpResponse updateNameResponse = this.apiStore.updateApplication(oldAppName, newApppName, "", appDescription, appTier);
        Assert.assertEquals((int)updateNameResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)" Response Code is mismatched");
        JSONObject updateNameJson = new JSONObject(updateNameResponse.getData());
        Assert.assertFalse((boolean)updateNameJson.getBoolean("error"), (String)"Error in Application Name Update");
        HttpResponse verifyAppName = this.apiStore.getAllApplications();
        Assert.assertEquals((int)verifyAppName.getResponseCode(), (int)Response.Status.OK.getStatusCode());
        JSONObject verifyAppNameJsonObject = new JSONObject(verifyAppName.getData());
        log.info((Object)verifyAppNameJsonObject);
        JSONArray verifyAppJsonArray = verifyAppNameJsonObject.getJSONArray("applications");
        boolean isUpdatedAppAvailable = false;
        String updatedAppName = "";
        for (int appsIndex = 0; appsIndex < verifyAppJsonArray.length(); ++appsIndex) {
            updatedAppName = verifyAppJsonArray.getJSONObject(appsIndex).getString("name");
            if (!updatedAppName.equals(newApppName)) continue;
            isUpdatedAppAvailable = true;
            break;
        }
        Assert.assertTrue((boolean)isUpdatedAppAvailable, (String)"Error in update Application name");
        String updatedDescription = "updatednewdescription";
        HttpResponse updateDescriptionResponse = this.apiStore.updateApplication(updatedAppName, updatedAppName, "", updatedDescription, "50PerMin");
        Assert.assertEquals((int)updateDescriptionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Invalid in Description update Response");
        JSONObject updateDescriptionJsonObject = new JSONObject(updateDescriptionResponse.getData());
        Assert.assertFalse((boolean)updateDescriptionJsonObject.getBoolean("error"), (String)"Error in Description Update Response");
        HttpResponse verifyAppDesResponse = this.apiStore.getAllApplications();
        Assert.assertEquals((int)verifyAppName.getResponseCode(), (int)Response.Status.OK.getStatusCode());
        JSONObject verifyAppDesJsonObject = new JSONObject(verifyAppDesResponse.getData());
        JSONArray verifyAppDesJsonArray = verifyAppDesJsonObject.getJSONArray("applications");
        boolean isUpdatedDescriptionAvailable = false;
        for (int applicationsIndex = 0; applicationsIndex < verifyAppDesJsonArray.length(); ++applicationsIndex) {
            if (!verifyAppDesJsonArray.getJSONObject(applicationsIndex).getString("name").contains(updatedAppName)) continue;
            isUpdatedDescriptionAvailable = true;
            Assert.assertTrue((boolean)updatedDescription.contains(verifyAppDesJsonArray.getJSONObject(applicationsIndex).getString("description")), (String)"Error in Description update Response");
            break;
        }
        Assert.assertTrue((boolean)isUpdatedDescriptionAvailable, (String)"Error in Application Description Update Response");
        String newTier = "50PerMin";
        HttpResponse updateTierResponse = this.apiStore.updateApplication(updatedAppName, updatedAppName, "", updatedDescription, newTier);
        Assert.assertEquals((int)updateTierResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code Mismatched in update Tier Response");
        JSONObject updateTierJsonObject = new JSONObject(updateTierResponse.getData());
        Assert.assertFalse((boolean)updateTierJsonObject.getBoolean("error"), (String)"Error in Update Tier Response");
        HttpResponse verifyAppTierResponse = this.apiStore.getAllApplications();
        Assert.assertEquals((int)verifyAppName.getResponseCode(), (int)Response.Status.OK.getStatusCode());
        JSONObject verifyAppTierJsonObject = new JSONObject(verifyAppTierResponse.getData());
        JSONArray verifyAppTierJsonArray = verifyAppDesJsonObject.getJSONArray("applications");
        boolean isTierUpdated = false;
        for (int appIndex = 0; appIndex < verifyAppTierJsonArray.length(); ++appIndex) {
            if (!updatedAppName.contains(verifyAppTierJsonArray.getJSONObject(appIndex).getString("name"))) continue;
            isTierUpdated = true;
            Assert.assertTrue((boolean)verifyAppTierJsonArray.getJSONObject(appIndex).getString("tier").contains(newTier), (String)"Error in tier Update Response");
            break;
        }
        Assert.assertTrue((boolean)isTierUpdated, (String)"Error in Tier Update Response");
    }

    @Test(groups={"webapp"}, description="Remove application")
    public void testRemoveApplication() throws Exception {
        String applicationName = "RemoveMeApp";
        HttpResponse createApplicationResponse = this.apiStore.addApplication(applicationName, appTier, "", description);
        JSONObject createAppJsonObject = new JSONObject(createApplicationResponse.getData());
        Assert.assertFalse((boolean)createAppJsonObject.getBoolean("error"), (String)("Error in Create an Application: " + applicationName));
        Assert.assertEquals((Object)createAppJsonObject.get("status"), (Object)"APPROVED", (String)("Error in Application Creation: " + applicationName));
        HttpResponse getAllAppResponse = this.apiStore.getAllApplications();
        JSONObject getAllAppJsonObject = new JSONObject(getAllAppResponse.getData());
        Assert.assertFalse((boolean)getAllAppJsonObject.getBoolean("error"), (String)"Error in Get All Applications Response");
        JSONArray getAllAppJsonArray = getAllAppJsonObject.getJSONArray("applications");
        ArrayList<String> appNameList = new ArrayList<String>();
        for (int nameArrayIndex = 0; nameArrayIndex < getAllAppJsonArray.length(); ++nameArrayIndex) {
            String appName = getAllAppJsonArray.getJSONObject(nameArrayIndex).getString("name");
            appNameList.add(appName);
        }
        boolean isApplicationExist = false;
        for (int applicationListIndex = 0; applicationListIndex < appNameList.size(); ++applicationListIndex) {
            if (!((String)appNameList.get(applicationListIndex)).equals(applicationName)) continue;
            isApplicationExist = true;
            break;
        }
        Assert.assertTrue((boolean)isApplicationExist, (String)("Error : Application is Not Exists : " + applicationName));
        HttpResponse removeAppResponse = this.apiStore.removeApplication(applicationName);
        JSONObject removeAppJsonObject = new JSONObject(removeAppResponse.getData());
        Assert.assertFalse((boolean)removeAppJsonObject.getBoolean("error"), (String)("Error in Remove Application Response: " + applicationName));
        HttpResponse getAllAppsResponse = this.apiStore.getAllApplications();
        JSONObject getAllAppsJsonObject = new JSONObject(getAllAppsResponse.getData());
        JSONArray getAllAppsJsonArray = getAllAppsJsonObject.getJSONArray("applications");
        ArrayList<String> allAppsList = new ArrayList<String>();
        boolean isRemoveAppExist = false;
        for (int getAllAppsIndex = 0; getAllAppsIndex < getAllAppsJsonArray.length(); ++getAllAppsIndex) {
            String appName = getAllAppsJsonArray.getJSONObject(getAllAppsIndex).getString("name");
            allAppsList.add(appName);
            if (!appName.equals(applicationName)) continue;
            isRemoveAppExist = true;
            break;
        }
        Assert.assertFalse((boolean)isRemoveAppExist, (String)("Error in Remove App Verification : " + applicationName));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.removeAllApps();
        super.cleanUp();
    }

    public void removeAllApps() throws Exception {
        HttpResponse getAllAppResponse = this.apiStore.getAllApplications();
        Assert.assertEquals((int)getAllAppResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error in Get All App Response code");
        JSONObject getAllAppJsonObject = new JSONObject(getAllAppResponse.getData());
        Assert.assertFalse((boolean)getAllAppJsonObject.getBoolean("error"), (String)"Error in Response");
        JSONArray getAllAppJsonArray = getAllAppJsonObject.getJSONArray("applications");
        ArrayList<String> allAppResponseList = new ArrayList<String>();
        for (int i = 0; i < getAllAppJsonArray.length(); ++i) {
            allAppResponseList.add(getAllAppJsonArray.getJSONObject(i).getString("name"));
            if (getAllAppJsonArray.getJSONObject(i).getString("name").equals("DefaultApplication")) continue;
            this.apiStore.removeApplication(getAllAppJsonArray.getJSONObject(i).getString("name"));
        }
    }

    @Test(groups={"webapp"}, dataProvider="createApplicationWithCustomAttributes", description="Create an Application")
    public void testApplicationCreationWithCustomAttributes(String applicationName, String tier, String description, String applicationAttributes) throws Exception {
        HttpResponse addApplicationResponse = this.apiStore.addApplicationWithCustomAttributes(applicationName, tier, "", description, applicationAttributes);
        Assert.assertEquals((int)addApplicationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)("Response Code is mismatched in add application: " + applicationName + " with custom attributes"));
        JSONObject applicationJsonObject = new JSONObject(addApplicationResponse.getData());
        Assert.assertFalse((boolean)applicationJsonObject.getBoolean("error"), (String)("Error in Application Creation: " + applicationName));
        Assert.assertEquals((Object)applicationJsonObject.get("status"), (Object)"APPROVED", (String)("Error in Application Creation: " + applicationName));
    }
}

