/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIMANAGER3226APINameWithDifferentCaseTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIMANAGER3226APINameWithDifferentCaseTestCase.class);
    private APIPublisherRestClient apiPublisher;
    String apiName = "echo";
    String providerName;
    String apiVersion = "1.0.0";

    @Factory(dataProvider="userModeDataProvider")
    public APIMANAGER3226APINameWithDifferentCaseTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.providerName = this.user.getUserName();
        String publisherURLHttp = this.getPublisherURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Test validation of adding api with same name and different case(uppercase)")
    public void testValidateAddAPIsWithDifferentCase() throws Exception {
        String apiContext = "test";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        String description = "This is test API create by API manager integration test";
        APIRequest apiRequest = new APIRequest(this.apiName, apiContext, new URL(url));
        apiRequest.setDescription(description);
        apiRequest.setVersion(this.apiVersion);
        apiRequest.setProvider(this.providerName);
        HttpResponse addResponse = this.apiPublisher.addAPI(apiRequest);
        Assert.assertEquals((int)addResponse.getResponseCode(), (int)200, (String)"Error while adding API");
        String apiNameWithUppercaseLetters = "ECho";
        apiRequest = new APIRequest(apiNameWithUppercaseLetters, apiContext, new URL(url));
        apiRequest.setDescription(description);
        apiRequest.setVersion(this.apiVersion);
        apiRequest.setProvider(this.providerName);
        HttpResponse addDuplicateAPIResponse = this.apiPublisher.addAPI(apiRequest);
        log.info((Object)("Response: " + addDuplicateAPIResponse.getData()));
        Assert.assertTrue((boolean)addDuplicateAPIResponse.getData().contains("A duplicate API already exists for ECho"), (String)"Validation fails for adding API with same name with different case");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiPublisher.deleteAPI(this.apiName, this.apiVersion, this.providerName);
        super.cleanUp();
    }
}

