/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.xml.xpath.XPathExpressionException;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.tenant.mgt.stub.TenantMgtAdminServiceExceptionException;

public class APIMANAGER4081PaginationCountTestCase
extends APIMIntegrationBaseTest {
    private String publisherURLHttp;
    private String tenantDomain = "paginationtest.com";
    private String[] APINames;
    private String providerName;
    private int numberOfAPIs = 5;
    private String APIVersion = "1.0.0";
    private APIPublisherRestClient apiPublisher;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() {
        try {
            super.init();
            this.publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
            this.tenantManagementServiceClient.addTenant(this.tenantDomain, this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), "demo");
        }
        catch (XPathExpressionException e) {
            Assert.assertTrue((boolean)false, (String)"Error occurred while retrieving context. Pagination count test case failed.");
        }
        catch (APIManagerIntegrationTestException e) {
            Assert.assertTrue((boolean)false, (String)"Error occurred while adding tenant. Pagination count test case failed.");
        }
        catch (RemoteException e) {
            Assert.assertTrue((boolean)false, (String)"Error occurred while creating session. Pagination count test case failed.");
        }
        catch (TenantMgtAdminServiceExceptionException e) {
            Assert.assertTrue((boolean)false, (String)"Error while getting tenant management service. Pagination count test case failed.");
        }
    }

    @Test(groups={"wso2.am"}, description="Pagination test case")
    public void testPagination() throws Exception {
        this.APINames = new String[this.numberOfAPIs];
        boolean isLoginSuccess = false;
        boolean isPaginationCorrect = false;
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        APIStoreRestClient apiStore = new APIStoreRestClient(storeURLHttp);
        HttpResponse storeLoginResponse = null;
        String successResponse = "{\"error\" : false}";
        try {
            int i;
            for (i = 0; i < this.numberOfAPIs; ++i) {
                String APIName;
                this.APINames[i] = APIName = "PaginationTestAPI" + Integer.toString(i);
                String APIContext = "paginationTest" + Integer.toString(i);
                String tags = "pagination";
                String url = "https://localhost:9443/test";
                String description = "This is test API create by API manager integration test";
                String APIVersion = "1.0.0";
                this.providerName = this.publisherContext.getContextTenant().getTenantAdmin().getUserName() + "@" + this.tenantDomain;
                this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
                this.apiPublisher.login(this.publisherContext.getContextTenant().getTenantAdmin().getUserName() + "@" + this.tenantDomain, this.publisherContext.getContextTenant().getTenantAdmin().getPassword());
                APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url));
                apiRequest.setTags(tags);
                apiRequest.setDescription(description);
                apiRequest.setVersion(APIVersion);
                apiRequest.setSandbox(url);
                apiRequest.setResourceMethod("GET");
                apiRequest.setProvider(this.providerName);
                this.apiPublisher.addAPI(apiRequest);
                APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(APIName, this.providerName, APILifeCycleState.PUBLISHED);
                this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
            }
            for (i = 0; i < this.numberOfAPIs; ++i) {
                String apiName = "PaginationTestAPI" + Integer.toString(i);
                String apiVersion = "1.0.0";
                this.waitForAPIDeploymentSync(this.publisherContext.getContextTenant().getTenantAdmin().getUserName() + "@" + this.tenantDomain, apiName, apiVersion, "\"isApiExists\":true");
            }
            Thread.sleep(60000L);
            storeLoginResponse = apiStore.login("admin", "admin");
        }
        catch (XPathExpressionException e) {
            Assert.assertTrue((boolean)false, (String)"Error occurred when retrieving context to add APIs. Pagination count test case failed.");
        }
        catch (APIManagerIntegrationTestException e) {
            Assert.assertTrue((boolean)false, (String)"Error occurred while log-in to add APIs. Pagination count test case failed.");
        }
        catch (MalformedURLException e) {
            Assert.assertTrue((boolean)false, (String)"Invalid service URL to add APIs. Pagination count test case failed.");
            String loginResponseCookie = null;
            if (storeLoginResponse != null) {
                loginResponseCookie = (String)storeLoginResponse.getHeaders().get("Set-Cookie");
                if (successResponse.equals(storeLoginResponse.getData())) {
                    isLoginSuccess = true;
                }
            }
            if (isLoginSuccess && loginResponseCookie != null) {
                int offset = 2;
                int countInFirstPage = this.getPaginationElementsCount(storeURLHttp, loginResponseCookie, 0, offset);
                int countInSecondPage = this.getPaginationElementsCount(storeURLHttp, loginResponseCookie, 2, offset);
                int countInThirdPage = this.getPaginationElementsCount(storeURLHttp, loginResponseCookie, 4, offset);
                if (countInFirstPage == 2 && countInSecondPage == 2 && countInThirdPage == 1) {
                    isPaginationCorrect = true;
                }
            }
            Assert.assertTrue((boolean)isPaginationCorrect, (String)"Incorrect Pagination during API Search. Pagination count test case failed.");
        }
    }

    private int getPaginationElementsCount(String storeUrl, String loginResponseCookie, int start, int offset) throws JSONException {
        JSONObject paginationDataObject;
        String paginationUrl = storeUrl + "store/site/blocks/api/listing/ajax/list.jag?" + "action=getAllPaginatedPublishedAPIs&" + "tenant=" + this.tenantDomain + "&start=" + Integer.toString(start) + "&end=" + Integer.toString(offset);
        int numberOfAPIsInCurrentPage = 0;
        HashMap<String, String> paginationRequestHeaders = new HashMap<String, String>();
        paginationRequestHeaders.put("Cookie", loginResponseCookie);
        HttpResponse paginationFetchResponse = null;
        try {
            paginationFetchResponse = HttpRequestUtil.doGet((String)paginationUrl, paginationRequestHeaders);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)false, (String)"Retrieving response for Pagination count test case has failed.");
        }
        String dataText = "";
        if (paginationFetchResponse != null) {
            dataText = paginationFetchResponse.getData();
        }
        if ("false".equals((paginationDataObject = new JSONObject(dataText)).get("error").toString())) {
            numberOfAPIsInCurrentPage = paginationDataObject.getJSONArray("apis").length();
        }
        return numberOfAPIsInCurrentPage;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.apiPublisher != null) {
            for (int j = 0; j < this.numberOfAPIs; ++j) {
                this.apiPublisher.deleteAPI(this.APINames[j], this.APIVersion, this.providerName);
            }
        }
        super.cleanUp();
    }
}

