/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.header.util.SimpleSocketServer;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class APIMANAGER5326CustomStatusMsgTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIMANAGER5326CustomStatusMsgTestCase.class);
    public static final int PORT = 1989;
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private SimpleSocketServer simpleSocketServer;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
        String expectedResponse = "HTTP/1.1 400 Custom response\r\nServer: testServer\r\nContent-Type: text/xml; charset=UTF-8\r\n Transfer-Encoding: chunked\r\n\r\n\"<?xml version=\"1.0\" encoding=\"UTF-8\"?><test></test>";
        this.simpleSocketServer = new SimpleSocketServer(1989, expectedResponse);
        this.simpleSocketServer.start();
        Thread.sleep(10000L);
    }

    @Test(groups={"wso2.am"}, description="testing error responses")
    public void testAPIErrorResponse() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse response = this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.verifyResponse(response);
        String apiName = "ErrorResponseCheckAPI";
        String apiVersion = "1.0.0";
        String apiContext = "message";
        String endpointUrl = "http://" + InetAddress.getLocalHost().getHostName() + ":1989";
        String appName = "testApplication";
        try {
            APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(endpointUrl));
            apiRequest.setVersion(apiVersion);
            apiRequest.setTiersCollection("Unlimited");
            apiRequest.setTier("Unlimited");
            response = this.apiPublisher.addAPI(apiRequest);
            this.verifyResponse(response);
            APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, this.user.getUserName(), APILifeCycleState.PUBLISHED);
            response = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
            this.verifyResponse(response);
            response = this.apiStore.login(this.user.getUserName(), this.user.getPassword());
            this.verifyResponse(response);
            response = this.apiStore.addApplication(appName, "Unlimited", "", "");
            this.verifyResponse(response);
            SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiName, apiVersion, this.user.getUserName(), appName, "Unlimited");
            response = this.apiStore.subscribe(subscriptionRequest);
            this.verifyResponse(response);
            APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(appName);
            String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
            JSONObject responseJson = new JSONObject(responseString);
            String accessToken = responseJson.getJSONObject("data").getJSONObject("key").getString("accessToken");
            String apiInvocationUrl = this.getAPIInvocationURLHttp(apiContext, apiVersion);
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpGet getRequest1 = new HttpGet(apiInvocationUrl);
            getRequest1.addHeader((Header)new BasicHeader("Authorization", "Bearer " + accessToken));
            this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
            HttpResponse httpResponse = httpclient.execute((HttpUriRequest)getRequest1);
            Assert.assertEquals((int)httpResponse.getStatusLine().getStatusCode(), (int)400, (String)"Response Code Mismatched");
            Assert.assertEquals((boolean)httpResponse.getStatusLine().toString().contains("Custom response"), (boolean)true, (String)"Response received with Custom Status Message");
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)("APIManagerIntegrationTestException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (JSONException e) {
            log.error((Object)("Error parsing JSON to get access token " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (XPathExpressionException e) {
            log.error((Object)("XPathExpressionException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (IOException e) {
            log.error((Object)("IOException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

