/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.xpath.XPathExpressionException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.registry.ResourceAdminServiceClient;
import org.wso2.am.admin.clients.webapp.WebAppAdminClient;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.test.utils.webapp.WebAppDeploymentUtil;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.exceptions.AutomationUtilException;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.registry.resource.stub.ResourceAdminServiceExceptionException;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIStateChangeWorkflowTestCase
extends APIManagerLifecycleBaseTest {
    private APIPublisherRestClient apiPublisher;
    private String publisherURLHttp;
    private String storeURLHttp;
    private String userName;
    private String originalWFExtentionsXML;
    private String newWFExtentionsXML;
    private ResourceAdminServiceClient resourceAdminServiceClient;
    private APIIdentifier apiIdentifier;
    private final String APIM_CONFIG_XML = "api-manager.xml";
    private final String DEFAULT_WF_EXTENTIONS_XML_REG_CONFIG_LOCATION = "/_system/governance/apimgt/applicationdata/workflow-extensions.xml";
    private String appName = "sample-application-workflow2";
    private static JSONParser parser = new JSONParser();
    private ServerConfigurationManager serverConfigurationManager;
    private String apiName = "APIStateWf";
    private String apiVersion = "1.0.0";
    private WebAppAdminClient webAppAdminClient;
    private String wfreferenceId = null;
    private String clientId;
    private String clientSecrect;

    @BeforeClass(groups={"noRestart"}, alwaysRun=true)
    public void setEnvironment() throws AutomationUtilException, XPathExpressionException, IOException, APIManagerIntegrationTestException, URISyntaxException, ResourceAdminServiceExceptionException {
        super.init();
        String testArtifactPath = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "configFiles" + File.separator + "workflowapistatechange" + File.separator + "BPMNProcessServerApp-1.0.0" + ".war";
        String gatewayMgtSessionId = this.createSession(this.gatewayContextMgt);
        this.webAppAdminClient = new WebAppAdminClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl(), gatewayMgtSessionId);
        this.webAppAdminClient.uploadWarFile(testArtifactPath);
        WebAppDeploymentUtil.isWebApplicationDeployed((String)this.gatewayContextMgt.getContextUrls().getBackEndUrl(), (String)gatewayMgtSessionId, (String)"BPMNProcessServerApp-1.0.0");
        String url = this.getGatewayURLHttp();
        this.publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.userName = this.user.getUserName();
        this.resourceAdminServiceClient = new ResourceAdminServiceClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl(), this.createSession(this.gatewayContextMgt));
        this.originalWFExtentionsXML = this.resourceAdminServiceClient.getTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml");
        this.newWFExtentionsXML = this.readFile(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "workflowapistatechange" + File.separator + "workflow-extentions.xml");
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml", this.newWFExtentionsXML);
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        APIStoreRestClient apiStore = new APIStoreRestClient(this.storeURLHttp);
    }

    @Test(groups={"noRestart"}, description="Test api state change approval process")
    public void testAPIStateChangeAndApproveWorkflow() throws Exception {
        String backendurl = "http://localhost:9443/carbon";
        String description = "This is test API create by API manager integration test";
        this.apiPublisher.login(this.userName, this.userName);
        APIRequest apiRequest = new APIRequest(this.apiName, this.apiVersion, new URL(backendurl));
        apiRequest.setDescription(description);
        apiRequest.setVersion(this.apiVersion);
        apiRequest.setProvider(this.userName);
        this.apiPublisher.addAPI(apiRequest);
        this.apiIdentifier = new APIIdentifier(this.userName, this.apiName, this.apiVersion);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(this.apiName, this.userName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        HttpResponse api = this.apiPublisher.getAPI(this.apiName, this.userName);
        JSONObject apiObj = new JSONObject(api.getData());
        String apiStatus = (String)apiObj.getJSONObject("api").get("status");
        Assert.assertEquals((String)apiStatus, (String)APILifeCycleState.CREATED.toString(), (String)"Lifecycle state should remain without changing till approval. ");
        HttpResponse requestSentFromAM = HTTPSClientUtils.doGet((String)(this.publisherURLHttp + "BPMNProcessServerApp-1.0.0/runtime/process-instances?debugInfo=startRequest"), null);
        JSONObject sentMsgObj = new JSONObject(requestSentFromAM.getData());
        JSONArray variables = sentMsgObj.getJSONArray("variables");
        this.wfreferenceId = (String)sentMsgObj.get("businessKey");
        Assert.assertNotNull((Object)this.wfreferenceId, (String)"businessKey should not be null");
        String scope = null;
        String apiCurrentState = null;
        String apiLCAction = null;
        String apiNameReq = null;
        String apiVersionReq = null;
        String apiProvider = null;
        String invoker = null;
        for (int i = 0; i < variables.length(); ++i) {
            JSONObject variable = (JSONObject)variables.get(i);
            String name = variable.getString("name");
            if ("clientId".equals(name)) {
                this.clientId = variable.getString("value");
                continue;
            }
            if ("clientSecret".equals(name)) {
                this.clientSecrect = variable.getString("value");
                continue;
            }
            if ("scope".equals(name)) {
                scope = variable.getString("value");
                continue;
            }
            if ("apiCurrentState".equals(name)) {
                apiCurrentState = variable.getString("value");
                continue;
            }
            if ("apiLCAction".equals(name)) {
                apiLCAction = variable.getString("value");
                continue;
            }
            if ("apiName".equals(name)) {
                apiNameReq = variable.getString("value");
                continue;
            }
            if ("apiVersion".equals(name)) {
                apiVersionReq = variable.getString("value");
                continue;
            }
            if ("apiProvider".equals(name)) {
                apiProvider = variable.getString("value");
                continue;
            }
            if (!"invoker".equals(name)) continue;
            invoker = variable.getString("value");
        }
        Assert.assertNotNull((Object)this.clientId, (String)"clientId should not be null");
        Assert.assertNotNull((Object)this.clientSecrect, (String)"clientSecrect should not be null");
        Assert.assertNotNull(scope, (String)"scope should not be null");
        HttpResponse resp = this.completeWorkflowTask(this.clientId, this.clientSecrect, scope, apiCurrentState, apiLCAction, apiNameReq, apiVersionReq, apiProvider, invoker, "APPROVED");
        Assert.assertEquals((int)resp.getResponseCode(), (int)200, (String)("Invalid status code:" + resp.getResponseCode()));
        api = this.apiPublisher.getAPI(this.apiName, this.userName);
        apiObj = new JSONObject(api.getData());
        apiStatus = (String)apiObj.getJSONObject("api").get("status");
        Assert.assertEquals((String)apiStatus, (String)APILifeCycleState.PUBLISHED.toString(), (String)("Lifecycle state has not changed after the approval:  " + apiStatus));
    }

    @Test(groups={"noRestart"}, dependsOnMethods={"testAPIStateChangeAndApproveWorkflow"}, description="check API state change reject process")
    public void testAPIStateChangeAndRejectWorkflow() throws Exception {
        this.apiIdentifier = new APIIdentifier(this.userName, this.apiName, this.apiVersion);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(this.apiName, this.userName, APILifeCycleState.BLOCKED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        HttpResponse api = this.apiPublisher.getAPI(this.apiName, this.userName);
        JSONObject apiObj = new JSONObject(api.getData());
        String apiStatus = (String)apiObj.getJSONObject("api").get("status");
        Assert.assertEquals((String)apiStatus, (String)APILifeCycleState.PUBLISHED.toString(), (String)"Lifecycle state should remain without changing till approval. ");
        HttpResponse requestSentFromAM = HTTPSClientUtils.doGet((String)(this.publisherURLHttp + "BPMNProcessServerApp-1.0.0/runtime/process-instances?debugInfo=startRequest"), null);
        JSONObject sentMsgObj = new JSONObject(requestSentFromAM.getData());
        JSONArray variables = sentMsgObj.getJSONArray("variables");
        this.wfreferenceId = (String)sentMsgObj.get("businessKey");
        Assert.assertNotNull((Object)this.wfreferenceId, (String)"businessKey should not be null");
        String scope = null;
        String apiCurrentState = null;
        String apiLCAction = null;
        String apiNameReq = null;
        String apiVersionReq = null;
        String apiProvider = null;
        String invoker = null;
        for (int i = 0; i < variables.length(); ++i) {
            JSONObject variable = (JSONObject)variables.get(i);
            String name = variable.getString("name");
            if ("clientId".equals(name)) {
                this.clientId = variable.getString("value");
                continue;
            }
            if ("clientSecret".equals(name)) {
                this.clientSecrect = variable.getString("value");
                continue;
            }
            if ("scope".equals(name)) {
                scope = variable.getString("value");
                continue;
            }
            if ("apiCurrentState".equals(name)) {
                apiCurrentState = variable.getString("value");
                continue;
            }
            if ("apiLCAction".equals(name)) {
                apiLCAction = variable.getString("value");
                continue;
            }
            if ("apiName".equals(name)) {
                apiNameReq = variable.getString("value");
                continue;
            }
            if ("apiVersion".equals(name)) {
                apiVersionReq = variable.getString("value");
                continue;
            }
            if ("apiProvider".equals(name)) {
                apiProvider = variable.getString("value");
                continue;
            }
            if (!"invoker".equals(name)) continue;
            invoker = variable.getString("value");
        }
        Assert.assertNotNull((Object)this.clientId, (String)"clientId should not be null");
        Assert.assertNotNull((Object)this.clientSecrect, (String)"clientSecrect should not be null");
        Assert.assertNotNull(scope, (String)"scope should not be null");
        HttpResponse resp = this.completeWorkflowTask(this.clientId, this.clientSecrect, scope, apiCurrentState, apiLCAction, apiNameReq, apiVersionReq, apiProvider, invoker, "REJECTED");
        Assert.assertEquals((int)resp.getResponseCode(), (int)200, (String)("Invalid status code:" + resp.getResponseCode()));
        api = this.apiPublisher.getAPI(this.apiName, this.userName);
        apiObj = new JSONObject(api.getData());
        apiStatus = (String)apiObj.getJSONObject("api").get("status");
        Assert.assertEquals((String)apiStatus, (String)APILifeCycleState.PUBLISHED.toString(), (String)("Lifecycle has changed after rejecting the state transition:  " + apiStatus));
    }

    @Test(groups={"noRestart"}, dependsOnMethods={"testAPIStateChangeAndRejectWorkflow"}, description="check rest api for workflow statue change")
    public void testWorkflowCallbackRestAPI() throws Exception {
        JSONObject workflowResBody = new JSONObject();
        String accessToken = this.generateAccessToken("default", this.clientId, this.clientSecrect);
        HashMap<String, String> authenticationRequestHeaders = new HashMap<String, String>();
        authenticationRequestHeaders.put("Authorization", "Bearer " + accessToken);
        authenticationRequestHeaders.put("Content-Type", "application/json");
        String workflowCallbackUrl = this.publisherURLHttp + "api/am/publisher/" + "v0.14" + "/workflows/update-workflow-status?workflowReferenceId=" + this.wfreferenceId;
        HttpResponse response = HTTPSClientUtils.doPost((String)workflowCallbackUrl, authenticationRequestHeaders, (String)workflowResBody.toString());
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Status code mismatch when request is done without valid token");
        accessToken = this.generateAccessToken("apim:api_workflow", this.clientId, this.clientSecrect);
        authenticationRequestHeaders = new HashMap();
        authenticationRequestHeaders.put("Authorization", "Bearer " + accessToken);
        authenticationRequestHeaders.put("Content-Type", "application/json");
        String refId = "xxxxxxxxxxxxxxxxx";
        workflowCallbackUrl = this.publisherURLHttp + "api/am/publisher/" + "v0.14" + "/workflows/update-workflow-status?workflowReferenceId=" + refId;
        workflowResBody.put("description", (Object)"nothing");
        workflowResBody.put("status", (Object)"APPROVED");
        JSONObject attributes = new JSONObject();
        attributes.put("apiCurrentState", (Object)"");
        attributes.put("apiLCAction", (Object)"");
        attributes.put("apiName", (Object)"");
        attributes.put("apiVersion", (Object)"");
        attributes.put("apiProvider", (Object)"");
        attributes.put("invoker", (Object)"");
        workflowResBody.put("attributes", (Object)attributes);
        response = HTTPSClientUtils.doPost((String)workflowCallbackUrl, authenticationRequestHeaders, (String)workflowResBody.toString());
        Assert.assertEquals((int)response.getResponseCode(), (int)404, (String)"Status code mismatch when request is done without workflowReferenceId");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        super.cleanUp();
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml", this.originalWFExtentionsXML);
        ArrayList<String> webAppList = new ArrayList<String>();
        webAppList.add("BPMNProcessServerApp-1.0.0");
        this.webAppAdminClient.deleteWebAppList(webAppList, (String)this.gatewayContextMgt.getDefaultInstance().getHosts().get("default"));
    }

    private HttpResponse completeWorkflowTask(String clientId, String clientSecrect, String scope, String apiCurrentState, String apiLCAction, String apiNameReq, String apiVersionReq, String apiProvider, String invoker, String approval) throws JSONException, APIManagerIntegrationTestException, IOException {
        String requestBody = "grant_type=client_credentials&scope=" + scope;
        URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttps() + "token");
        JSONObject accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(clientId, clientSecrect, requestBody, tokenEndpointURL).getData());
        String accessToken = accessTokenGenerationResponse.getString("access_token");
        String scopeInToken = accessTokenGenerationResponse.getString("scope");
        Assert.assertTrue((boolean)scopeInToken.contains(scope), (String)("Generated token does not have scope " + scope));
        JSONObject workflowResBody = new JSONObject();
        workflowResBody.put("status", (Object)approval);
        workflowResBody.put("description", (Object)"nothing");
        JSONObject attributes = new JSONObject();
        attributes.put("apiCurrentState", (Object)apiCurrentState);
        attributes.put("apiLCAction", (Object)apiLCAction);
        attributes.put("apiName", (Object)apiNameReq);
        attributes.put("apiVersion", (Object)apiVersionReq);
        attributes.put("apiProvider", (Object)apiProvider);
        attributes.put("invoker", (Object)invoker);
        workflowResBody.put("attributes", (Object)attributes);
        String workflowCallbackUrl = this.publisherURLHttp + "api/am/publisher/" + "v0.14" + "/workflows/update-workflow-status?workflowReferenceId=" + this.wfreferenceId;
        HashMap<String, String> authenticationRequestHeaders = new HashMap<String, String>();
        authenticationRequestHeaders.put("Authorization", "Bearer " + accessToken);
        authenticationRequestHeaders.put("Content-Type", "application/json");
        return HTTPSClientUtils.doPost((String)workflowCallbackUrl, authenticationRequestHeaders, (String)workflowResBody.toString());
    }

    private String generateAccessToken(String scope, String clientId, String clientSecrect) throws MalformedURLException, JSONException, APIManagerIntegrationTestException {
        String requestBody = "grant_type=client_credentials&scope=" + scope;
        URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttps() + "token");
        JSONObject accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(clientId, clientSecrect, requestBody, tokenEndpointURL).getData());
        String accessToken = accessTokenGenerationResponse.getString("access_token");
        return accessToken;
    }
}

