/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.LogViewerClient;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.logging.view.stub.types.carbon.LogEvent;

public class CANALYTCOM8PeriodicDataEndpointExceptionTestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private LogViewerClient logViewerClient;
    private ServerConfigurationManager serverConfigurationManager;
    private String modifiedDataBridgeConfigPath = this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "databridgeconfig" + File.separator + "data-bridge-config-modified.xml";
    private String dataBridgeConfigPath = FrameworkPathUtil.getCarbonHome() + File.separator + "repository" + File.separator + "conf" + File.separator + "data-bridge" + File.separator + "data-bridge-config.xml";

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
        this.serverConfigurationManager.applyConfiguration(new File(this.modifiedDataBridgeConfigPath), new File(this.dataBridgeConfigPath), true, true);
        String gatewaySession = this.createSession(new AutomationContext("APIM", "gateway-mgt", this.userMode));
        this.logViewerClient = new LogViewerClient(this.gatewayUrlsWrk.getWebAppURLHttps() + "services/", gatewaySession);
        this.logViewerClient.clearLogs();
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
    }

    @Test(groups={"wso2.am"}, description="Client timeout issue")
    public void testClientTimeoutIssue() throws Exception {
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("PizzaAPI", "pizzashack", "1.0.0", "admin", new URL("http://localhost:9766/pizzashack-api-1.0.0/api/"));
        apiCreationRequestBean.setDescription("Pizza API:Allows to manage pizza orders (create, update, retrieve orders)");
        apiCreationRequestBean.setTags("pizza, order, pizza-menu");
        apiCreationRequestBean.setResourceCount("4");
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "/menu"));
        resourceBeanList.add(new APIResourceBean("POST", "Application & Application User", "Unlimited", "/order"));
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "/order/{orderid}"));
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "/delivery"));
        apiCreationRequestBean.setResourceBeanList(resourceBeanList);
        apiCreationRequestBean.setTier("Unlimited");
        apiCreationRequestBean.setTiersCollection("Unlimited");
        this.apiPublisher.addAPI(apiCreationRequestBean);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("PizzaAPI", this.publisherContext.getContextTenant().getContextUser().getUserName(), APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.apiStore.addApplication("PizzaShack", "Unlimited", "", "");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("PizzaAPI", this.storeContext.getContextTenant().getContextUser().getUserName());
        subscriptionRequest.setApplicationName("PizzaShack");
        subscriptionRequest.setTier("Unlimited");
        this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("PizzaShack");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        Thread.sleep(75000L);
        HttpResponse pizzaShackResponse = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + "pizzashack/1.0.0/menu"), requestHeaders);
        String ERROR_LOG = "Unable to send events to the endpoint.";
        LogEvent[] logEvents = this.logViewerClient.getAllRemoteSystemLogs();
        boolean isErrorLogged = false;
        for (LogEvent logEvent : logEvents) {
            if (!"ERROR".equals(logEvent.getPriority()) || !logEvent.getMessage().contains(ERROR_LOG)) continue;
            isErrorLogged = true;
        }
        Assert.assertFalse((boolean)isErrorLogged, (String)"Session timeout exception is not properly handled");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication("PizzaShack");
        super.cleanUp();
        this.serverConfigurationManager.restoreToLastConfiguration();
    }
}

