/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class GIT2231HeadRequestNPEErrorTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(GIT2231HeadRequestNPEErrorTestCase.class);
    private static final String apiResourceUrl = "git2231headapi/1.0.0/testing";

    @Factory(dataProvider="userModeDataProvider")
    public GIT2231HeadRequestNPEErrorTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        if (this.userMode == TestUserMode.SUPER_TENANT_ADMIN) {
            this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "git2231_head_api.xml", this.gatewayContextMgt, gatewaySessionCookie);
        } else {
            this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "git2231_head_api_tenant.xml", this.gatewayContextMgt, gatewaySessionCookie);
        }
    }

    @Test(groups={"wso2.am"}, description="Check whether the Location header is correct")
    public void testAPIWithLocationHeader() throws Exception {
        String apiInvocationUrl = this.userMode != TestUserMode.SUPER_TENANT_ADMIN ? this.getAPIInvocationURLHttp("t/" + this.user.getUserDomain() + "/" + apiResourceUrl) : this.getAPIInvocationURLHttp(apiResourceUrl);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpHead head = new HttpHead(apiInvocationUrl);
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)head);
        Assert.assertEquals((int)httpResponse.getStatusLine().getStatusCode(), (int)204);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }
}

