/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.net.URL;
import javax.ws.rs.core.Response;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class HttpPATCHSupportTestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;

    @Factory(dataProvider="userModeDataProvider")
    public HttpPATCHSupportTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
        this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "dummy_patch_api.xml", this.gatewayContextMgt, gatewaySessionCookie);
    }

    @Test(groups={"wso2.am"}, description="Check functionality of HTTP PATCH support for APIM")
    public void testHttpPatchSupport() throws Exception {
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        String APIName = "HttpPatchAPI";
        String APIContext = "patchTestContext";
        String url = this.getGatewayURLNhttp() + "httpPatchSupportContext";
        String providerName = this.user.getUserName();
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url));
        apiRequest.setVersion(APIVersion);
        apiRequest.setProvider(providerName);
        apiRequest.setResourceMethod("PATCH");
        this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.waitForAPIDeploymentSync(providerName, APIName, APIVersion, "\"isApiExists\":true");
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.addApplication("HttpPatchSupportAPP", "50PerMin", "", "Test-HTTP-PATCH");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(APIName, APIVersion, providerName, "HttpPatchSupportAPP", "Gold");
        this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("HttpPatchSupportAPP");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject jsonResponse = new JSONObject(responseString);
        String accessToken = jsonResponse.getJSONObject("data").getJSONObject("key").getString("accessToken");
        String apiInvocationUrl = this.getAPIInvocationURLHttp(APIContext, APIVersion);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPatch request = new HttpPatch(apiInvocationUrl);
        request.setHeader("Accept", "application/json");
        request.setHeader("Authorization", "Bearer " + accessToken);
        StringEntity payload = new StringEntity("{\"first\":\"Greg\"}", "UTF-8");
        payload.setContentType("application/json");
        request.setEntity((HttpEntity)payload);
        HttpResponse httpResponsePatch = client.execute((HttpUriRequest)request);
        Assert.assertEquals((int)httpResponsePatch.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"The response code is not 200 OK");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

