/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class TokenEncryptionScopeTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(TokenEncryptionScopeTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private UserManagementClient userManagementClient1 = null;
    private static final String API_NAME = "TokenEncryptionAPI";
    private static final String API_VERSION = "1.0.0";
    private static final String APP_NAME = "TokenEncryptionApp";
    private static final String USER_SAM = "sam";
    private static final String APP_DEV_USER = "mike";
    private static final String APP_DEV_PWD = "mike123";
    private static final String SUBSCRIBER_ROLE = "subscriber";
    private ServerConfigurationManager serverManager;
    private static final String APIM_CONFIG_XML = "api-manager.xml";
    private static final String IDENTITY_CONFIG_XML = "identity.xml";
    private static String apiProvider;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        apiProvider = this.publisherContext.getSuperTenant().getContextUser().getUserName();
        super.init();
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStore = new APIStoreRestClient(storeURLHttp);
    }

    @Test(groups={"wso2.am"}, description="Check if Scopes work fine with token encryption enabled.")
    public void testTokenEncryptionWithScopes() {
        try {
            this.userManagementClient1 = new UserManagementClient(this.publisherContext.getContextUrls().getBackEndUrl(), this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
            this.userManagementClient1.addRole(SUBSCRIBER_ROLE, new String[0], new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"});
            this.userManagementClient1.addUser(USER_SAM, "sam123", new String[]{SUBSCRIBER_ROLE}, USER_SAM);
            this.userManagementClient1.addUser(APP_DEV_USER, APP_DEV_PWD, new String[]{SUBSCRIBER_ROLE}, APP_DEV_USER);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error while creating UserManagementClient " + axisFault.getMessage()));
            Assert.assertTrue((boolean)false, (String)axisFault.getMessage());
        }
        catch (RemoteException e) {
            log.error((Object)("Error while adding role 'subscriber' or user 'mike'" + e.getMessage()));
            Assert.assertTrue((boolean)false, (String)e.getMessage());
        }
        catch (UserAdminUserAdminException e) {
            log.error((Object)("Error while adding role 'subscriber' or user 'mike'" + e.getMessage()));
            Assert.assertTrue((boolean)false, (String)e.getMessage());
        }
        catch (XPathExpressionException e) {
            log.error((Object)("Error when getting backend URLs of the publisher to initialize the UserManagementClient" + e.getMessage()));
            Assert.assertTrue((boolean)false, (String)e.getMessage());
        }
        String apiContext = "tokenencapi";
        String endpointUrl = this.gatewayUrlsWrk.getWebAppURLNhttp() + "response";
        APIRequest apiRequest = null;
        try {
            apiRequest = new APIRequest(API_NAME, apiContext, new URL(endpointUrl));
        }
        catch (MalformedURLException e) {
            log.error((Object)("Invalid URL " + endpointUrl), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)"Integration Test error occurred ", (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        apiRequest.setVersion(API_VERSION);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        try {
            this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
            this.apiPublisher.addAPI(apiRequest);
            APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(API_NAME, apiProvider, APILifeCycleState.PUBLISHED);
            this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
            String modifiedResource = "{\"paths\":{ \"/*\":{\"put\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\" },\"post\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\",\"x-scope\":\"admin_scope\"},\"get\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\",\"x-scope\":\"user_scope\"},\"delete\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\"},\"options\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"None\",\"x-throttling-tier\":\"Unlimited\"}}},\"swagger\":\"2.0\",\"info\":{\"title\":\"TokenEncryptionAPI\",\"version\":\"1.0.0\"},\"x-wso2-security\":{\"apim\":{\"x-wso2-scopes\":[{\"name\":\"admin_scope\",\"description\":\"\",\"key\":\"admin_scope\",\"roles\":\"admin\"},{\"name\":\"user_scope\",\"description\":\"\",\"key\":\"user_scope\",\"roles\":\"admin,subscriber\"}]}}}";
            this.apiPublisher.updateResourceOfAPI(apiProvider, API_NAME, API_VERSION, modifiedResource);
            this.apiStore.login(APP_DEV_USER, APP_DEV_PWD);
            this.apiStore.addApplication(APP_NAME, "Unlimited", "some_url2", "NewApp");
            SubscriptionRequest subscriptionRequest = new SubscriptionRequest(API_NAME, apiProvider);
            subscriptionRequest.setApplicationName(APP_NAME);
            subscriptionRequest.setTier("Unlimited");
            this.apiStore.subscribe(subscriptionRequest);
            APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(APP_NAME);
            String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
            JSONObject jsonResponse = new JSONObject(responseString);
            String consumerKey = jsonResponse.getJSONObject("data").getJSONObject("key").getString("consumerKey");
            String consumerSecret = jsonResponse.getJSONObject("data").getJSONObject("key").getString("consumerSecret");
            URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttps() + "token");
            String requestBody = "grant_type=password&username=sam&password=sam123&scope=user_scope";
            JSONObject accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
            String receivedScope = accessTokenGenerationResponse.getString("scope");
            Assert.assertEquals((String)receivedScope, (String)"user_scope", (String)("Received scope is " + receivedScope + ", but expected user_scope"));
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)"Error occurred while executing Test", (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (MalformedURLException e) {
            log.error((Object)"Malformed tokenEndpointURL ", (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (JSONException e) {
            log.error((Object)"Could not parse response JSON message received from the token endpoint ", (Throwable)e);
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error occurred while getting credentials from the publisher/store context ", (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.apiStore != null) {
            this.apiStore.removeApplication(APP_NAME);
        }
        if (this.apiPublisher != null) {
            this.apiPublisher.deleteAPI(API_NAME, API_VERSION, apiProvider);
        }
        if (this.userManagementClient1 != null) {
            this.userManagementClient1.deleteUser(USER_SAM);
            this.userManagementClient1.deleteUser(APP_DEV_USER);
            this.userManagementClient1.deleteRole(SUBSCRIBER_ROLE);
        }
        super.cleanUp();
        log.info((Object)"Restored configuration and restarted gracefully...");
    }
}

