/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.prototype;

import java.net.URL;
import java.util.List;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIDesignBean;
import org.wso2.am.integration.test.utils.bean.APIImplementationBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM23VisibilityOfPrototypedAPIInStoreTestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM23PrototypedAPI";
    private final String apiVersion = "1.0.0";
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private APIIdentifier apiIdentifierPublisher;
    private String apiProvider;
    private String apiEndPointUrl;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws APIManagerIntegrationTestException, XPathExpressionException {
        super.init();
        String apiPrototypeEndpointPostfixUrl = "pizzashack-api-1.0.0/api/";
        this.apiEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiPrototypeEndpointPostfixUrl;
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiIdentifierPublisher = new APIIdentifier(this.apiProvider, "APIM23PrototypedAPI", "1.0.0");
    }

    @Test(groups={"wso2.am"}, description="Create an API & deployed as a prototype and check the visibility in prototype API In store")
    public void testVisibilityInPrototypedAPI() throws Exception {
        String apiContext = "apim23pizzashack";
        String apiTags = "pizza, order, pizza-menu";
        String apiDescription = "Pizza API:Allows to manage pizza orders (create, update, retrieve orders)";
        String superUser = "carbon.super";
        APIDesignBean apiDesignBean = new APIDesignBean("APIM23PrototypedAPI", apiContext, "1.0.0", apiDescription, apiTags);
        HttpResponse apiDesignResponse = this.apiPublisher.designAPI(apiDesignBean);
        Assert.assertEquals((int)apiDesignResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        Assert.assertTrue((boolean)apiDesignResponse.getData().contains("\"error\" : false"), (String)"APIM23PrototypedAPIis not created as expected");
        APIImplementationBean apiImplementationBean = new APIImplementationBean("APIM23PrototypedAPI", "1.0.0", this.apiProvider, new URL(this.apiEndPointUrl));
        apiImplementationBean.setSwagger(apiDesignBean.getSwagger());
        HttpResponse apiImplementationResponse = this.apiPublisher.implement(apiImplementationBean);
        Assert.assertEquals((int)apiImplementationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        Assert.assertTrue((boolean)apiImplementationResponse.getData().contains("\"error\" : false"), (String)"APIM23PrototypedAPIis not created as expected");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM23PrototypedAPI", this.apiProvider, APILifeCycleState.PROTOTYPED);
        HttpResponse creationResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertTrue((boolean)creationResponse.getData().contains("PROTOTYPED"), (String)"APIM23PrototypedAPI  status not updated as Prototyped");
        List implementedAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisher.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierPublisher, (List)implementedAPIList), (String)"ImplementedAPIM23PrototypedAPI Api is visible in API Publisher.");
        Thread.sleep(15000L);
        HttpResponse apiResponse = this.apiStore.getPrototypedAPI(superUser);
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        Assert.assertTrue((boolean)apiResponse.getData().contains("APIM23PrototypedAPI"), (String)"APIM23PrototypedAPI is not visible as Prototyped API");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.apiPublisher.deleteAPI("APIM23PrototypedAPI", "1.0.0", this.apiProvider);
        super.cleanUp();
    }
}

