/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.util.Map;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIMURLBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM16LoginToTheAPIPublisherThroughThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;

    @DataProvider(name="validLoginDataPro")
    public static Object[][] apiPublisherValidLoginCredentials() throws Exception {
        AutomationContext superTenantAdminContext = new AutomationContext("APIM", "publisher", TestUserMode.SUPER_TENANT_ADMIN);
        AutomationContext superTenantUserContext = new AutomationContext("APIM", "publisher", TestUserMode.SUPER_TENANT_USER);
        AutomationContext tenantAdminContext = new AutomationContext("APIM", "publisher", TestUserMode.TENANT_ADMIN);
        AutomationContext tenantUserContext = new AutomationContext("APIM", "publisher", TestUserMode.TENANT_USER);
        return new Object[][]{{superTenantAdminContext.getContextTenant().getContextUser().getUserName(), superTenantAdminContext.getContextTenant().getContextUser().getPassword()}, {superTenantUserContext.getContextTenant().getContextUser().getUserName(), superTenantUserContext.getContextTenant().getContextUser().getPassword()}, {tenantAdminContext.getContextTenant().getContextUser().getUserName(), tenantAdminContext.getContextTenant().getContextUser().getPassword()}, {tenantUserContext.getContextTenant().getContextUser().getUserName(), tenantUserContext.getContextTenant().getContextUser().getPassword()}};
    }

    @DataProvider(name="invalidLoginDataPro")
    public static Object[][] apiPublisherInValidLoginCredentials() throws Exception {
        AutomationContext superTenantAdminContext = new AutomationContext("APIM", "publisher", TestUserMode.SUPER_TENANT_ADMIN);
        return new Object[][]{{superTenantAdminContext.getContextTenant().getContextUser().getUserName(), "invalid"}, {superTenantAdminContext.getContextTenant().getContextUser().getUserName(), null}, {"invalid", superTenantAdminContext.getContextTenant().getContextUser().getPassword()}, {null, superTenantAdminContext.getContextTenant().getContextUser().getPassword()}, {null, null}, {"1234", "asde"}};
    }

    @Test(dataProvider="validLoginDataPro", description="Login to the API Publisher through publisher Rest API using valid credentials")
    public void testPublisherLoginAndLogoutForValidCredentials(String userName, String password) throws Exception {
        AutomationContext publisherContext = new AutomationContext("APIM", "publisher", TestUserMode.SUPER_TENANT_ADMIN);
        APIMURLBean publisherUrls = new APIMURLBean(publisherContext.getContextUrls());
        this.apiPublisher = new APIPublisherRestClient(publisherUrls.getWebAppURLHttp());
        HttpResponse loginResponse = this.apiPublisher.login(userName, password);
        JSONObject loginJsonObject = new JSONObject(loginResponse.getData());
        Assert.assertFalse((boolean)loginJsonObject.getBoolean("error"), (String)("Invalid login Request for user :" + userName));
        Map loginSession = loginResponse.getHeaders();
        JSONObject apiObject = new JSONObject(this.apiPublisher.getAllAPIs().getData());
        Assert.assertFalse((boolean)apiObject.getBoolean("error"), (String)"Cannot Retrieve all the APIs after successful login");
        HttpResponse logoutResponse = this.apiPublisher.logout();
        JSONObject logoutJsonObject = new JSONObject(logoutResponse.getData());
        Assert.assertFalse((boolean)logoutJsonObject.getBoolean("error"), (String)("Invalid logout request for user : " + userName));
        JSONObject apiLogoutObject = new JSONObject(this.apiPublisher.getAllAPIs().getData());
        Assert.assertTrue((boolean)apiLogoutObject.getBoolean("error"), (String)"Able to Retrieve all the APIs after successful logout");
    }

    @Test(dataProvider="invalidLoginDataPro", description="Login to the API Publisher through publisher Rest API using invalid credentials ")
    public void testInvalidStoreLogin(String userName, String password) throws Exception {
        AutomationContext publisherContext = new AutomationContext("APIM", "publisher", TestUserMode.SUPER_TENANT_ADMIN);
        APIMURLBean publisherUrls = new APIMURLBean(publisherContext.getContextUrls());
        this.apiPublisher = new APIPublisherRestClient(publisherUrls.getWebAppURLHttp());
        HttpResponse loginResponse = this.apiPublisher.login(userName, password);
        JSONObject loginJsonObject = new JSONObject(loginResponse.getData());
        Assert.assertTrue((boolean)loginJsonObject.getBoolean("error"), (String)("Allow to login with invalid credential :" + userName));
    }
}

