/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM18CreateAnAPIThroughThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String apiNameTest = "APIM18PublisherTest";
    private final String apiVersion = "1.0.0";
    private APIPublisherRestClient apiPublisher;
    private String apiProviderName;
    private String apiProductionEndPointUrl;

    @Factory(dataProvider="userModeDataProvider")
    public APIM18CreateAnAPIThroughThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiProductionEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiProviderName = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Create an API Through the Publisher Rest API")
    public void testCreateAnAPIThroughThePublisherRest() throws Exception {
        String apiContextTest = "apim18PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTag = "tag18-1, tag18-2, tag18-3";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM18PublisherTest", apiContextTest, "1.0.0", this.apiProviderName, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(apiTag);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefaultVersion("default_version");
        apiCreationRequestBean.setDefaultVersionChecked("default_version");
        apiCreationRequestBean.setBizOwner("api18b");
        apiCreationRequestBean.setBizOwnerMail("api18b@ee.com");
        apiCreationRequestBean.setTechOwner("api18t");
        apiCreationRequestBean.setTechOwnerMail("api18t@ww.com");
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject apiResponse = new JSONObject(apiCreationResponse.getData());
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when creating the API");
        Assert.assertFalse((boolean)apiResponse.getBoolean("error"), (String)"APIM18PublisherTestis not created as expected");
        HttpResponse response = this.apiPublisher.getApi("APIM18PublisherTest", this.apiProviderName, "1.0.0");
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when creating the API");
        Assert.assertTrue((boolean)response.getData().contains("APIM18PublisherTest"), (String)"Invalid API Name");
        Assert.assertTrue((boolean)response.getData().contains("1.0.0"), (String)"Invalid API Version");
        Assert.assertTrue((boolean)response.getData().contains(apiContextTest), (String)"Invalid API Context");
    }

    @Test(groups={"wso2.am"}, description="Remove an API Through the Publisher Rest API", dependsOnMethods={"testCreateAnAPIThroughThePublisherRest"})
    public void testRemoveAnAPIThroughThePublisherRest() throws Exception {
        HttpResponse removeApiResponse = this.apiPublisher.deleteAPI("APIM18PublisherTest", "1.0.0", this.apiProviderName);
        JSONObject jsonObjectRemoveApi = new JSONObject(removeApiResponse.getData());
        Assert.assertEquals((int)removeApiResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when removing an API");
        Assert.assertFalse((boolean)jsonObjectRemoveApi.getBoolean("error"), (String)"Error when removing the APIM18PublisherTest");
        HttpResponse response = this.apiPublisher.getApi("APIM18PublisherTest", this.apiProviderName, "1.0.0");
        JSONObject jsonObjectGettingApi = new JSONObject(response.getData());
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when getting an API");
        Assert.assertTrue((boolean)jsonObjectGettingApi.getBoolean("error"), (String)"Publisher Rest API allow to get deleted API ");
        Assert.assertEquals((String)jsonObjectGettingApi.getString("message"), (String)" Cannot find the requested API- APIM18PublisherTest-1.0.0", (String)"Invalid error message populated when trying to get deleted API through the publisher");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.apiPublisher.deleteAPI("APIM18PublisherTest", "1.0.0", this.apiProviderName);
        super.cleanUp();
    }
}

