/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIResourceWithTemplateTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME_DEFAULT = "APIResourceWithTemplateDef";
    private final String API_CONTEXT_DEFAULT = "APIResourceWithTemplateDef";
    private final String API_NAME = "APIResourceWithTemplate";
    private final String API_CONTEXT = "APIResourceWithTemplate";
    private final String TEMPLATE_API_NAME = "urlTemplateAPIName";
    private final String TEMPLATE_API_CONTEXT = "urlTemplateContext";
    private final String TEMPLATE_APP_NAME = "urlTemplateApp";
    private static final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private String providerName;
    private APICreationRequestBean apiCreationRequestBean;
    private APIPublisherRestClient apiPublisherClientUser1;
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private APIIdentifier apiIdentifier;

    @Factory(dataProvider="userModeDataProvider")
    public APIResourceWithTemplateTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.apiEndPointUrl = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        String publisherURLHttp = this.getPublisherURLHttps();
        this.apiPublisherClientUser1 = new APIPublisherRestClient(publisherURLHttp);
        this.apiPublisherClientUser1.login(this.user.getUserName(), this.user.getPassword());
        String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "APIResourceWithTemplateTestCaseAPI.xml", this.gatewayContextMgt, gatewaySessionCookie);
        }
    }

    @Test(groups={"wso2.am"}, description="Test API with resouce containing url template for default api")
    public void testAPIwithResourceTemplateForDefaultAPI() throws Exception {
        this.apiCreationRequestBean = new APICreationRequestBean("APIResourceWithTemplateDef", "APIResourceWithTemplateDef", API_VERSION_1_0_0, this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        this.apiCreationRequestBean.setDefaultVersionChecked("default_version");
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        APIResourceBean res = new APIResourceBean("GET", "Application & Application User", "Unlimited", "/resource/{param}");
        resourceBeanList.add(res);
        this.apiCreationRequestBean.setResourceBeanList(resourceBeanList);
        HttpResponse createAPIResponse = this.apiPublisherClientUser1.addAPI(this.apiCreationRequestBean);
        Assert.assertEquals((int)createAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API APIResourceWithTemplateDef creation failed");
        this.apiIdentifier = new APIIdentifier(this.providerName, "APIResourceWithTemplateDef", API_VERSION_1_0_0);
        HttpResponse publishAPIResponse = this.publishAPI(this.apiIdentifier, this.apiPublisherClientUser1, false);
        Assert.assertEquals((int)publishAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API APIResourceWithTemplateDef publish failed");
    }

    @Test(groups={"wso2.am"}, description="Test API with resouce containing url template")
    public void testAPIwithResourceTemplateForAPI() throws Exception {
        this.apiCreationRequestBean = new APICreationRequestBean("APIResourceWithTemplate", "APIResourceWithTemplate", API_VERSION_1_0_0, this.providerName, new URL(this.apiEndPointUrl));
        this.apiCreationRequestBean.setTags("testTag1, testTag2, testTag3");
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        APIResourceBean res = new APIResourceBean("GET", "Application & Application User", "Unlimited", "/resource/{param}");
        resourceBeanList.add(res);
        this.apiCreationRequestBean.setResourceBeanList(resourceBeanList);
        HttpResponse createAPIResponse = this.apiPublisherClientUser1.addAPI(this.apiCreationRequestBean);
        Assert.assertEquals((int)createAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API APIResourceWithTemplateDef creation failed");
        this.apiIdentifier = new APIIdentifier(this.providerName, "APIResourceWithTemplate", API_VERSION_1_0_0);
        HttpResponse publishAPIResponse = this.publishAPI(this.apiIdentifier, this.apiPublisherClientUser1, false);
        Assert.assertEquals((int)publishAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API APIResourceWithTemplateDef publish failed");
    }

    @Test(groups={"wso2.am"}, description="Test API uri template default/encode behavior")
    public void testUriEncodingInTemplate() throws Exception {
        String uriTemplate = "/S2222-0496%2815%2927436-0";
        String context = "customcontextendpoint";
        APIStoreRestClient apiStore = new APIStoreRestClient(this.getStoreURLHttp());
        apiStore.login(this.user.getUserName(), this.user.getPassword());
        String endpointUrl = this.getGatewayURLNhttp() + context + "/sub{uri.var.urlcontext}";
        APIPublisherRestClient apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("urlTemplateAPIName", "urlTemplateContext", API_VERSION_1_0_0, this.user.getUserName(), new URL(endpointUrl));
        apiCreationRequestBean.setTiersCollection("Unlimited");
        ArrayList<APIResourceBean> resList = new ArrayList<APIResourceBean>();
        APIResourceBean res = new APIResourceBean("GET", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION.getAuthType(), "Unlimited", "{urlcontext}");
        resList.add(res);
        apiCreationRequestBean.setResourceBeanList(resList);
        HttpResponse serviceResponse = apiPublisher.addAPI(apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        serviceResponse = apiStore.addApplication("urlTemplateApp", "Unlimited", "", "this-is-test");
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("urlTemplateAPIName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "urlTemplateAPIName", API_VERSION_1_0_0, "\"isApiExists\":true");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("urlTemplateAPIName", this.user.getUserName());
        subscriptionRequest.setApplicationName("urlTemplateApp");
        subscriptionRequest.setTier("Unlimited");
        serviceResponse = apiStore.subscribe(subscriptionRequest);
        this.verifyResponse(serviceResponse);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("urlTemplateApp");
        String responseString = apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        Assert.assertNotNull((Object)("Access Token not found " + responseString), (String)accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("urlTemplateContext", API_VERSION_1_0_0) + uriTemplate;
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        serviceResponse = HTTPSClientUtils.doGet((String)invokeURL, requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        URL endpoint = new URL(endpointUrl);
        JSONObject encodeEndpointUrl = new JSONObject("{\"production_endpoints\":{\"url\":\"legacy-encoding:" + endpoint + "\",\"config\":null},\"endpoint_type\":\"" + endpoint.getProtocol() + "\"}");
        apiCreationRequestBean.setEndpoint(encodeEndpointUrl);
        serviceResponse = apiPublisher.updateAPI(apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        this.waitForAPIDeployment();
        serviceResponse = HTTPSClientUtils.doGet((String)invokeURL, requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        super.cleanUp();
    }
}

