/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.rest;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class MalformedRequestTest
extends APIMIntegrationBaseTest {
    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        String gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "dummy_api.xml", this.gatewayContextMgt, gatewaySessionCookie);
        }
    }

    @Test(groups={"wso2.am"}, description="Check if a malformed request breaks the system")
    public void testMalformedPostWithMessageBuilding() {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpPost httppost = new HttpPost(this.getGatewayURLNhttp() + "response");
        httppost.addHeader(new Header(){

            public String getName() {
                return "Content-Type";
            }

            public String getValue() {
                return "application/xml";
            }

            public HeaderElement[] getElements() throws ParseException {
                return new HeaderElement[0];
            }
        });
        String malformedBody = "<request>Request<request>";
        HttpResponse response = null;
        try {
            ByteArrayEntity entity = new ByteArrayEntity(malformedBody.getBytes("UTF-8"));
            httppost.setEntity((HttpEntity)entity);
            response = httpclient.execute((HttpUriRequest)httppost);
        }
        catch (ClientProtocolException e) {
            Assert.assertTrue((boolean)false, (String)e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            Assert.assertTrue((boolean)false, (String)e.getMessage());
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)false, (String)e.getMessage());
        }
        Assert.assertNotNull(response, (String)"Received null response for malformed post");
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)500, (String)"Did not receive an http 500 for the malformed request");
    }
}

