/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.restapi.utils.RESTAPITestUtil;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class GIT_1628_OAuthAppUpdateViaRestApiTestCase
extends APIMIntegrationBaseTest {
    private String storeRestApiBaseUrl;
    private URL tokenApiUrl;
    private String applicationName = "Application_GIT_1628";
    private String applicationId;
    private String consumerKey;
    private String consumerSecret;
    private Map<String, String> headers;

    @Factory(dataProvider="userModeDataProvider")
    public GIT_1628_OAuthAppUpdateViaRestApiTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.storeRestApiBaseUrl = this.getStoreURLHttps() + "api/am/store/" + "v0.14" + "/";
        this.tokenApiUrl = new URL(this.getKeyManagerURLHttps() + "oauth2/token");
        Map<String, String> dataMap = RESTAPITestUtil.registerOAuthApplication(this.getKeyManagerURLHttps());
        String accessToken = this.generateOAuthAccessToken(this.user.getUserName(), this.user.getPassword(), dataMap.get("consumerKey"), dataMap.get("consumerSecret"));
        this.headers = new HashMap<String, String>();
        this.headers.put("Authorization", "Bearer " + accessToken);
        this.headers.put("Content-Type", "application/json");
        String url = this.storeRestApiBaseUrl + "applications";
        String payload = "{\n    \"throttlingTier\": \"Unlimited\",\n    \"description\": \"Application for GIT_1628\",\n    \"name\": \"" + this.applicationName + "_" + this.user.getUserDomain() + "\",\n" + "    \"callbackUrl\": \"http://GIT_1628.com/initial\"\n" + '}';
        HttpResponse response = HTTPSClientUtils.doPost((String)url, this.headers, (String)payload);
        if (response.getResponseCode() != 201) {
            Assert.fail((String)("Application creation failed: Response code is " + response.getResponseCode() + " Response message is '" + response.getData() + '\''));
        }
        String json = response.getData();
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(json, JsonObject.class);
        this.applicationId = jsonObject.get("applicationId").getAsString();
    }

    @Test(description="Key generation response should contain grant types and callback url")
    public void testKeyGenerationResponseContainsGrantTypesAndCallback() throws Exception {
        String payload;
        String url = this.storeRestApiBaseUrl + "applications/generate-keys?applicationId=" + this.applicationId;
        HttpResponse response = HTTPSClientUtils.doPost((String)url, this.headers, (String)(payload = "{\n  \"validityTime\": \"3600\",\n  \"keyType\": \"PRODUCTION\",\n  \"accessAllowDomains\": [\"ALL\" ],\n  \"callbackUrl\": \"http://GIT_1628.com/prod_callback\",\n  \"supportedGrantTypes\":    [\n      \"refresh_token\",\n      \"client_credentials\"\n  ]\n}"));
        if (response.getResponseCode() != 200) {
            Assert.fail((String)("Key generation failed: Response code is " + response.getResponseCode() + " Response message is '" + response.getData() + '\''));
        }
        String json = response.getData();
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(json, JsonObject.class);
        this.consumerKey = jsonObject.getAsJsonPrimitive("consumerKey").getAsString();
        Assert.assertNotNull((Object)this.consumerKey, (String)("ConsumerKey is not available in the response:" + response.getData()));
        this.consumerSecret = jsonObject.getAsJsonPrimitive("consumerSecret").getAsString();
        Assert.assertNotNull((Object)this.consumerSecret, (String)("ConsumerSecret is not available in the response:" + response.getData()));
        String callbackUrl = jsonObject.getAsJsonPrimitive("callbackUrl").getAsString();
        Assert.assertEquals((String)callbackUrl, (String)"http://GIT_1628.com/prod_callback");
        JsonArray grantTypes = jsonObject.getAsJsonArray("supportedGrantTypes");
        Assert.assertNotNull((Object)grantTypes, (String)("Grant Types are not available in the response:" + response.getData()));
        Assert.assertTrue((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("refresh_token")), (String)("refresh_token is not available in grant type list. Response: " + response.getData()));
        Assert.assertTrue((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("client_credentials")), (String)("client_credentials is not available in grant type list. Response: " + response.getData()));
        Assert.assertFalse((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("password")), (String)("password is available in grant type list. Response: " + response.getData()));
        Assert.assertFalse((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("iwa:ntlm")), (String)("iwa:ntlm is available in grant type list. Response: " + response.getData()));
        Assert.assertFalse((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("urn:ietf:params:oauth:grant-type:saml2-bearer")), (String)("urn:ietf:params:oauth:grant-type:saml2-bearer is available in grant type list. Response: " + response.getData()));
    }

    @Test(description="Generate token with password grant type when password grant type is not enabled", dependsOnMethods={"testKeyGenerationResponseContainsGrantTypesAndCallback"})
    public void testTokenGenerationWithPasswordGrant() throws Exception {
        HashMap<String, String> tokenApiHeaders = new HashMap<String, String>();
        String authenticationHeader = this.consumerKey + ":" + this.consumerSecret;
        byte[] encodedBytes = Base64.encodeBase64((byte[])authenticationHeader.getBytes("UTF-8"));
        tokenApiHeaders.put("Authorization", "Basic " + new String(encodedBytes, "UTF-8"));
        String payload = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword();
        HttpResponse response = HTTPSClientUtils.doPost((URL)this.tokenApiUrl, (String)payload, tokenApiHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)400, (String)("Password grant type is not disabled properly: Response code is " + response.getResponseCode() + " Response message is '" + response.getData() + '\''));
        Assert.assertTrue((boolean)response.getData().contains("The authenticated client is not authorized to use this authorization grant type"), (String)"Wrong error message found.");
    }

    @Test(description="Generate token with client credentials grant type when client credentials grant type is enabled", dependsOnMethods={"testKeyGenerationResponseContainsGrantTypesAndCallback"})
    public void testTokenGenerationWithClientCredentialsGrant() throws Exception {
        HashMap<String, String> tokenApiHeaders = new HashMap<String, String>();
        String authenticationHeader = this.consumerKey + ":" + this.consumerSecret;
        byte[] encodedBytes = Base64.encodeBase64((byte[])authenticationHeader.getBytes("UTF-8"));
        tokenApiHeaders.put("Authorization", "Basic " + new String(encodedBytes, "UTF-8"));
        String payload = "grant_type=client_credentials";
        HttpResponse response = HTTPSClientUtils.doPost((URL)this.tokenApiUrl, (String)payload, tokenApiHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)("Client Credentials token call is not successful: Response code is " + response.getResponseCode() + " Response message is '" + response.getData() + '\''));
    }

    @Test(description="Updating grant types and callback url", dependsOnMethods={"testKeyGenerationResponseContainsGrantTypesAndCallback"})
    public void testUpdateGrantTypesAndCallback() throws Exception {
        String payload;
        String url = this.storeRestApiBaseUrl + "applications/" + this.applicationId + "/keys/PRODUCTION";
        HttpResponse response = HTTPSClientUtils.doPut((String)url, this.headers, (String)(payload = "{\n  \"callbackUrl\": \"http://GIT_1628.com/prod_updated\",\n  \"supportedGrantTypes\":    [\n      \"password\",\n      \"iwa:ntlm\"\n  ]\n}"));
        if (response.getResponseCode() != 200) {
            Assert.fail((String)("Grant type/callback update failed: Response code is " + response.getResponseCode() + " Response message is '" + response.getData() + '\''));
        }
        String json = response.getData();
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(json, JsonObject.class);
        String callbackUrl = jsonObject.getAsJsonPrimitive("callbackUrl").getAsString();
        Assert.assertEquals((String)callbackUrl, (String)"http://GIT_1628.com/prod_updated");
        JsonArray grantTypes = jsonObject.getAsJsonArray("supportedGrantTypes");
        Assert.assertNotNull((Object)grantTypes, (String)("Grant Types are not available in the response. Response: " + response.getData()));
        Assert.assertTrue((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("password")), (String)("password is not available in grant type list. Response: " + response.getData()));
        Assert.assertTrue((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("iwa:ntlm")), (String)("iwa:ntlm is not available in grant type list. Response: " + response.getData()));
        Assert.assertFalse((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("client_credentials")), (String)("client_credentials is available in grant type list. Response: " + response.getData()));
        Assert.assertFalse((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("refresh_token")), (String)("refresh_token is available in grant type list. Response: " + response.getData()));
        Assert.assertFalse((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("urn:ietf:params:oauth:grant-type:saml2-bearer")), (String)("urn:ietf:params:oauth:grant-type:saml2-bearer is available in grant type list. Response: " + response.getData()));
        HashMap<String, String> tokenApiHeaders = new HashMap<String, String>();
        String authenticationHeader = this.consumerKey + ":" + this.consumerSecret;
        byte[] encodedBytes = Base64.encodeBase64((byte[])authenticationHeader.getBytes("UTF-8"));
        tokenApiHeaders.put("Authorization", "Basic " + new String(encodedBytes, "UTF-8"));
        payload = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword();
        response = HTTPSClientUtils.doPost((URL)this.tokenApiUrl, (String)payload, tokenApiHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)("Password grant token call is not successful: Response code is " + response.getResponseCode() + " Response message is '" + response.getData() + '\''));
        payload = "grant_type=client_credentials";
        response = HTTPSClientUtils.doPost((URL)this.tokenApiUrl, (String)payload, tokenApiHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)400, (String)("Client Credentials grant type is not disabled properly: Response code is " + response.getResponseCode() + " Response message is '" + response.getData() + '\''));
        Assert.assertTrue((boolean)response.getData().contains("The authenticated client is not authorized to use this authorization grant type"), (String)"Wrong error message found.");
    }

    @Test(description="Retrieving grant types and callback url", dependsOnMethods={"testUpdateGrantTypesAndCallback"})
    public void testGetGrantTypesAndCallback() throws Exception {
        String url = this.storeRestApiBaseUrl + "applications/" + this.applicationId + "/keys/PRODUCTION";
        HttpResponse response = HTTPSClientUtils.doGet((String)url, this.headers);
        if (response.getResponseCode() != 200) {
            Assert.fail((String)("Grant type/callback retrieval failed: Response code is " + response.getResponseCode() + " Response message is '" + response.getData() + '\''));
        }
        String json = response.getData();
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(json, JsonObject.class);
        String callbackUrl = jsonObject.getAsJsonPrimitive("callbackUrl").getAsString();
        Assert.assertEquals((String)callbackUrl, (String)"http://GIT_1628.com/prod_updated");
        JsonArray grantTypes = jsonObject.getAsJsonArray("supportedGrantTypes");
        Assert.assertNotNull((Object)grantTypes, (String)("Grant Types are not available in the response. Response: " + response.getData()));
        Assert.assertTrue((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("password")), (String)("password is not available in grant type list. Response: " + response.getData()));
        Assert.assertTrue((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("iwa:ntlm")), (String)("iwa:ntlm is not available in grant type list. Response: " + response.getData()));
        Assert.assertFalse((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("refresh_token")), (String)("refresh_token is available in grant type list. Response: " + response.getData()));
        Assert.assertFalse((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("client_credentials")), (String)"client_credentials is available in grant type list");
        Assert.assertFalse((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("urn:ietf:params:oauth:grant-type:saml2-bearer")), (String)("urn:ietf:params:oauth:grant-type:saml2-bearer is available in grant type list. Response: " + response.getData()));
    }

    @Test(description="Retrieving application and check keys", dependsOnMethods={"testGetGrantTypesAndCallback"})
    public void testGetApplicationAndCheckKeys() throws Exception {
        String url = this.storeRestApiBaseUrl + "applications/" + this.applicationId;
        HttpResponse response = HTTPSClientUtils.doGet((String)url, this.headers);
        if (response.getResponseCode() != 200) {
            Assert.fail((String)("Grant type/callback retrieval failed: Response code is " + response.getResponseCode() + " Response message is '" + response.getData() + '\''));
        }
        String json = response.getData();
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(json, JsonObject.class);
        JsonArray keys = jsonObject.getAsJsonArray("keys");
        Assert.assertNotNull((Object)keys, (String)("Keys are not available in the response. Response: " + response.getData()));
        JsonObject key = (JsonObject)keys.get(0);
        String callbackUrl = key.getAsJsonPrimitive("callbackUrl").getAsString();
        Assert.assertEquals((String)callbackUrl, (String)"http://GIT_1628.com/prod_updated");
        JsonArray grantTypes = key.getAsJsonArray("supportedGrantTypes");
        Assert.assertNotNull((Object)grantTypes, (String)("Grant Types are not available in the response. Response: " + response.getData()));
        Assert.assertTrue((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("password")), (String)("password is not available in grant type list. Response: " + response.getData()));
        Assert.assertTrue((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("iwa:ntlm")), (String)("iwa:ntlm is not available in grant type list. Response: " + response.getData()));
        Assert.assertFalse((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("refresh_token")), (String)("refresh_token is available in grant type list. Response: " + response.getData()));
        Assert.assertFalse((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("client_credentials")), (String)"client_credentials is available in grant type list");
        Assert.assertFalse((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("urn:ietf:params:oauth:grant-type:saml2-bearer")), (String)("urn:ietf:params:oauth:grant-type:saml2-bearer is available in grant type list. Response: " + response.getData()));
    }

    @Test(description="Key generation response should contain all grant types even when request does not have grant types. (for backward compatibility)", dependsOnMethods={"testGetApplicationAndCheckKeys"})
    public void testKeyGenerationWithoutGrantTypesNorCallback() throws Exception {
        String payload;
        String url = this.storeRestApiBaseUrl + "applications/generate-keys?applicationId=" + this.applicationId;
        HttpResponse response = HTTPSClientUtils.doPost((String)url, this.headers, (String)(payload = "{\n  \"validityTime\": \"3600\",\n  \"keyType\": \"SANDBOX\",\n  \"accessAllowDomains\": [\"ALL\" ]\n}"));
        if (response.getResponseCode() != 200) {
            Assert.fail((String)("Key generation failed: Response code is " + response.getResponseCode() + " Response message is '" + response.getData() + '\''));
        }
        String json = response.getData();
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(json, JsonObject.class);
        JsonArray grantTypes = jsonObject.getAsJsonArray("supportedGrantTypes");
        Assert.assertNotNull((Object)grantTypes, (String)("Grant Types are not available in the response:" + response.getData()));
        Assert.assertTrue((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("refresh_token")), (String)("refresh_token is not available in grant type list. Response: " + response.getData()));
        Assert.assertTrue((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("client_credentials")), (String)("client_credentials is not available in grant type list. Response: " + response.getData()));
        Assert.assertTrue((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("password")), (String)("password is not available in grant type list. Response: " + response.getData()));
        Assert.assertTrue((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("iwa:ntlm")), (String)("iwa:ntlm is not available in grant type list. Response: " + response.getData()));
        Assert.assertTrue((boolean)grantTypes.contains((JsonElement)new JsonPrimitive("urn:ietf:params:oauth:grant-type:saml2-bearer")), (String)("urn:ietf:params:oauth:grant-type:saml2-bearer is not available in grant type list. Response: " + response.getData()));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.removeApplication(this.applicationName);
        super.cleanUp();
    }

    private String generateOAuthAccessToken(String username, String password, String consumerKey, String consumerSecret) throws APIManagerIntegrationTestException {
        try {
            String messageBody = "grant_type=password&username=" + username + "&password=" + password + "&scope=apim:subscribe";
            HashMap<String, String> accessKeyMap = new HashMap<String, String>();
            String authenticationHeader = consumerKey + ":" + consumerSecret;
            byte[] encodedBytes = Base64.encodeBase64((byte[])authenticationHeader.getBytes("UTF-8"));
            accessKeyMap.put("Authorization", "Basic " + new String(encodedBytes, "UTF-8"));
            HttpResponse tokenGenerateResponse = HttpRequestUtil.doPost((URL)this.tokenApiUrl, (String)messageBody, accessKeyMap);
            JSONObject tokenGenJsonObject = new JSONObject((Object)tokenGenerateResponse);
            String accessToken = new JSONObject(tokenGenJsonObject.get("data").toString()).get("access_token").toString();
            if (accessToken != null) {
                return accessToken;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new APIManagerIntegrationTestException("Message header encoding was unsuccessful using UTF-8.", (Throwable)unsupportedEncodingException);
        }
        catch (AutomationFrameworkException automationFrameworkException) {
            throw new APIManagerIntegrationTestException("Error in sending the request to token endpoint.", (Throwable)automationFrameworkException);
        }
        catch (JSONException e) {
            throw new APIManagerIntegrationTestException("Error in parsing JSON content in response from token endpoint.", (Throwable)e);
        }
        return null;
    }
}

