/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.restapi.utils.RESTAPITestUtil;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class GIT_1638_UrlEncodedApiNameTestCase
extends APIMIntegrationBaseTest {
    private String storeRestApiBaseUrl;
    private String publisherRestApiBaseUrl;
    private URL tokenApiUrl;
    private String applicationName = "Application_GIT_1638";
    private String applicationId;
    private String apiName = "git-1638";
    private String context = "git1638";
    private String encodedApiName = "git%2D1638";
    private Map<String, String> headers;

    @Factory(dataProvider="userModeDataProvider")
    public GIT_1638_UrlEncodedApiNameTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.storeRestApiBaseUrl = this.getStoreURLHttps() + "api/am/store/" + "v0.14" + "/";
        this.publisherRestApiBaseUrl = this.getStoreURLHttps() + "api/am/publisher/" + "v0.14" + "/";
        this.tokenApiUrl = new URL(this.getKeyManagerURLHttps() + "oauth2/token");
        Map<String, String> dataMap = RESTAPITestUtil.registerOAuthApplication(this.getKeyManagerURLHttps());
        String accessToken = this.generateOAuthAccessToken(this.user.getUserName(), this.user.getPassword(), dataMap.get("consumerKey"), dataMap.get("consumerSecret"));
        this.headers = new HashMap<String, String>();
        this.headers.put("Authorization", "Bearer " + accessToken);
        this.headers.put("Content-Type", "application/json");
        String url = this.storeRestApiBaseUrl + "applications";
        String payload = "{\n    \"throttlingTier\": \"Unlimited\",\n    \"description\": \"Application for GIT_1638\",\n    \"name\": \"" + this.applicationName + "_" + this.user.getUserDomain() + "\",\n" + "    \"callbackUrl\": \"http://GIT_1638.com/initial\"\n" + '}';
        HttpResponse response = HTTPSClientUtils.doPost((String)url, this.headers, (String)payload);
        if (response.getResponseCode() != 201) {
            Assert.fail((String)("Application creation failed: Response code is " + response.getResponseCode() + " Response message is '" + response.getData() + '\''));
        }
        String json = response.getData();
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(json, JsonObject.class);
        this.applicationId = jsonObject.get("applicationId").getAsString();
        String apiCreationUrl = this.publisherRestApiBaseUrl + "apis";
        String apiCreateJsonLocation = this.getAMResourceLocation() + File.separator + "git1638" + File.separator + File.separator + "APICreate.json";
        String apiCreationJson = IOUtils.toString((InputStream)new FileInputStream(apiCreateJsonLocation));
        apiCreationJson = apiCreationJson.replace("${name}", this.apiName);
        if (!"carbon.super".equals(this.user.getUserDomain())) {
            this.context = "/t/" + this.user.getUserDomain() + "." + "/" + this.context;
        }
        apiCreationJson = apiCreationJson.replace("${context}", this.context);
        apiCreationJson = apiCreationJson.replace("${provider}", this.user.getUserName());
        HttpResponse apiCreationResponse = HTTPSClientUtils.doPost((String)apiCreationUrl, this.headers, (String)apiCreationJson);
        if (response.getResponseCode() != 201) {
            Assert.fail((String)("API creation failed: Response code is " + apiCreationResponse.getResponseCode() + " Response message is '" + response.getData() + '\''));
        }
    }

    @Test(description="api detail with API name having hyphen")
    public void testGetApiDetailFromPublisher() throws Exception {
        HttpResponse response;
        String url = this.publisherRestApiBaseUrl + "apis/" + this.user.getUserNameWithoutDomain();
        if (!"carbon.super".equals(this.user.getUserDomain())) {
            url = url + "-AT-" + this.user.getUserDomain();
        }
        if ((response = HTTPSClientUtils.doGet((String)(url = url + "-" + this.encodedApiName + "-1.0.0"), this.headers)).getResponseCode() != 200) {
            Assert.fail((String)("Api Detail get failed: Response code is " + response.getResponseCode() + " Response message is '" + response.getData() + '\''));
        }
        String json = response.getData();
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(json, JsonObject.class);
        String retrievedApiName = jsonObject.getAsJsonPrimitive("name").getAsString();
        Assert.assertEquals((String)this.apiName, (String)retrievedApiName);
        String publisherApisList = HTTPSClientUtils.doGet((String)(this.publisherRestApiBaseUrl + "apis/"), this.headers).getData();
        Assert.assertTrue((boolean)publisherApisList.contains("pagination"), (String)"Pagination data not present in response");
        String storeApisList = HTTPSClientUtils.doGet((String)(this.storeRestApiBaseUrl + "apis/"), null).getData();
        Assert.assertTrue((boolean)storeApisList.contains("pagination"), (String)"Pagination data not present in response");
    }

    @Test(description="api detail with API name having hyphen")
    public void testChangeLifeCycleToPublish() throws Exception {
        String payload;
        String subscriptionUrl;
        HttpResponse subscriptionResponse;
        String apiIdentifier = this.user.getUserNameWithoutDomain();
        if (!"carbon.super".equals(this.user.getUserDomain())) {
            apiIdentifier = apiIdentifier + "-AT-" + this.user.getUserDomain();
        }
        apiIdentifier = apiIdentifier + "-" + this.encodedApiName + "-1.0.0";
        String lifecycleChangeUrl = this.publisherRestApiBaseUrl + "apis/change-lifecycle?apiId=" + apiIdentifier + "&" + "action=Publish";
        HttpResponse response = HTTPSClientUtils.doPost((String)lifecycleChangeUrl, this.headers, (String)"");
        if (response.getResponseCode() != 200) {
            Assert.fail((String)("APi lifecycle change failed: Response code is " + response.getResponseCode() + " Response message is '" + response.getData() + '\''));
        }
        if ((subscriptionResponse = HTTPSClientUtils.doPost((String)(subscriptionUrl = this.storeRestApiBaseUrl + "subscriptions"), this.headers, (String)(payload = "{\n    \"tier\": \"Unlimited\",\n    \"apiIdentifier\": \"" + apiIdentifier + "\",\n" + "    \"applicationId\": \"" + this.applicationId + "\"\n" + "}"))).getResponseCode() != 201) {
            Assert.fail((String)("Subscription: Response code is " + subscriptionResponse.getResponseCode() + " Response message is '" + subscriptionResponse.getData() + '\''));
        }
        String json = subscriptionResponse.getData();
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(json, JsonObject.class);
        String retrievedApiName = jsonObject.getAsJsonPrimitive("apiIdentifier").getAsString();
        String apiIdentifierForAssert = this.user.getUserName();
        apiIdentifierForAssert = apiIdentifierForAssert + "-" + this.encodedApiName + "-1.0.0";
        Assert.assertEquals((String)apiIdentifierForAssert, (String)retrievedApiName, (String)"ApiIdentifier got changed");
        String getSubscriptionUrl = this.publisherRestApiBaseUrl + "subscriptions?apiId=" + apiIdentifier;
        HttpResponse getSubscriptionResponse = HTTPSClientUtils.doGet((String)getSubscriptionUrl, this.headers);
        if (getSubscriptionResponse.getResponseCode() != 200) {
            Assert.fail((String)("Subscription: Response code is " + getSubscriptionResponse.getResponseCode() + " Response message is '" + getSubscriptionResponse.getData() + '\''));
        }
        String subscriptionResponseData = getSubscriptionResponse.getData();
        JsonObject subscriptionResponseDataJson = (JsonObject)gson.fromJson(subscriptionResponseData, JsonObject.class);
        JsonArray subscriptionList = subscriptionResponseDataJson.getAsJsonArray("list");
        JsonObject subscription = subscriptionList.get(0).getAsJsonObject();
        String retrievedApiIdentifier = subscription.getAsJsonPrimitive("apiIdentifier").getAsString();
        Assert.assertEquals((String)apiIdentifierForAssert, (String)retrievedApiIdentifier, (String)"ApiIdentifier got changed");
        String getSubscriptionFromStoreUrl = this.storeRestApiBaseUrl + "subscriptions?apiId=" + apiIdentifier;
        HttpResponse getSubscriptionFromStoreResponse = HTTPSClientUtils.doGet((String)getSubscriptionFromStoreUrl, this.headers);
        if (getSubscriptionFromStoreResponse.getResponseCode() != 200) {
            Assert.fail((String)("Subscription: Response code is " + getSubscriptionFromStoreResponse.getResponseCode() + " Response message is '" + getSubscriptionFromStoreResponse.getData() + '\''));
        }
        String subscriptionResponseFromStoreData = getSubscriptionFromStoreResponse.getData();
        JsonObject subscriptionResponseFromStoreDataJson = (JsonObject)gson.fromJson(subscriptionResponseFromStoreData, JsonObject.class);
        JsonArray subscriptionListFromStore = subscriptionResponseFromStoreDataJson.getAsJsonArray("list");
        JsonObject subscriptionFromStore = subscriptionListFromStore.get(0).getAsJsonObject();
        String retrievedApiIdentifierFromStore = subscriptionFromStore.getAsJsonPrimitive("apiIdentifier").getAsString();
        Assert.assertEquals((String)apiIdentifierForAssert, (String)retrievedApiIdentifierFromStore, (String)"ApiIdentifier got changed");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.removeApplication(this.applicationName);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiPublisher.deleteAPI(this.apiName, "1.0.0", this.user.getUserName());
        super.cleanUp();
    }

    private String generateOAuthAccessToken(String username, String password, String consumerKey, String consumerSecret) throws APIManagerIntegrationTestException {
        try {
            String messageBody = "grant_type=password&username=" + username + "&password=" + password + "&scope=apim:api_publish apim:api_create apim:api_view apim:subscribe apim:tier_view " + "apim:tier_manage apim:subscription_view apim:subscription_block";
            HashMap<String, String> accessKeyMap = new HashMap<String, String>();
            String authenticationHeader = consumerKey + ":" + consumerSecret;
            byte[] encodedBytes = Base64.encodeBase64((byte[])authenticationHeader.getBytes("UTF-8"));
            accessKeyMap.put("Authorization", "Basic " + new String(encodedBytes, "UTF-8"));
            HttpResponse tokenGenerateResponse = HttpRequestUtil.doPost((URL)this.tokenApiUrl, (String)messageBody, accessKeyMap);
            JSONObject tokenGenJsonObject = new JSONObject((Object)tokenGenerateResponse);
            String accessToken = new JSONObject(tokenGenJsonObject.get("data").toString()).get("access_token").toString();
            if (accessToken != null) {
                return accessToken;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new APIManagerIntegrationTestException("Message header encoding was unsuccessful using UTF-8.", (Throwable)unsupportedEncodingException);
        }
        catch (AutomationFrameworkException automationFrameworkException) {
            throw new APIManagerIntegrationTestException("Error in sending the request to token endpoint.", (Throwable)automationFrameworkException);
        }
        catch (JSONException e) {
            throw new APIManagerIntegrationTestException("Error in parsing JSON content in response from token endpoint.", (Throwable)e);
        }
        return null;
    }
}

