/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi.utils;

import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;

public class DataDrivenTestUtils {
    private void setKeysForRestClient() {
        System.setProperty("javax.net.ssl.trustStore", "/repository/resources/security/wso2carbon.jks");
        System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
        System.setProperty("javax.net.ssl.trustStoreType", "JKS");
    }

    public Response sendRequestToRESTAPI(String method, String resourceUrl, Map<String, String> queryParameters, Map<String, String> requestHeaders, String requestPayload, String cookie) {
        Response response = null;
        if ("GET".equalsIgnoreCase(method)) {
            response = this.geneticRestRequestGet(resourceUrl, "application/json", queryParameters, requestHeaders, cookie);
        } else if ("POST".equalsIgnoreCase(method)) {
            response = this.geneticRestRequestPost(resourceUrl, "application/json", "application/json", requestPayload, queryParameters, requestHeaders, cookie);
        } else if ("PUT".equalsIgnoreCase(method)) {
            response = this.geneticRestRequestPut(resourceUrl, "application/json", "application/json", requestPayload, queryParameters, requestHeaders, cookie);
        } else if ("DELETE".equalsIgnoreCase(method)) {
            response = this.geneticRestRequestDelete(resourceUrl, "application/json", queryParameters, requestHeaders, cookie);
        }
        return response;
    }

    public Response geneticRestRequestPost(String resourceUrl, String contentType, String acceptMediaType, Object postBody, Map<String, String> queryParamMap, Map<String, String> headerMap, String cookie) {
        Client client = (Client)ClientBuilder.newClient().register(JacksonJsonProvider.class);
        WebTarget target = client.target(resourceUrl);
        Invocation.Builder builder = this.getBuilder(acceptMediaType, queryParamMap, headerMap, cookie, target);
        Response response = null;
        Form form = new Form();
        if (contentType == "application/x-www-form-urlencoded") {
            for (String formField : postBody.toString().split("&")) {
                form.param(formField.split("=")[0], formField.split("=")[1]);
            }
            response = builder.post(Entity.entity((Object)form, (String)"application/x-www-form-urlencoded"));
        } else if (contentType == "multipart/form-data") {
            for (String formField : postBody.toString().split("&")) {
                form.param(formField.split("=")[0], formField.split("=")[1]);
            }
            response = builder.post(Entity.entity((Object)form, (String)"multipart/form-data"));
        } else if (contentType == "application/json") {
            response = builder.post(Entity.json((Object)postBody));
        } else if (contentType == "application/xml") {
            response = builder.post(Entity.entity((Object)Entity.xml((Object)postBody), (String)"application/xml"));
        }
        client.close();
        return response;
    }

    public Response geneticRestRequestGet(String resourceUrl, String acceptMediaType, Map<String, String> queryParamMap, Map<String, String> headerMap, String cookie) {
        Client client = (Client)ClientBuilder.newClient().register(JacksonJsonProvider.class);
        WebTarget target = client.target(resourceUrl);
        Invocation.Builder builder = this.getBuilder(acceptMediaType, queryParamMap, headerMap, cookie, target);
        Response response = null;
        response = builder.get();
        client.close();
        return response;
    }

    public Response geneticRestRequestPut(String resourceUrl, String contentType, String acceptMediaType, Object postBody, Map<String, String> queryParamMap, Map<String, String> headerMap, String cookie) {
        Client client = (Client)ClientBuilder.newClient().register(JacksonJsonProvider.class);
        WebTarget target = client.target(resourceUrl);
        Invocation.Builder builder = this.getBuilder(acceptMediaType, queryParamMap, headerMap, cookie, target);
        Response response = null;
        Form form = new Form();
        if (contentType == "application/x-www-form-urlencoded") {
            for (String formField : postBody.toString().split("&")) {
                form.param(formField.split("=")[0], formField.split("=")[1]);
            }
            response = builder.put(Entity.entity((Object)form, (String)"application/x-www-form-urlencoded"));
        } else if (contentType == "multipart/form-data") {
            for (String formField : postBody.toString().split("&")) {
                form.param(formField.split("=")[0], formField.split("=")[1]);
            }
            response = builder.put(Entity.entity((Object)form, (String)"multipart/form-data"));
        } else if (contentType == "application/json") {
            response = builder.put(Entity.json((Object)postBody));
        } else if (contentType == "application/xml") {
            response = builder.put(Entity.entity((Object)Entity.xml((Object)postBody), (String)"application/xml"));
        }
        client.close();
        return response;
    }

    public Response geneticRestRequestDelete(String resourceUrl, String acceptMediaType, Map<String, String> queryParamMap, Map<String, String> headerMap, String cookie) {
        Client client = (Client)ClientBuilder.newClient().register(JacksonJsonProvider.class);
        WebTarget target = client.target(resourceUrl);
        Invocation.Builder builder = this.getBuilder(acceptMediaType, queryParamMap, headerMap, cookie, target);
        Response response = null;
        response = builder.delete();
        client.close();
        return response;
    }

    public Response geneticRestRequestHead(String resourceUrl, String acceptMediaType, Map<String, String> queryParamMap, Map<String, String> headerMap, String cookie) {
        Client client = (Client)ClientBuilder.newClient().register(JacksonJsonProvider.class);
        WebTarget target = client.target(resourceUrl);
        Invocation.Builder builder = this.getBuilder(acceptMediaType, queryParamMap, headerMap, cookie, target);
        Response response = null;
        response = builder.head();
        client.close();
        return response;
    }

    private Invocation.Builder getBuilder(String acceptMediaType, Map<String, String> queryParamMap, Map<String, String> headerMap, String cookie, WebTarget target) {
        if (queryParamMap.size() > 0) {
            for (Map.Entry<String, String> queryParamEntry : queryParamMap.entrySet()) {
                target = target.queryParam(queryParamEntry.getKey(), new Object[]{queryParamEntry.getValue()});
            }
        }
        Invocation.Builder builder = target.request(new String[]{acceptMediaType});
        if (headerMap.size() > 0) {
            for (Map.Entry<String, String> headerEntry : headerMap.entrySet()) {
                builder.header(headerEntry.getKey(), (Object)headerEntry.getValue());
            }
        }
        if (cookie != null) {
            builder.cookie(new Cookie(cookie.split("=")[0], cookie.split("=")[1]));
        }
        return builder;
    }
}

