/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi.utils;

import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.tests.restapi.utils.DataDrivenTestUtils;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class RESTAPITestUtil {
    private static final Log log = LogFactory.getLog(RESTAPITestUtil.class);
    private DataDrivenTestUtils dataDrivenTestUtils = new DataDrivenTestUtils();
    private HashMap<String, String> preservedAttributes = new HashMap();

    public boolean testRestAPI(String configFilePath, String gatewayURL, String keyMangerURL) {
        boolean isTestSuccess = true;
        try {
            String configData = this.getConfigurations(configFilePath);
            Map<String, String> dataMap = RESTAPITestUtil.registerOAuthApplication(keyMangerURL);
            JSONObject testScenario = new JSONObject(configData);
            JSONArray array = testScenario.getJSONArray("testCase");
            int arrayLength = array.length();
            for (int i = 0; i < arrayLength; ++i) {
                JSONArray bodyNotAsserts;
                int expectedStatusCode;
                int actualStatusCode;
                JSONArray preserveListArray;
                JSONObject configObject = (JSONObject)array.get(i);
                JSONObject initializationConfigurationObject = configObject.getJSONObject("init");
                String scope = initializationConfigurationObject.get("scope").toString();
                if (dataMap == null || dataMap.isEmpty()) {
                    log.error((Object)"Failed to register OAuth application to test the REST API.");
                    isTestSuccess = false;
                    break;
                }
                String accessToken = RESTAPITestUtil.generateOAuthAccessToken(scope, dataMap, gatewayURL);
                if (accessToken == null) {
                    log.error((Object)"Failed to generate OAuth access token to test the REST API.");
                    isTestSuccess = false;
                    break;
                }
                JSONObject dataConfigurationObject = configObject.getJSONObject("data");
                String method = dataConfigurationObject.get("method").toString();
                String parametrizedResourceURL = keyMangerURL + dataConfigurationObject.get("url").toString();
                String actualResourceURL = this.replaceParameterPatternWithValues(parametrizedResourceURL, "\\{(.*?)\\}");
                HashMap<String, String> queryParameters = new HashMap<String, String>();
                String queryParameterText = dataConfigurationObject.get("query-parameters").toString();
                if (!queryParameterText.isEmpty()) {
                    Iterator queryParamIterator = dataConfigurationObject.getJSONObject("query-parameters").keys();
                    while (queryParamIterator.hasNext()) {
                        String key = queryParamIterator.next().toString();
                        String value = dataConfigurationObject.getJSONObject("query-parameters").getString(key);
                        queryParameters.put(key, value);
                    }
                }
                HashMap<String, String> requestHeaders = new HashMap<String, String>();
                String requestHeaderText = dataConfigurationObject.get("request-headers").toString();
                if (!requestHeaderText.isEmpty()) {
                    Iterator requestHeaderIterator = dataConfigurationObject.getJSONObject("request-headers").keys();
                    while (requestHeaderIterator.hasNext()) {
                        String key = requestHeaderIterator.next().toString();
                        String value = dataConfigurationObject.getJSONObject("request-headers").getString(key);
                        if ("Authorization".equalsIgnoreCase(key)) {
                            value = value.concat(" " + accessToken);
                        }
                        requestHeaders.put(key, value);
                    }
                }
                String parametrizedRequestPayload = dataConfigurationObject.get("request-payload").toString();
                String actualRequestPayload = this.replaceParameterPatternWithValues(parametrizedRequestPayload, "\\((.*?)\\)");
                String responseHeaderText = dataConfigurationObject.get("response-headers").toString();
                HashMap<String, String> responseHeaders = new HashMap<String, String>();
                if (!responseHeaderText.isEmpty()) {
                    Iterator responseHeaderIterator = dataConfigurationObject.getJSONObject("response-headers").keys();
                    while (responseHeaderIterator.hasNext()) {
                        String key = responseHeaderIterator.next().toString();
                        String value = dataConfigurationObject.getJSONObject("response-headers").getString(key);
                        responseHeaders.put(key, value);
                    }
                }
                String responsePayload = dataConfigurationObject.get("response-payload").toString();
                String cookie = null;
                Response responseOfHttpCall = this.dataDrivenTestUtils.sendRequestToRESTAPI(method, actualResourceURL, queryParameters, requestHeaders, actualRequestPayload, cookie);
                String outputText = (String)((ResponseImpl)responseOfHttpCall).readEntity(String.class);
                if (!configObject.isNull("preserve-list") && (preserveListArray = configObject.getJSONArray("preserve-list")) != null && preserveListArray.length() > 0) {
                    for (int j = 0; j < preserveListArray.length(); ++j) {
                        JSONObject preserveListObj = preserveListArray.getJSONObject(j);
                        String parameterName = preserveListObj.getString("attribute-name");
                        String responseType = preserveListObj.optString("response-structure");
                        if (responseType != null && !responseType.isEmpty()) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("response-type: " + responseType));
                            }
                            if (!"array".equals(responseType)) continue;
                            int objIndex = Integer.parseInt(preserveListObj.getString("object-index"));
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("object-index: " + objIndex));
                            }
                            JSONObject objAtIndexPosition = new JSONArray(outputText).getJSONObject(objIndex);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("object at index: " + objAtIndexPosition.toString()));
                            }
                            String parameterValue = objAtIndexPosition.getString(preserveListObj.getString("response-location"));
                            this.preservedAttributes.put(parameterName, parameterValue);
                            continue;
                        }
                        String parameterValue = new JSONObject(outputText).get(preserveListObj.getString("response-location")).toString();
                        this.preservedAttributes.put(parameterName, parameterValue);
                    }
                }
                if ((actualStatusCode = responseOfHttpCall.getStatus()) != (expectedStatusCode = configObject.getJSONObject("asserts").getJSONObject("header-asserts").getInt("status-code"))) {
                    isTestSuccess = false;
                    log.error((Object)("Expected HTTP Status Code and Actual Status Code does not match. Expected: \"" + expectedStatusCode + "\", actual: \"" + actualStatusCode + "\", response payload: " + outputText));
                    break;
                }
                JSONArray bodyAsserts = configObject.getJSONObject("asserts").getJSONArray("body-asserts");
                if (bodyAsserts != null && bodyAsserts.length() > 0) {
                    if (!StringUtils.isBlank((String)outputText)) {
                        for (int j = 0; j < bodyAsserts.length(); ++j) {
                            JSONObject bodyAssert = (JSONObject)bodyAsserts.get(j);
                            String jsonPath = bodyAssert.getString("jsonPath");
                            Object actualValue = JsonPath.read((String)outputText, (String)jsonPath, (Filter[])new Filter[0]);
                            if (bodyAssert.has("value")) {
                                Object expectedValue = bodyAssert.get("value");
                                if (expectedValue.equals(actualValue)) continue;
                                log.error((Object)("Json path actual value mismatches with expected value. jsonPath: \"" + jsonPath + "\", expected: <" + expectedValue.getClass().getSimpleName() + ">" + expectedValue + ", actual value: <" + actualValue.getClass().getSimpleName() + ">" + actualValue + ", response payload: " + outputText));
                                isTestSuccess = false;
                            } else {
                                String regex;
                                if (!bodyAssert.has("regex") || Pattern.matches(regex = bodyAssert.getString("regex"), actualValue + "")) continue;
                                log.error((Object)("Json path actual value mismatches with provided regex. jsonPath: \"" + jsonPath + "\", regex: \"" + regex + "\", actual value: \"" + actualValue + "\", response payload: " + outputText));
                                isTestSuccess = false;
                            }
                            break;
                        }
                    } else {
                        log.error((Object)"A body-assert is defined but no response payload found.");
                        isTestSuccess = false;
                    }
                }
                if (!isTestSuccess) break;
                JSONArray jSONArray = bodyNotAsserts = configObject.getJSONObject("asserts").has("body-not-asserts") ? configObject.getJSONObject("asserts").getJSONArray("body-not-asserts") : null;
                if (bodyNotAsserts != null && bodyNotAsserts.length() > 0) {
                    if (!StringUtils.isBlank((String)outputText)) {
                        for (int j = 0; j < bodyNotAsserts.length(); ++j) {
                            String bodyNotAssert = bodyNotAsserts.getString(j);
                            if (!outputText.contains(bodyNotAssert)) continue;
                            log.error((Object)("Un-expected response body received, Output expected to not contain" + bodyNotAssert + ", however response body received with the value."));
                            isTestSuccess = false;
                            break;
                        }
                    } else {
                        isTestSuccess = true;
                    }
                }
                if (isTestSuccess) {
                    continue;
                }
                break;
            }
        }
        catch (APIManagerIntegrationTestException integrationTestException) {
            log.error((Object)"Error occurred in sending request to the REST API.", (Throwable)integrationTestException);
            isTestSuccess = false;
        }
        catch (JSONException e) {
            log.error((Object)"Error occurred in parsing the data in JSON file.", (Throwable)e);
            isTestSuccess = false;
        }
        return isTestSuccess;
    }

    private String getConfigurations(String fileLocation) throws APIManagerIntegrationTestException {
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(new File(fileLocation)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException ioE) {
            log.error((Object)("IOException when reading configuration data:" + fileLocation), (Throwable)ioE);
            throw new APIManagerIntegrationTestException("Error in reading data from config file.", (Throwable)ioE);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error when closing the buffered reader which used to reed the file:" + fileLocation + ". Error:" + e.getMessage()));
                }
            }
        }
    }

    private String replaceParameterPatternWithValues(String parametrizedText, String regex) {
        String actualTextWithValues = parametrizedText;
        if (parametrizedText != null && regex != null && regex.length() > 1) {
            Pattern parameterPattern = Pattern.compile(regex);
            Matcher matcher = parameterPattern.matcher(parametrizedText);
            while (matcher.find()) {
                String parameterName = matcher.group(1);
                String template = Character.toString(regex.charAt(1)) + parameterName + Character.toString(regex.charAt(regex.length() - 1));
                actualTextWithValues = parametrizedText.replace(template, this.preservedAttributes.get(parameterName));
            }
        }
        return actualTextWithValues;
    }

    public static String generateOAuthAccessToken(String scope, Map<String, String> dataMap, String gatewayUrl) throws APIManagerIntegrationTestException {
        try {
            String consumeKey = dataMap.get("consumerKey");
            String consumerSecret = dataMap.get("consumerSecret");
            String messageBody = "grant_type=password&username=admin&password=admin&scope=" + scope;
            URL tokenEndpointURL = new URL(gatewayUrl + "token");
            HashMap<String, String> accessKeyMap = new HashMap<String, String>();
            String authenticationHeader = consumeKey + ":" + consumerSecret;
            byte[] encodedBytes = Base64.encodeBase64((byte[])authenticationHeader.getBytes("UTF-8"));
            accessKeyMap.put("Authorization", "Basic " + new String(encodedBytes, "UTF-8"));
            HttpResponse tokenGenerateResponse = HttpRequestUtil.doPost((URL)tokenEndpointURL, (String)messageBody, accessKeyMap);
            JSONObject tokenGenJsonObject = new JSONObject((Object)tokenGenerateResponse);
            String accessToken = new JSONObject(tokenGenJsonObject.get("data").toString()).get("access_token").toString();
            if (accessToken != null) {
                return accessToken;
            }
        }
        catch (MalformedURLException malformedURLException) {
            log.error((Object)"Error in getting the URL of token endpoint.", (Throwable)malformedURLException);
            throw new APIManagerIntegrationTestException("Error in getting the URL of token endpoint.", (Throwable)malformedURLException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)"Message header encoding was unsuccessful using UTF-8.", (Throwable)unsupportedEncodingException);
            throw new APIManagerIntegrationTestException("Message header encoding was unsuccessful using UTF-8.", (Throwable)unsupportedEncodingException);
        }
        catch (AutomationFrameworkException automationFrameworkException) {
            log.error((Object)"Error in sending the request to token endpoint.", (Throwable)automationFrameworkException);
            throw new APIManagerIntegrationTestException("Error in sending the request to token endpoint.", (Throwable)automationFrameworkException);
        }
        catch (JSONException e) {
            log.error((Object)"Error in parsing JSON content in response from token endpoint.", (Throwable)e);
            throw new APIManagerIntegrationTestException("Error in parsing JSON content in response from token endpoint.", (Throwable)e);
        }
        return null;
    }

    public static Map<String, String> registerOAuthApplication(String keyMangerUrl) throws APIManagerIntegrationTestException {
        String dcrEndpointURL = keyMangerUrl + "client-registration/v0.14/register";
        String randomClientName = RandomStringUtils.randomAlphabetic((int)5);
        String applicationRequestBody = "{\n\"callbackUrl\": \"www.google.lk\",\n\"clientName\": \"" + randomClientName + "\",\n" + "\"tokenScope\": \"Production\",\n" + "\"owner\": \"admin\",\n" + "\"grantType\": \"password refresh_token\",\n" + "\"saasApp\": true\n" + "}";
        HashMap<String, String> dcrRequestHeaders = new HashMap<String, String>();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        try {
            byte[] encodedBytes = Base64.encodeBase64((byte[])"admin:admin".getBytes("UTF-8"));
            dcrRequestHeaders.put("Authorization", "Basic " + new String(encodedBytes, "UTF-8"));
            dcrRequestHeaders.put("Content-Type", "application/json");
            JSONObject clientRegistrationResponse = new JSONObject((Object)HttpRequestUtil.doPost((URL)new URL(dcrEndpointURL), (String)applicationRequestBody, dcrRequestHeaders));
            String consumerKey = new JSONObject(clientRegistrationResponse.getString("data")).get("clientId").toString();
            String consumerSecret = new JSONObject(clientRegistrationResponse.getString("data")).get("clientSecret").toString();
            Thread.sleep(2000L);
            dataMap.put("consumerKey", consumerKey);
            dataMap.put("consumerSecret", consumerSecret);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)"Header encoding was unsuccessful while registering application.", (Throwable)unsupportedEncodingException);
            throw new APIManagerIntegrationTestException("Header encoding was unsuccessful while registering application.", (Throwable)unsupportedEncodingException);
        }
        catch (MalformedURLException malformedURLException) {
            log.error((Object)"Error in getting the DCR endpoint URL.", (Throwable)malformedURLException);
            throw new APIManagerIntegrationTestException("Error in getting the DCR endpoint URL.", (Throwable)malformedURLException);
        }
        catch (AutomationFrameworkException automationFrameworkException) {
            log.error((Object)"Error in sending request to the DCR endpoint.", (Throwable)automationFrameworkException);
            throw new APIManagerIntegrationTestException("Error in sending request to the DCR endpoint.", (Throwable)automationFrameworkException);
        }
        catch (JSONException e) {
            log.error((Object)"Error in parsing JSON to get consumer key/secret.", (Throwable)e);
            throw new APIManagerIntegrationTestException("Error in parsing JSON to get consumer key/secret.", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            log.error((Object)"Thread interrupted while waiting to get consumer key/secret.", (Throwable)interruptedException);
            throw new APIManagerIntegrationTestException("Thread interrupted while waiting to get consumer key/secret.", (Throwable)interruptedException);
        }
        return dataMap;
    }
}

