/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.token;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.xpath.XPathExpressionException;
import junit.framework.Assert;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class InvalidTokenTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(InvalidTokenTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private String provider;
    private static final String API_NAME = "InvalidTokenAPI";
    private static final String API_VERSION = "1.0.0";

    @Factory(dataProvider="userModeDataProvider")
    public InvalidTokenTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.apiPublisher = new APIPublisherRestClient(this.getPublisherURLHttp());
        this.provider = this.user.getUserName();
    }

    @Test(groups={"wso2.am"}, description="Check functionality of API access with invalid token")
    public void testAPIAccessWithInvalidToken() throws XPathExpressionException, APIManagerIntegrationTestException {
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        String apiContext = "invalidtokenapi";
        String endpointUrl = "http://localhost:8280/response";
        APIRequest apiRequest = null;
        try {
            apiRequest = new APIRequest(API_NAME, apiContext, new URL(endpointUrl));
        }
        catch (MalformedURLException e) {
            log.error((Object)("Invalid URL " + endpointUrl), (Throwable)e);
            org.testng.Assert.assertTrue((boolean)false);
        }
        apiRequest.setVersion(API_VERSION);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setProvider(this.provider);
        this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(API_NAME, this.user.getUserName(), APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        String apiInvocationUrl = this.getAPIInvocationURLHttp(apiContext, API_VERSION);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer abcdefgh");
        try {
            HttpResponse httpResponse = HttpRequestUtil.doGet((String)apiInvocationUrl, headers);
            Assert.assertNotNull((Object)httpResponse);
            Assert.assertEquals((int)401, (int)httpResponse.getResponseCode());
            String responsePayload = httpResponse.getData();
            Assert.assertNotNull((Object)responsePayload);
            OMElement element = AXIOMUtil.stringToOM((String)responsePayload);
            AXIOMXPath xpath = new AXIOMXPath("/ams:fault/ams:description");
            xpath.addNamespace("ams", "http://wso2.org/apimanager/security");
            Object descriptionElement = xpath.selectSingleNode((Object)element);
            Assert.assertNotNull((String)"Error message doesn't contain a 'description'", (Object)descriptionElement);
            String description = ((OMElement)descriptionElement).getText();
            Assert.assertTrue((String)("Unexpected error response string. Expected to have 'Make sure you have given the correct access token' but received '" + description + "'"), (boolean)description.contains("Make sure you have given the correct access token"));
        }
        catch (IOException e) {
            log.error((Object)("Error sending request to endpoint " + apiInvocationUrl), (Throwable)e);
            Assert.assertTrue((String)("Could not send request to endpoint " + apiInvocationUrl + ": " + e.getMessage()), (boolean)false);
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error parsing response XML ", (Throwable)e);
            Assert.assertTrue((String)("Error parsing response XML " + e.getMessage()), (boolean)false);
        }
        catch (JaxenException e) {
            log.error((Object)"XPath error when searching for 'description' element ", (Throwable)e);
            Assert.assertTrue((String)("XPath error when searching for 'description' element " + e.getMessage()), (boolean)false);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.apiPublisher != null) {
            this.apiPublisher.deleteAPI(API_NAME, API_VERSION, this.provider);
        }
        super.cleanUp();
    }
}

