/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.token;

import java.net.URL;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class TokenAPITestCase
extends APIMIntegrationBaseTest {
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private static final Log log = LogFactory.getLog(TokenAPITestCase.class);

    @Factory(dataProvider="userModeDataProvider")
    public TokenAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.apiPublisher = new APIPublisherRestClient(this.getPublisherURLHttp());
        this.apiStore = new APIStoreRestClient(this.getStoreURLHttp());
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Token API Test other")
    public void testTokenAPITestCase() throws Exception {
        String APIName = "TokenTestAPI";
        String APIContext = "tokenTestAPI";
        String tags = "youtube, token, media";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        String description = "This is test API create by API manager integration test";
        String providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url), new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setSandbox(url);
        apiRequest.setProvider(this.user.getUserName());
        this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        String gatewayUrl = this.getAPIInvocationURLHttp("tokenTestAPI/1.0.0/customers/123");
        this.apiStore.addApplication("TokenTestAPI-Application", "Unlimited", "", "this-is-test");
        String provider = this.storeContext.getContextTenant().getContextUser().getUserName();
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(APIName, provider);
        subscriptionRequest.setTier("Gold");
        subscriptionRequest.setApplicationName("TokenTestAPI-Application");
        this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequestSandBox = new APPKeyRequestGenerator("TokenTestAPI-Application");
        generateAppKeyRequestSandBox.setKeyType("SANDBOX");
        String responseStringSandBox = this.apiStore.generateApplicationKey(generateAppKeyRequestSandBox).getData();
        JSONObject responseSandBOX = new JSONObject(responseStringSandBox);
        String SANDbOXAccessToken = responseSandBOX.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        HashMap<String, String> requestHeadersSandBox = new HashMap<String, String>();
        requestHeadersSandBox.put("Authorization", "Bearer " + SANDbOXAccessToken);
        HttpResponse youTubeResponseSandBox = HttpRequestUtil.doGet((String)gatewayUrl, requestHeadersSandBox);
        log.info((Object)("Response " + youTubeResponseSandBox));
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("TokenTestAPI-Application");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String accessToken = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        String consumerKey = response.getJSONObject("data").getJSONObject("key").getString("consumerKey");
        String consumerSecret = response.getJSONObject("data").getJSONObject("key").getString("consumerSecret");
        Thread.sleep(2000L);
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=admin&scope=PRODUCTION";
        URL tokenEndpointURL = new URL(this.getGatewayURLNhttp() + "token");
        JSONObject accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
        String userAccessToken = accessTokenGenerationResponse.getString("access_token");
        String refreshToken = accessTokenGenerationResponse.getString("refresh_token");
        log.info((Object)refreshToken);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + userAccessToken);
        requestHeaders.put("accept", "text/xml");
        Thread.sleep(2000L);
        HttpResponse youTubeResponse = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        Assert.assertEquals((int)youTubeResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<name"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponse.getData().contains("<Customer>"), (String)"Response data mismatched");
        requestHeaders.clear();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("accept", "text/xml");
        HttpResponse youTubeResponseWithApplicationToken = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        Assert.assertEquals((int)youTubeResponseWithApplicationToken.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched");
        Assert.assertTrue((boolean)youTubeResponseWithApplicationToken.getData().contains("John"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponseWithApplicationToken.getData().contains("<name>"), (String)"Response data mismatched");
        Assert.assertTrue((boolean)youTubeResponseWithApplicationToken.getData().contains("<Customer>"), (String)"Response data mismatched");
        HttpResponse youTubeResponseWithApplicationTokenHttps = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        log.info((Object)("Response " + youTubeResponseWithApplicationTokenHttps));
        Assert.assertEquals((int)youTubeResponseWithApplicationTokenHttps.getResponseCode(), (int)200, (String)"Response code mismatched");
        HttpResponse errorResponse = null;
        errorResponse = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        log.info((Object)("Error response " + errorResponse));
        this.apiPublisher.revokeAccessToken(accessToken, consumerKey, providerName);
        requestHeaders.clear();
        requestHeaders.put("Authorization", "Bearer this-is-incorrect-token");
        requestHeaders.put("accept", "text/xml");
        errorResponse = HttpRequestUtil.doGet((String)gatewayUrl, requestHeaders);
        Assert.assertEquals((int)errorResponse.getResponseCode(), (int)401, (String)"Response code mismatched while token API test case");
        try {
            errorResponse = HttpRequestUtil.doGet((String)this.getAPIInvocationURLHttp("tokenTestAPI/1.0.0/most_popular"), requestHeaders);
            log.info((Object)("Error Response " + errorResponse));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((int)errorResponse.getResponseCode(), (int)401, (String)"Response code mismatched while token API test case");
    }

    @Test(groups={"wso2.am"}, description="Token equality test")
    public void testTokenEqualityBeforeExpiration() throws Exception {
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.addApplication("TokenTestApp", "Unlimited", "", "this-is-test");
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("TokenTestApp");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject jsonResponse = new JSONObject(responseString);
        String consumerKey = jsonResponse.getJSONObject("data").getJSONObject("key").getString("consumerKey");
        String consumerSecret = jsonResponse.getJSONObject("data").getJSONObject("key").getString("consumerSecret");
        URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=default";
        HttpResponse firstResponse = this.apiStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        JSONObject firstAccessTokenGenerationResponse = new JSONObject(firstResponse.getData());
        String firstAccessToken = firstAccessTokenGenerationResponse.getString("access_token");
        HttpResponse secondResponse = this.apiStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        JSONObject secondAccessTokenGenerationResponse = new JSONObject(secondResponse.getData());
        String secondAccessToken = secondAccessTokenGenerationResponse.getString("access_token");
        Assert.assertEquals((String)firstAccessToken, (String)secondAccessToken, (String)"Token mismatch while generating access token twice.");
    }

    @Test(groups={"wso2.am"}, description="JWT Token API Test other")
    public void testJWTTokenAPITestCase() throws Exception {
        String APIName = "JWTTokenTestAPI";
        String APIContext = "jwtTokenTestAPI";
        String tags = "jwt, token";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        String description = "This is test API create by API manager integration test";
        String providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        String APIVersion = "1.0.0";
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url), new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setSandbox(url);
        apiRequest.setProvider(this.user.getUserName());
        this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Thread.sleep(10000L);
        this.apiStore.addApplicationWithTokenType("JWTTokenTestAPI-Application", "Unlimited", "", "this-is-test", "JWT");
        String provider = this.storeContext.getContextTenant().getContextUser().getUserName();
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(APIName, provider);
        subscriptionRequest.setTier("Gold");
        subscriptionRequest.setApplicationName("JWTTokenTestAPI-Application");
        this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequestSandBox = new APPKeyRequestGenerator("JWTTokenTestAPI-Application");
        generateAppKeyRequestSandBox.setKeyType("SANDBOX");
        String responseStringSandBox = this.apiStore.generateApplicationKey(generateAppKeyRequestSandBox).getData();
        JSONObject responseSandBOX = new JSONObject(responseStringSandBox);
        String sandboxJWT = responseSandBOX.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)sandboxJWT);
        JSONObject jsonObject1 = new JSONObject(decodedJWTString);
        String claim1 = jsonObject1.getString("application");
        JSONObject jsonSubObject = new JSONObject(claim1);
        Assert.assertEquals((Object)jsonSubObject.get("name"), (Object)"JWTTokenTestAPI-Application");
        Assert.assertEquals((Object)jsonSubObject.get("tier"), (Object)"Unlimited");
        Assert.assertTrue((boolean)jsonSubObject.get("owner").toString().contains("admin"));
        String claim2 = jsonObject1.getString("subscribedAPIs");
        JSONArray jsonArray = new JSONArray(claim2);
        JSONObject jsonSubObject2 = (JSONObject)jsonArray.get(0);
        Assert.assertEquals((Object)jsonSubObject2.get("name"), (Object)"JWTTokenTestAPI");
        Assert.assertEquals((Object)jsonSubObject2.get("context"), (Object)"/jwtTokenTestAPI/1.0.0");
        Assert.assertEquals((Object)jsonSubObject2.get("version"), (Object)"1.0.0");
        Assert.assertTrue((boolean)jsonSubObject2.get("publisher").toString().contains("admin"));
        Assert.assertEquals((Object)jsonSubObject2.get("subscriptionTier"), (Object)"Gold");
        Assert.assertEquals((Object)jsonSubObject2.get("subscriberTenantDomain"), (Object)"carbon.super");
        String claim3 = jsonObject1.getString("keytype");
        Assert.assertEquals((String)"SANDBOX", (String)claim3);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("JWTTokenTestAPI-Application");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject response = new JSONObject(responseString);
        String productionJWT = response.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        String decodedProductionJWTString = APIMTestCaseUtils.getDecodedJWT((String)productionJWT);
        JSONObject jsonObject2 = new JSONObject(decodedProductionJWTString);
        String claim4 = jsonObject2.getString("keytype");
        Assert.assertEquals((String)"PRODUCTION", (String)claim4);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication("TokenTestAPI-Application");
        super.cleanUp();
    }
}

