/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.version;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.webapp.WebAppAdminClient;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.generic.TestConfigurationProvider;
import org.wso2.am.integration.test.utils.http.HttpRequestUtil;
import org.wso2.am.integration.test.utils.webapp.WebAppDeploymentUtil;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM372PublishNewCopyGivenDeprecateOldVersionTestCase
extends APIMIntegrationBaseTest {
    private final String apiName = "APIM372DeprecateTestAPI";
    private final String apiVersionOld = "1.0.0";
    private final String apiVersionNew = "1.0.1";
    private final String applicationName = "APIM372DeprecateAPI";
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String providerNameApi;
    private String apiProductionEndPointUrl;
    private APIIdentifier apiIdentifierOldVersion;
    private APIIdentifier apiIdentifierNewVersion;
    private HashMap<String, String> requestHeadersGet;
    private HashMap<String, String> requestHeadersPost;
    private HashMap<String, String> requestHeadersPut;
    private HashMap<String, String> requestHeadersDelete;

    @Factory(dataProvider="userModeDataProvider")
    public APIM372PublishNewCopyGivenDeprecateOldVersionTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/";
        String productionWebAppName = "jaxrs_basic";
        String sourcePathProd = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + productionWebAppName + ".war";
        String sessionId = this.createSession(this.gatewayContextWrk);
        WebAppAdminClient webAppAdminClient = new WebAppAdminClient(this.gatewayContextWrk.getContextUrls().getBackEndUrl(), sessionId);
        webAppAdminClient.uploadWarFile(sourcePathProd);
        boolean isWebAppDeployProd = WebAppDeploymentUtil.isWebApplicationDeployed((String)this.gatewayContextWrk.getContextUrls().getBackEndUrl(), (String)sessionId, (String)productionWebAppName);
        Assert.assertTrue((boolean)isWebAppDeployProd, (String)(productionWebAppName + " is not deployed"));
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.apiProductionEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.providerNameApi = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiIdentifierOldVersion = new APIIdentifier(this.providerNameApi, "APIM372DeprecateTestAPI", "1.0.0");
        this.apiIdentifierNewVersion = new APIIdentifier(this.providerNameApi, "APIM372DeprecateTestAPI", "1.0.1");
        this.requestHeadersGet = new HashMap();
        this.requestHeadersGet.put("accept", "text/xml");
        this.requestHeadersPost = new HashMap();
        this.requestHeadersPost.put("accept", "text/xml");
        this.requestHeadersPost.put("Content-Type", "text/xml");
        this.requestHeadersPut = new HashMap();
        this.requestHeadersPut.put("accept", "text/xml");
        this.requestHeadersPut.put("Content-Type", "text/xml");
        this.requestHeadersDelete = new HashMap();
        this.requestHeadersDelete.put("accept", "text/xml");
    }

    @Test(groups={"wso2.am"}, description="Check whether user can publish new copy for the  given deprecate old versions option")
    public void testPublishNewCopyGivenDeprecateOldVersion() throws Exception {
        String apiContext = "apim372deprecateTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTag = "tag372-1, tag372-2, tag372-3";
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM372DeprecateTestAPI", apiContext, "1.0.0", this.providerNameApi, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setTags(apiTag);
        apiCreationRequestBean.setDescription(apiDescription);
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", "Unlimited", "/*"));
        resourceBeanList.add(new APIResourceBean("POST", "Application & Application User", "Unlimited", "/*"));
        resourceBeanList.add(new APIResourceBean("PUT", "Application & Application User", "Unlimited", "/*"));
        resourceBeanList.add(new APIResourceBean("DELETE", "Application & Application User", "Unlimited", "/*"));
        apiCreationRequestBean.setResourceBeanList(resourceBeanList);
        HttpResponse apiCreationResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        JSONObject jsonObjectCreation = new JSONObject(apiCreationResponse.getData());
        Assert.assertFalse((boolean)jsonObjectCreation.getBoolean("error"), (String)"APIM372DeprecateTestAPIis not created");
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("APIM372DeprecateTestAPI", this.providerNameApi, APILifeCycleState.PUBLISHED);
        HttpResponse creationResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertTrue((boolean)creationResponse.getData().contains("PUBLISHED"), (String)"APIM372DeprecateTestAPI is not Published ");
        HttpResponse appResponse = this.apiStore.addApplication("APIM372DeprecateAPI", "Gold", "", "");
        JSONObject appJsonObject = new JSONObject(appResponse.getData());
        Assert.assertFalse((boolean)appJsonObject.getBoolean("error"), (String)"APIM372DeprecateAPI is not created in Store");
        Assert.assertEquals((String)appJsonObject.getString("status"), (String)"APPROVED", (String)"APIM372DeprecateAPI is not created in Store");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest("APIM372DeprecateTestAPI", this.providerNameApi);
        subscriptionRequest.setApplicationName("APIM372DeprecateAPI");
        HttpResponse subscriptionResponse = this.apiStore.subscribe(subscriptionRequest);
        Assert.assertEquals((int)subscriptionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"APIM372DeprecateTestAPI  has not been subscribed");
        HttpResponse copyApiResponse = this.apiPublisher.copyAPI(this.providerNameApi, "APIM372DeprecateTestAPI", "1.0.0", "1.0.1", null);
        JSONObject jsonObjectCopyApi = new JSONObject(copyApiResponse.getData());
        Assert.assertFalse((boolean)jsonObjectCopyApi.getBoolean("error"), (String)"APIM372DeprecateTestAPI is not copied");
        APILifeCycleStateRequest lifeCycleStateRequest = new APILifeCycleStateRequest("APIM372DeprecateTestAPI", this.providerNameApi, APILifeCycleState.PUBLISHED);
        lifeCycleStateRequest.setVersion("1.0.1");
        lifeCycleStateRequest.setDeprecateOldVersions("true");
        this.apiPublisher.changeAPILifeCycleStatus(lifeCycleStateRequest);
        HttpResponse originalApiResponse = this.apiPublisher.getAPI("APIM372DeprecateTestAPI", this.providerNameApi, "1.0.0");
        Assert.assertTrue((boolean)originalApiResponse.getData().contains("1.0.0"), (String)"Version of the original APIM372DeprecateTestAPI has been updated with new version");
        Assert.assertTrue((boolean)originalApiResponse.getData().contains("DEPRECATED"), (String)"Status of the original APIM372DeprecateTestAPI has not been changed as DEPRECATED");
        HttpResponse newApiResponse = this.apiPublisher.getAPI("APIM372DeprecateTestAPI", this.providerNameApi, "1.0.1");
        Assert.assertTrue((boolean)newApiResponse.getData().contains("1.0.1"), (String)"Version of the Copied API has not been updated with the new version");
        Assert.assertTrue((boolean)newApiResponse.getData().contains("PUBLISHED"), (String)"Status of the new APIM372DeprecateTestAPI has not been changed as PUBLISHED");
        List publishedAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getAllPublishedAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierNewVersion, (List)publishedAPIList), (String)"APIM372DeprecateTestAPI  with the new Version is not available in store");
        Assert.assertFalse((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)this.apiIdentifierOldVersion, (List)publishedAPIList), (String)"APIM372DeprecateTestAPI with the Old Version is available in store");
        JSONObject subscribedApi = new JSONObject(this.apiStore.getSubscribedAPIs("APIM372DeprecateAPI").getData()).getJSONObject("subscriptions");
        JSONArray jsonArray = subscribedApi.getJSONArray("applications");
        JSONObject jsonObjectDepApi = (JSONObject)jsonArray.get(0);
        JSONArray jsonArrayApiList = jsonObjectDepApi.getJSONArray("subscriptions");
        JSONObject deprecateApi = (JSONObject)jsonArrayApiList.get(0);
        Assert.assertEquals((String)deprecateApi.getString("status"), (String)"DEPRECATED", (String)"Invalid Status of the Deprecated API");
        Assert.assertEquals((String)deprecateApi.getString("version"), (String)"1.0.0", (String)"Invalid Version of the Deprecated API");
        Assert.assertEquals((String)deprecateApi.getString("name"), (String)"APIM372DeprecateTestAPI", (String)"Invalid name of the Deprecated API");
        JSONObject publishApi = (JSONObject)jsonArrayApiList.get(1);
        Assert.assertEquals((String)publishApi.getString("status"), (String)"PUBLISHED", (String)"Invalid Status of the Newly published API");
        Assert.assertEquals((String)publishApi.getString("version"), (String)"1.0.1", (String)"Invalid Version of the Newly published API");
        Assert.assertEquals((String)publishApi.getString("name"), (String)"APIM372DeprecateTestAPI", (String)"Invalid name of the Newly published API");
        APPKeyRequestGenerator appKeyRequestGenerator = new APPKeyRequestGenerator("APIM372DeprecateAPI");
        String response = this.apiStore.generateApplicationKey(appKeyRequestGenerator).getData();
        JSONObject jsonObject = new JSONObject(response);
        String accessToken = jsonObject.getJSONObject("data").getJSONObject("key").get("accessToken").toString();
        this.requestHeadersGet.put("Authorization", "Bearer " + accessToken);
        this.requestHeadersPost.put("Authorization", "Bearer " + accessToken);
        this.requestHeadersPut.put("Authorization", "Bearer " + accessToken);
        this.requestHeadersDelete.put("Authorization", "Bearer " + accessToken);
        HttpResponse oldApiResponseGet = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.0") + "/customers/123"), this.requestHeadersGet);
        Thread.sleep(15000L);
        Assert.assertEquals((int)oldApiResponseGet.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when Old version api invocation for GET Request");
        Assert.assertTrue((boolean)oldApiResponseGet.getData().contains("<Customer><id>123</id><name>John</name></Customer>"), (String)"Response data mismatched when old version api invocation for GET Request");
        HttpResponse oldApiResponsePost = HttpRequestUtil.doPost((URL)new URL(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.0") + "/customers/"), (String)"<Customer><name>Jack</name></Customer>", this.requestHeadersPost);
        Thread.sleep(12000L);
        Assert.assertEquals((int)oldApiResponsePost.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when Old version api invocation for POST Request");
        Assert.assertTrue((boolean)oldApiResponsePost.getData().contains("<Customer><id>124</id><name>Jack</name></Customer>"), (String)"New Customer Record is not added as expected for the POST Request");
        HttpResponse oldApiResponseGetPost = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.0") + "/customers/124"), this.requestHeadersGet);
        Thread.sleep(12000L);
        Assert.assertEquals((int)oldApiResponseGetPost.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Assert.assertTrue((boolean)oldApiResponseGetPost.getData().contains("<Customer><id>124</id><name>Jack</name></Customer>"), (String)"Response data mismatched when api invocation for GET Request");
        HttpResponse oldApiResponsePut = HttpRequestUtil.doPut((URL)new URL(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.0") + "/customers/"), (String)"<Customer><id>124</id><name>Tom</name></Customer>", this.requestHeadersPut);
        Assert.assertEquals((int)oldApiResponsePut.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation for PUT Request");
        HttpResponse oldApiResponseGetPut = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.0") + "/customers/124"), this.requestHeadersGet);
        Assert.assertEquals((int)oldApiResponseGetPut.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Assert.assertTrue((boolean)oldApiResponseGetPut.getData().contains("<Customer><id>124</id><name>Tom</name></Customer>"), (String)"Response data mismatched when api invocation for GET Request");
        int oldApiResponseDelete = HttpRequestUtil.doDelete((URL)new URL(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.0") + "/customers/124"), this.requestHeadersDelete);
        Assert.assertEquals((int)oldApiResponseDelete, (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation for DELETE Request");
        HttpResponse oldApiResponseGetDelete = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.0") + "/customers/124"), this.requestHeadersGet);
        Assert.assertEquals((int)oldApiResponseGetDelete.getResponseCode(), (int)Response.Status.NO_CONTENT.getStatusCode(), (String)"Response code mismatched when old version of the api invocation for GET request after delete the requested data");
        HttpResponse newApiResponseGet = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1") + "/customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)newApiResponseGet.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when New version api invocation for GET Request");
        Assert.assertTrue((boolean)newApiResponseGet.getData().contains("<Customer><id>123</id><name>John</name></Customer>"), (String)"Response data mismatched when New version api invocation for GET Request");
        HttpResponse newApiResponsePost = HttpRequestUtil.doPost((URL)new URL(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1") + "/customers/"), (String)"<Customer><name>Evin</name></Customer>", this.requestHeadersPost);
        Assert.assertEquals((int)newApiResponsePost.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when New version api invocation for POST Request");
        Assert.assertTrue((boolean)newApiResponsePost.getData().contains("<Customer><id>125</id><name>Evin</name></Customer>"), (String)"New Customer Record is not added as expected for the POST Request");
        HttpResponse newApiResponseGetPost = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1") + "/customers/125"), this.requestHeadersGet);
        Assert.assertEquals((int)newApiResponseGetPost.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when New version of the api invocation for GET Request");
        Assert.assertTrue((boolean)newApiResponseGetPost.getData().contains("<Customer><id>125</id><name>Evin</name></Customer>"), (String)"Response data mismatched when New version of the api invocation for GET Request");
        HttpResponse newApiResponsePut = HttpRequestUtil.doPut((URL)new URL(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1") + "/customers/"), (String)"<Customer><id>125</id><name>James</name></Customer>", this.requestHeadersPut);
        Assert.assertEquals((int)newApiResponsePut.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when New version of the api invocation for PUT Request");
        HttpResponse newApiResponseGetPut = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1") + "/customers/125"), this.requestHeadersGet);
        Assert.assertEquals((int)newApiResponseGetPut.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when New version of the api invocation for GET Request");
        Assert.assertTrue((boolean)newApiResponseGetPut.getData().contains("<Customer><id>125</id><name>James</name></Customer>"), (String)"Response data mismatched when New version of the api invocation for GET Request");
        int newApiResponseDelete = HttpRequestUtil.doDelete((URL)new URL(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1") + "/customers/125"), this.requestHeadersDelete);
        Assert.assertEquals((int)newApiResponseDelete, (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when new version of the api invocation for DELETE Request");
        HttpResponse newApiResponseGetDelete = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp(apiContext + "/" + "1.0.1") + "/customers/125"), this.requestHeadersGet);
        Assert.assertEquals((int)newApiResponseGetDelete.getResponseCode(), (int)Response.Status.NO_CONTENT.getStatusCode(), (String)"Response code mismatched when new version of the api invocation for GET request after delete the requested data");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.apiStore.removeAPISubscriptionByName("APIM372DeprecateTestAPI", "1.0.0", this.providerNameApi, "APIM372DeprecateAPI");
        this.apiStore.removeAPISubscriptionByName("APIM372DeprecateTestAPI", "1.0.1", this.providerNameApi, "APIM372DeprecateAPI");
        this.apiStore.removeApplication("APIM372DeprecateAPI");
        this.apiPublisher.deleteAPI("APIM372DeprecateTestAPI", "1.0.0", this.providerNameApi);
        this.apiPublisher.deleteAPI("APIM372DeprecateTestAPI", "1.0.1", this.providerNameApi);
        super.cleanUp();
    }
}

