/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.version;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class DefaultVersionAPITestCase
extends APIMIntegrationBaseTest {
    public static final String DEFAULT_VERSION_APP = "DefaultVersionAPP" + (int)(Math.random() * 100.0 + 1.0);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String gatewaySessionCookie;
    private String provider;

    @Factory(dataProvider="userModeDataProvider")
    public DefaultVersionAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        this.apiPublisher = new APIPublisherRestClient(this.getPublisherURLHttp());
        this.apiStore = new APIStoreRestClient(this.getStoreURLHttp());
        this.provider = this.user.getUserName();
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "dummy_api.xml", this.gatewayContextMgt, this.gatewaySessionCookie);
        }
    }

    @Test(groups={"wso2.am"}, description="Check functionality of the default version API")
    public void testDefaultVersionAPI() throws Exception {
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        String apiName = "DefaultVersionAPI";
        String apiVersion = "1.0.0";
        String apiContext = "defaultversion";
        String endpointUrl = this.getGatewayURLNhttp() + "response";
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(endpointUrl));
        apiRequest.setDefault_version("default_version");
        apiRequest.setDefault_version_checked("default_version");
        apiRequest.setVersion(apiVersion);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setProvider(this.provider);
        HttpResponse response = this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, this.user.getUserName(), APILifeCycleState.PUBLISHED);
        response = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        response = this.apiStore.addApplication("DefaultVersionAPP", "Unlimited", "", "");
        this.verifyResponse(response);
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiName, apiVersion, this.provider, "DefaultVersionAPP", "Unlimited");
        response = this.apiStore.subscribe(subscriptionRequest);
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("DefaultVersionAPP");
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        JSONObject jsonResponse = new JSONObject(responseString);
        String accessToken = jsonResponse.getJSONObject("data").getJSONObject("key").getString("accessToken");
        String apiInvocationUrl = this.getAPIInvocationURLHttp(apiContext);
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        HttpResponse directResponse = HttpRequestUtil.doGet((String)endpointUrl, new HashMap());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "Bearer " + accessToken);
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        HttpResponse httpResponse = HttpRequestUtil.doGet((String)apiInvocationUrl, headers);
        Assert.assertEquals((String)httpResponse.getData(), (String)directResponse.getData(), (String)"Default version API test failed while invoking the API.");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

