/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.version;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;

public class DefaultVersionWithScopesTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(DefaultVersionWithScopesTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private static final String API_NAME = "DefaultVersionScopeAPI";
    private static final String API_VERSION = "1.0.0";
    private static final String API_PROVIDER = "admin";
    private static final String APP_NAME = "DefVersionScopeApp";
    private static final String USER_SAM = "sam";
    private static final String USER_MIKE = "mike";
    private static final String SUBSCRIBER_ROLE = "subscriber";

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
        this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "dummy_api.xml", this.gatewayContextMgt, this.createSession(this.gatewayContextMgt));
    }

    @Test(groups={"wso2.am"}, description="Check functionality of the default version API with scopes")
    public void testDefaultVersionAPIWithScopes() throws UserAdminUserAdminException, RemoteException, XPathExpressionException, APIManagerIntegrationTestException {
        try {
            this.userManagementClient.addRole(SUBSCRIBER_ROLE, new String[0], new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"});
            this.userManagementClient.addUser(USER_MIKE, "mike123", new String[0], USER_MIKE);
            this.userManagementClient.addUser(USER_SAM, "sam123", new String[]{SUBSCRIBER_ROLE}, USER_SAM);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error while creating UserManagementClient " + axisFault.getMessage()));
            Assert.assertTrue((boolean)false, (String)axisFault.getMessage());
        }
        catch (RemoteException e) {
            log.error((Object)("Error while adding role 'subscriber' or user 'mike'" + e.getMessage()));
            Assert.assertTrue((boolean)false, (String)e.getMessage());
        }
        catch (UserAdminUserAdminException e) {
            log.error((Object)("Error while adding role 'subscriber' or user 'mike'" + e.getMessage()));
            Assert.assertTrue((boolean)false, (String)e.getMessage());
        }
        String apiProviderPassword = API_PROVIDER;
        String apiContext = "defaultversionscope";
        String endpointUrl = "http://localhost:8280/response";
        APIRequest apiRequest = null;
        try {
            apiRequest = new APIRequest(API_NAME, apiContext, new URL(endpointUrl));
        }
        catch (MalformedURLException e) {
            log.error((Object)("Invalid URL " + endpointUrl), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        apiRequest.setDefault_version("default_version");
        apiRequest.setDefault_version_checked("default_version");
        apiRequest.setVersion(API_VERSION);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        try {
            this.apiPublisher.login(API_PROVIDER, apiProviderPassword);
            this.apiPublisher.addAPI(apiRequest);
            APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(API_NAME, API_PROVIDER, APILifeCycleState.PUBLISHED);
            this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
            String modifiedResource = "{\"apiVersion\":\"1.0.0\",\"swaggerVersion\":\"1.2\",\"authorizations\":{\"oauth2\":{\"scopes\":[{\"description\":\"\", \"name\":\"admin_scope\",\"roles\":\"admin\",\"key\":\"admin_scope\"},{\"description\":\"\",\"name\":\"user_scope\",\"roles\":\"subscriber\",\"key\":\"user_scope\"}],\"type\":\"oauth2\"}},\"apis\":[{\"index\":0,\"file\":{\"apiVersion\":\"1.0.0\",\"swaggerVersion\":\"1.2\",\"resourcePath\":\"/default\",\"apis\":[{\"index\":0,\"path\":\"/*\",\"operations\":[{\"scope\":\"user_scope\",\"auth_type\":\"Application User\",\"throttling_tier\":\"Unlimited\",\"method\":\"GET\",\"parameters\":[]},{\"scope\":\"\",\"auth_type\":\"Application User\",\"throttling_tier\":\"Unlimited\",\"method\":\"POST\",\"parameters\":[]},{\"scope\":\"\",\"auth_type\":\"Application User\",\"throttling_tier\":\"Unlimited\",\"method\":\"PUT\",\"parameters\":[]},{\"auth_type\":\"Application User\",\"throttling_tier\":\"Unlimited\",\"method\":\"DELETE\",\"parameters\":[]},{\"auth_type\":\"None\",\"throttling_tier\":\"Unlimited\",\"method\":\"OPTIONS\",\"parameters\":[]}]}]},\"description\":\"\",\"path\":\"/default\"}],\"info\":{\"title\":\"DefaultVersionScopeAPI\",\"termsOfServiceUrl\":\"\",\"description\":\"\",\"license\":\"\",\"contact\":\"\",\"licenseUrl\":\"\"}}";
            this.apiPublisher.updateResourceOfAPI(API_PROVIDER, API_NAME, API_VERSION, modifiedResource);
            this.apiStore.login(API_PROVIDER, API_PROVIDER);
            this.apiStore.addApplication(APP_NAME, "Unlimited", "", "");
            SubscriptionRequest subscriptionRequest = new SubscriptionRequest(API_NAME, API_PROVIDER);
            subscriptionRequest.setApplicationName(APP_NAME);
            this.apiStore.subscribe(subscriptionRequest);
            APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(APP_NAME);
            String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
            JSONObject jsonResponse = new JSONObject(responseString);
            String consumerKey = jsonResponse.getJSONObject("data").getJSONObject("key").getString("consumerKey");
            String consumerSecret = jsonResponse.getJSONObject("data").getJSONObject("key").getString("consumerSecret");
            URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttps() + "token");
            String requestBody = "grant_type=password&username=sam&password=sam123&scope=user_scope";
            JSONObject accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
            String accessToken = accessTokenGenerationResponse.getString("access_token");
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            requestHeaders.put("Authorization", "Bearer " + accessToken);
            HttpResponse response = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + "defaultversionscope"), requestHeaders);
            Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)("sam cannot access the GET Method. Response = " + response.getData()));
            requestBody = "grant_type=password&username=mike&password=mike123&scope=user_scope";
            accessTokenGenerationResponse = new JSONObject(this.apiStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
            accessToken = accessTokenGenerationResponse.getString("access_token");
            requestHeaders = new HashMap();
            requestHeaders.put("Authorization", "Bearer " + accessToken);
            response = HttpRequestUtil.doGet((String)(this.gatewayUrlsWrk.getWebAppURLNhttp() + "defaultversionscope"), requestHeaders);
            Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)("Mike should receive an HTTP 403 when trying to access the GET resource. But the response code was " + response.getResponseCode()));
        }
        catch (Exception e) {
            log.error((Object)("Error while executing test case " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false, (String)e.getMessage());
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.apiStore != null) {
            this.apiStore.removeApplication(APP_NAME);
        }
        if (this.apiPublisher != null) {
            this.apiPublisher.deleteAPI(API_NAME, API_VERSION, API_PROVIDER);
        }
        if (this.userManagementClient != null) {
            this.userManagementClient.deleteUser(USER_SAM);
            this.userManagementClient.deleteUser(USER_MIKE);
            this.userManagementClient.deleteRole(SUBSCRIBER_ROLE);
        }
        super.cleanUp();
    }
}

