/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.websocket;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIMANAGER5869WSGayewatURLTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APIMANAGER5869WSGayewatURLTestCase.class);
    private final String API_NAME = "WSGayewatURLAPIName";
    private final String API_CONTEXT = "WSGayewatURLContext";
    private final String WS_API_NAME = "WSGayewatURLWSAPIName";
    private final String WS_API_CONTEXT = "WSGayewatURLWSContext";
    private final String DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION = "1.0.0";
    private final String TIER_COLLECTION = "Unlimited";
    private String publisherURLHttps;
    private String storeURLHttp;
    private APICreationRequestBean apiCreationRequestBean;
    private List<APIResourceBean> resList;
    private String endpointUrl;
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private ServerConfigurationManager serverConfigurationManager;

    @Factory(dataProvider="userModeDataProvider")
    public APIMANAGER5869WSGayewatURLTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.publisherURLHttps = this.publisherUrls.getWebAppURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttps);
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
    }

    @Test(groups={"wso2.am"}, description="Sample API creation")
    public void testAPICreation() throws Exception {
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("WSGayewatURLAPIName", "WSGayewatURLContext", "1.0.0", providerName, new URL(this.endpointUrl));
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTiersCollection("Unlimited");
        this.resList = new ArrayList<APIResourceBean>();
        APIResourceBean res1 = new APIResourceBean("GET", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType(), "20KPerMin", "/add");
        this.resList.add(res1);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        HttpResponse serviceResponse = this.apiPublisher.addAPI(this.apiCreationRequestBean);
        this.verifyResponse(serviceResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("WSGayewatURLAPIName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        serviceResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.verifyResponse(serviceResponse);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "WSGayewatURLAPIName", "1.0.0", "\"isApiExists\":true");
    }

    @Test(description="Publish WebSocket API", dependsOnMethods={"testAPICreation"})
    public void publishWebSocketAPI() throws Exception {
        this.apiPublisher = new APIPublisherRestClient(this.getPublisherURLHttp());
        this.apiStore = new APIStoreRestClient(this.getStoreURLHttp());
        String provider = this.user.getUserName();
        URI endpointUri = new URI("ws://echo.websocket.org");
        APIRequest apiRequest = new APIRequest("WSGayewatURLWSAPIName", "WSGayewatURLWSContext", endpointUri, endpointUri);
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setProvider(provider);
        apiRequest.setType("WS");
        this.apiPublisher.login(this.user.getUserName(), this.user.getPassword());
        HttpResponse addAPIResponse = this.apiPublisher.addAPI(apiRequest);
        this.verifyResponse(addAPIResponse);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest("WSGayewatURLWSAPIName", this.user.getUserName(), APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "WSGayewatURLWSAPIName", "1.0.0", "\"isApiExists\":true");
        APIIdentifier apiIdentifierWebSocket = new APIIdentifier(provider, "WSGayewatURLWSAPIName", "1.0.0");
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        String apiEndPoint = TestUserMode.SUPER_TENANT_ADMIN.equals((Object)this.userMode) || TestUserMode.SUPER_TENANT_USER.equals((Object)this.userMode) ? this.getWebSocketAPIInvocationURL("WSGayewatURLWSContext", "1.0.0") : this.getWebSocketTenantAPIInvocationURL("WSGayewatURLWSContext", "1.0.0", this.user.getUserDomain());
        this.log.info((Object)("API Endpoint URL" + apiEndPoint));
        List publisherAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiPublisher.getAllAPIs());
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)apiIdentifierWebSocket, (List)publisherAPIList), (String)"Published API is visible in API Publisher.");
        List storeAPIList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((HttpResponse)this.apiStore.getAllPaginatedPublishedAPIs(this.storeContext.getContextTenant().getDomain(), 0, 100));
        Assert.assertTrue((boolean)APIMTestCaseUtils.isAPIAvailable((APIIdentifier)apiIdentifierWebSocket, (List)storeAPIList), (String)"Published API is visible in API Store.");
    }

    @Test(groups={"wso2.am"}, description="Test API gateway urls", dependsOnMethods={"publishWebSocketAPI"})
    public void testApiGatewayUrlsTest() throws Exception {
        String provider = this.user.getUserName();
        HttpResponse serviceResponse = HTTPSClientUtils.doGet((String)(this.getStoreURLHttps() + "store/apis/info?name=" + "WSGayewatURLAPIName" + "&version=" + "1.0.0" + "&provider=" + provider), null);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"HTTP status code mismatched");
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            Assert.assertTrue((boolean)serviceResponse.getData().matches("(.)*\"http://(.)+:[0-9]+/WSGayewatURLContext/1.0.0\"(.)*"));
            Assert.assertTrue((boolean)serviceResponse.getData().matches("(.)*\"https://(.)+:[0-9]+/WSGayewatURLContext/1.0.0\"(.)*"));
        } else {
            Assert.assertTrue((boolean)serviceResponse.getData().matches("(.)*\"http://(.)+:[0-9]+/t/wso2.com/WSGayewatURLContext/1.0.0\"(.)*"));
            Assert.assertTrue((boolean)serviceResponse.getData().matches("(.)*\"https://(.)+:[0-9]+/t/wso2.com/WSGayewatURLContext/1.0.0\"(.)*"));
        }
        serviceResponse = HTTPSClientUtils.doGet((String)(this.getStoreURLHttps() + "store/apis/info?name=" + "WSGayewatURLWSAPIName" + "&version=" + "1.0.0" + "&provider=" + provider), null);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"HTTP status code mismatched");
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            Assert.assertTrue((boolean)serviceResponse.getData().matches("(.)*\"ws://(.)+:[0-9]+/WSGayewatURLWSContext/1.0.0\"(.)*"));
        } else {
            Assert.assertTrue((boolean)serviceResponse.getData().matches("(.)*\"ws://(.)+:[0-9]+/t/wso2.com/WSGayewatURLWSContext/1.0.0\"(.)*"));
        }
    }

    @Test(groups={"wso2.am"}, description="Test WS API gateway urls", dependsOnMethods={"testApiGatewayUrlsTest"})
    public void testApiGatewayUrlsAfterConfigChangeTest() throws Exception {
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextWrk);
            this.serverConfigurationManager.applyConfiguration(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "webSocketTest" + File.separator + "api-manager.xml"));
        }
        String provider = this.user.getUserName();
        HttpResponse serviceResponse = HTTPSClientUtils.doGet((String)(this.getStoreURLHttps() + "store/apis/info?name=" + "WSGayewatURLAPIName" + "&version=" + "1.0.0" + "&provider=" + provider), null);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"HTTP status code mismatched");
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            Assert.assertTrue((boolean)serviceResponse.getData().contains("https://serverhost:9898/WSGayewatURLContext/1.0.0"));
            Assert.assertFalse((boolean)serviceResponse.getData().matches("(.)*\"http://(.)+:[0-9]+/WSGayewatURLContext/1.0.0\"(.)*"));
        } else {
            Assert.assertTrue((boolean)serviceResponse.getData().contains("https://serverhost:9898/t/wso2.com/WSGayewatURLContext/1.0.0"));
            Assert.assertFalse((boolean)serviceResponse.getData().matches("(.)*\"http://(.)+:[0-9]+/t/wso2.com/WSGayewatURLContext/1.0.0\"(.)*"));
        }
        serviceResponse = HTTPSClientUtils.doGet((String)(this.getStoreURLHttps() + "store/apis/info?name=" + "WSGayewatURLWSAPIName" + "&version=" + "1.0.0" + "&provider=" + provider), null);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"HTTP status code mismatched");
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            Assert.assertTrue((boolean)serviceResponse.getData().contains("ws://localhost:9099/WSGayewatURLWSContext/1.0.0"));
        } else {
            Assert.assertTrue((boolean)serviceResponse.getData().contains("ws://localhost:9099/t/wso2.com/WSGayewatURLWSContext/1.0.0"));
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            this.serverConfigurationManager.restoreToLastConfiguration(true);
        }
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

